!{\src2tex{textfont=tt}}
!!****f* ABINIT/get_all_gkq
!!
!! NAME
!! get_all_gkq
!!
!! FUNCTION
!! This routine determines what to do with the initial qspace
!!   matrix elements of the electron phonon coupling (to disk or in memory),
!!   then reads those given in the gkk file and completes them
!!   (for kpts, then perturbations)
!!   01/2010: removed completion on qpoints here (MJV)
!!
!! COPYRIGHT
!! Copyright (C) 2004-2010 ABINIT group (MVer, MG)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   elph_ds = elphon datastructure with data and dimensions
!!   FSfullpqtofull = mapping of k+q to another k
!!   kphon_full2full = mapping of FS kpoints under symops
!!   kpt_phon = fermi surface kpoints
!!   %k_phon%wtk = integration weights for bands and kpoints near the FS
!!   gkk_flag = flag to
!!   gprimd = reciprocal space lattice vectors
!!   indsym = mapping of atoms under symops
!!   natom = number of atoms
!!   nband = number of bands
!!   nsym = number of symmetries
!!   n1wf = number of file headers from perturbation calculations
!!      which are present in the initial gkk input file.
!!   onegkksize = size of one record of the new gkk output file, in bytes
!!   phon_ds = phonon datastructure for interpolation of eigen vec and val
!!   qpttoqpt = mapping of qpoints onto each other under symmetries
!!   rprimd = real space lattice vectors (dimensionful)
!!   symrec = reciprocal space symops
!!   symrel = real space symops
!!   tnons = translation vectors associated to symrel
!!   unitgkk = fortran unit for initial gkk input file
!!   xred = reduced coordinates of atoms
!!
!! OUTPUT
!!   elph_ds%gkq = recip space elphon matrix elements.
!!
!! NOTES
!!
!! PARENTS
!!      elphon
!!
!! CHILDREN
!!      complete_gkk,leave_new,read_gkk,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine get_all_gkq (elph_ds,FSfullpqtofull, &
&    gkk_flag,gprimd,indsym,natom,nband,nsym,n1wf,onegkksize,phon_ds, &
&    qpttoqpt,rprimd,symrec,symrel,tnons,ep_prt_yambo,unitgkk)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon
 use m_io_tools

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_77_ddb, except_this_one => get_all_gkq
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: n1wf,natom,nband,nsym,onegkksize
 integer,intent(in) :: unitgkk
 integer,intent(in) :: ep_prt_yambo
 type(elph_type),intent(inout) :: elph_ds
 type(phon_type),intent(inout) :: phon_ds
!arrays
 integer,intent(in) :: indsym(4,nsym,natom)
 integer,intent(in) :: FSfullpqtofull(elph_ds%k_phon%nkpt,elph_ds%nqpt_full)
 integer,intent(in) :: qpttoqpt(2,nsym,elph_ds%nqpt_full),symrec(3,3,nsym)
 integer,intent(in) :: symrel(3,3,nsym)
 integer,intent(inout) :: gkk_flag(elph_ds%nbranch,elph_ds%nbranch,elph_ds%k_phon%nkpt,elph_ds%nsppol,elph_ds%nqptirred)
 real(dp),intent(in) :: gprimd(3,3),rprimd(3,3),tnons(3,nsym)

!Local variables-------------------------------
!scalars
 integer :: ierr,iost
 character(len=500) :: message
 character(len=fnlen) :: fname
!arrays

! *************************************************************************

!attribute file unit number
 elph_ds%unitgkq = get_unit()

!============================================
!save gkk for all qpts in memory or to disk
!============================================

!DEBUG
!write (*,*) ' 4 bytes / ??'
!write (*,*) ' kind(real) = ', kind(one)
!write (*,*) ' elph_ds%ngkkband = ', elph_ds%ngkkband, '^2'
!write (*,*) ' elph_ds%nbranch = ', elph_ds%nbranch, '^2'
!write (*,*) ' elph_ds%k_phon%nkpt = ', elph_ds%k_phon%nkpt
!write (*,*) ' elph_ds%nsppol = ', elph_ds%nsppol
!write (*,*) ' elph_ds%nqptirred ', elph_ds%nqptirred
!ENDDEBUG

 write(message,'(a,f14.4,a)')&
& ' get_all_gkq : gkq file/array size = ',&
 4.0*dble(onegkksize)*dble(elph_ds%k_phon%nkpt)*dble(elph_ds%nqptirred)/1024.0_dp/1024.0_dp/1024.0_dp,' Gb'
 call wrtout(std_out,message,'COLL')

 if (elph_ds%gkqwrite == 0) then !calculate gkk(q) keeping all in memory

   write(message,'(a)')' get_all_gkq : keep gkk(q) in memory '
   call wrtout(std_out,message,'COLL')

   allocate(elph_ds%gkk_qpt(2,elph_ds%ngkkband*elph_ds%ngkkband,&
&   elph_ds%nbranch*elph_ds%nbranch,elph_ds%k_phon%nkpt,elph_ds%nsppol,elph_ds%nqptirred),stat=ierr)
   if (ierr /= 0 ) then 
     write (message,'(3a)')' get_all_gkq : ERROR- ',ch10,&
&     ' trying to allocate array elph_ds%gkk_qpt '
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
   end if

   elph_ds%gkk_qpt(:,:,:,:,:,:) = zero

 else if (elph_ds%gkqwrite == 1) then !calculate gkk(q) and write to file
   
   fname=trim(elph_ds%elph_base_name) // '_GKKQ'
   open (unit=elph_ds%unitgkq,file=fname,access='direct',recl=onegkksize,&
&   form='unformatted',iostat=iost)
   if (iost /= 0) then
     write (message,'(2a)')' get_all_gkq : ERROR- opening file ',trim(fname)
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
   end if
   
   write (message,'(5a)')&
&   ' get_all_gkq : gkq matrix elements  will be written to file : ',trim(fname),ch10,&
&   ' Nothing is in files yet',ch10
   call wrtout(std_out,message,'COLL')

 else
   write(message,'(4a,i4)')ch10,&
&   ' get_all_gkq : BUG- ',ch10,&
&   ' gkqwrite must be 0 or 1 while it is : ',elph_ds%gkqwrite
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if !if gkqwrite

!=====================================================
!read in g_kk matrix elements for all bands, kpoints,
!and calculated qpoints
!=====================================================

 write(message,'(a)')' get_all_gkq : calling read_gkk to read in the g_kk matrix elements' 
 call wrtout(std_out,message,'COLL')

 call read_gkk(elph_ds,FSfullpqtofull,&
& gkk_flag,gprimd,indsym,n1wf,natom,nband,nsym,&
& phon_ds,symrec,symrel,tnons,ep_prt_yambo,&
& unitgkk)

 write (message,'(2a)')ch10,' get_all_gkq : out of read_gkk'
 call wrtout(std_out,message,'COLL')


!if (elph_ds%symgkq ==1) then
!MJV 01/2010 removed the completion on qpt here: it should be done after FS integration
!so that everything is lighter in memory etc... (only irred qpt)
 if (0==1) then

!  ==============================================================
!  complete gkk matrices for other qpoints on the full grid qpt_full
!  inspired and cannibalized from symdm9.f
!  FIXME: should add the possibility to copy over to other qpoints,
!  without full symmetrization, for testing purposes.
!  ==============================================================

   write(message,'(4a)')ch10,&
&   ' get_all_gkq : calling complete_gkk to complete ',ch10,&
&   ' gkk matrices for other qpoints on the full grid'
   call wrtout(std_out,message,'COLL')

   call complete_gkk(elph_ds,gkk_flag,gprimd,indsym,&
&   natom,nsym,qpttoqpt,rprimd,&
&   symrec,symrel)

   write (message,'(2a)')ch10,' get_all_gkq : out of complete_gkk'
   call wrtout(std_out,message,'COLL')

 end if !symgkq

end subroutine get_all_gkq
!!***
