!{\src2tex{textfont=tt}}
!!****f* ABINIT/integrate_gamma
!!
!! NAME
!! integrate_gamma
!!
!! FUNCTION
!! This routine integrates the electron phonon coupling matrix
!! over the kpoints on the fermi surface. A dependency on qpoint
!! remains for gamma_qpt
!!
!! COPYRIGHT
!! Copyright (C) 2004-2010 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   elph_ds = elphon datastructure with data and dimensions
!!      elph_ds%qpt_full = qpoint coordinates
!!      elph_ds%nqptirred = number of irred qpoints
!!      elph_ds%qirredtofull = indexing of the GKK qpoints found
!!   FSfullpqtofull = mapping of k+q to k
!!   nrpt = number of real space points for FT
!!
!! OUTPUT
!!   elph_ds = modified elph_ds%gamma_qpt and created elph_ds%gamma_rpt
!!
!! NOTES
!!
!! PARENTS
!!      elphon
!!
!! CHILDREN
!!      get_rank_1kpt,leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine integrate_gamma(elph_ds,FSfullpqtofull,nrpt)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon
 use m_kptrank

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer, intent(in) :: nrpt
 type(elph_type),intent(inout) :: elph_ds
!arrays
 integer,intent(in) :: FSfullpqtofull(elph_ds%k_phon%nkpt,elph_ds%nqpt_full)

!Local variables-------------------------------
!scalars
 integer :: ikpt_phon,ikpt_phonq,ib1,ib2,ibeff,ierr,iqpt,iqpt_fullbz,isppol
 integer :: irec, symrankkpt_phon
 character(len=500) :: message
 character(len=fnlen) :: fname
!arrays
 real(dp),allocatable :: tmp_gkk(:,:,:,:)

! *************************************************************************

 write (message,'(3a)')ch10,' entering integrate_gamma ',ch10
 call wrtout(std_out,message,'COLL')

 allocate(elph_ds%gamma_qpt(2,elph_ds%nbranch*elph_ds%nbranch,elph_ds%nsppol,elph_ds%nqpt_full),stat=ierr)
 if (ierr /= 0 ) then
   write (message,'(3a)')' integrate_gamma : ERROR- ',ch10,&
&   ' trying to allocate array elph_ds%gamma_qpt '
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if
 elph_ds%gamma_qpt(:,:,:,:) = zero

 allocate (elph_ds%gamma_rpt(2,elph_ds%nbranch*elph_ds%nbranch,elph_ds%nsppol,nrpt),stat=ierr)
 if (ierr /= 0 ) then
   write (message,'(3a)')' integrate_gamma : ERROR- ',ch10,&
&   ' trying to allocate array elph_ds%gamma_rpt '
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if
 elph_ds%gamma_rpt(:,:,:,:) = zero

 allocate (tmp_gkk (2,elph_ds%ngkkband*elph_ds%ngkkband,elph_ds%nbranch*elph_ds%nbranch,&
& elph_ds%nsppol),stat=ierr)
 if (ierr /= 0 ) then
   write (message,'(3a)')' integrate_gamma : ERROR- ',ch10,&
&   ' trying to allocate array tmp_gkk '
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

 if (elph_ds%gkqwrite == 0) then
   write (message,'(a)')' integrate_gamma : keeping gamma matrices in memory'
   call wrtout(std_out,message,'COLL')
 else if (elph_ds%gkqwrite == 1) then
   fname=trim(elph_ds%elph_base_name) // '_GKKQ'
   write (message,'(2a)')' integrate_gamma : reading gamma matrices from file ',trim(fname)
   call wrtout(std_out,message,'COLL')
 else
   write (message,'(3a,i3)')' integrate_gamma : BUG-',ch10,&
&   ' Wrong value for gkqwrite = ',elph_ds%gkqwrite
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if



 do iqpt=1,elph_ds%nqptirred
   iqpt_fullbz = elph_ds%qirredtofull(iqpt)
!  DEBUG
   call get_rank_1kpt (elph_ds%k_phon%kpt(:,iqpt_fullbz),symrankkpt_phon, elph_ds%k_phon%kptrank_t)
   write (*,*) ' iqpt_fullbz in qpt grid only,  rank ', iqpt_fullbz, symrankkpt_phon
!  ENDDEBUG

   do ikpt_phon=1,elph_ds%k_phon%nkpt
     if (elph_ds%gkqwrite == 0) then
       tmp_gkk = elph_ds%gkk_qpt(:,:,:,ikpt_phon,:,iqpt)
     else if (elph_ds%gkqwrite == 1) then
       irec = (iqpt-1)*elph_ds%k_phon%nkpt+ikpt_phon
       if (ikpt_phon == 1) then
         write (*,*) ' integrate_gamma  read record ', irec
       end if
       read (elph_ds%unitgkq,REC=irec) tmp_gkk(:,:,:,:)
     end if

     do isppol=1,elph_ds%nsppol
       ikpt_phonq = FSfullpqtofull(ikpt_phon,iqpt_fullbz)
       do ib1=1,elph_ds%ngkkband
         do ib2=1,elph_ds%ngkkband
           ibeff = ib2+(ib1-1)*elph_ds%ngkkband
           elph_ds%gamma_qpt(:,:,isppol,iqpt_fullbz) = elph_ds%gamma_qpt(:,:,isppol,iqpt_fullbz) + &
&           tmp_gkk(:,ibeff,:,isppol)&
&           *elph_ds%gkk_intweight(ib1,ikpt_phon,isppol)*elph_ds%gkk_intweight(ib2,ikpt_phonq,isppol)
!          NOTE: if ngkkband==1 we are using trivial weights since average
!          over bands was done in normsq_gkk (nmsq_gam_sumFS or nmsq_pure_gkk)
         end do
       end do
     end do
   end do
 end do
 deallocate (tmp_gkk)

!need prefactor of 1/nkpt for each integration over 1 kpoint index.
!NOT INCLUDED IN elph_ds%gkk_intweight
 do iqpt=1,elph_ds%nqptirred
   iqpt_fullbz = elph_ds%qirredtofull(iqpt)
!  elph_ds%gamma_qpt(:,:,:,iqpt_fullbz) = elph_ds%gamma_qpt(:,:,:,iqpt_fullbz) / elph_ds%k_phon%nkpt / n0(1) / n0(1)
!  elph_ds%gamma_qpt(:,:,:,iqpt_fullbz) = elph_ds%gamma_qpt(:,:,:,iqpt_fullbz) / elph_ds%k_phon%nkpt / elph_ds%k_phon%nkpt
   elph_ds%gamma_qpt(:,:,:,iqpt_fullbz) = elph_ds%gamma_qpt(:,:,:,iqpt_fullbz) * elph_ds%occ_factor / elph_ds%k_phon%nkpt
 end do

 write (message,'(a,a)') ' integrate_gamma : gamma matrices have been calculated',&
& 'for recip space and irred qpoints '

end subroutine integrate_gamma
!!***
