!{\src2tex{textfont=tt}}
!!****f* ABINIT/lin_interpq_gam
!!
!! NAME
!! lin_interpq_gam
!!
!! FUNCTION
!! This routine interpolates the electron phonon coupling matrix
!! to a give _qpoint_ by linear methods
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   elph_ds = elphon datastructure with data and dimensions
!!   qpt = q-point in reciprocal space for interpolation
!!
!! OUTPUT
!!   gam_now = interpolated gamma matrix at qpt
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine lin_interpq_gam(elph_ds,gam_now,isppol,kptrlatt,qpt)


 use defs_basis
 use defs_elphon

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(elph_type),intent(inout) :: elph_ds
 integer, intent(in) :: isppol
!arrays
 integer, intent(in) :: kptrlatt(3,3)
 real(dp), intent(in) :: qpt(3)
 real(dp), intent(out) :: gam_now(2,elph_ds%nbranch*elph_ds%nbranch)

!Local variables-------------------------------
!scalars
 integer :: ibranch
 real(dp) :: gam_intp, res
!arrays
 real(dp) :: qpt_incube(3)


! *************************************************************************

!the array gamma_qpt has dimensions: (2,elph_ds%nbranch*elph_ds%nbranch,elph_ds%nsppol,elph_ds%k_fine%nkpt)

 call wrap2_zero_one(qpt(1),qpt_incube(1),res)
 call wrap2_zero_one(qpt(2),qpt_incube(2),res)
 call wrap2_zero_one(qpt(3),qpt_incube(3),res)
 
 do ibranch=1, elph_ds%nbranch*elph_ds%nbranch
   call interpol3d(qpt_incube,kptrlatt(1,1),kptrlatt(2,2),kptrlatt(3,3),gam_intp,elph_ds%gamma_qpt(1,ibranch,isppol,:))
   gam_now(1,ibranch) = gam_intp

   call interpol3d(qpt_incube,kptrlatt(1,1),kptrlatt(2,2),kptrlatt(3,3),gam_intp,elph_ds%gamma_qpt(2,ibranch,isppol,:))
   gam_now(2,ibranch) = gam_intp
 end do

end subroutine lin_interpq_gam
!!***
