!!****f* ABINIT/mkphbs
!!
!! NAME
!! mkphbs
!!
!! FUNCTION
!! Function to calculate the phonon band structure, from the IFC
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (XG,MJV)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! acell(3) =length scales by which rprim is to be multiplied
!! amu(ntypat)=mass of the atoms (atomic mass unit)
!! anaddb_dtset= (derived datatype) contains all the input variables
!! atmfrc(2,3,natom,3,natom,nrpt) = Interatomic Forces in real space
!! dielt(3,3)=dielectric tensor
!! dyewq0(3,3,natom)=Ewald part of the dynamical matrix, at q=0.
!! gmet(3,3)= metric tensor in reciprocal space.
!! gprim(3,3)=normalized coordinates in reciprocal space
!! indsym(4,nsym,natom)=label given by subroutine symatm, indicating atom
!!  label which gets rotated into given atom by given symmetry
!!  (first three elements are related primitive translation--
!!  see symatm where this is computed)
!! mpert =maximum number of ipert
!! msym = maximum number of symmetries
!! natom=number of atoms in the unit cell
!! nrpt=number of R points in the Big Box
!! nsym=number of symmetries
!! ntypat=number of atom types
!! rmet(3,3)=metric tensor in real space.
!! rprim(3,3)=dimensionless primitive translations in real space
!! rpt(3,nprt)=canonical coordinates of the R points in the unit cell
!!  These coordinates are normalized (=> * acell(3)!!)
!! symrel(3,3,nsym)=symmetry operations
!! tcpui=initial cpu time
!! trans(3,natom)=atomic translations : xred = rcan + trans
!! twalli=initial wall clock time
!! typat(natom)=integer label of each type of atom (1,2,...)
!! ucvol=unit cell volume
!! wghatm(natom,natom,nrpt)=weights associated to a pair of atoms and to a R vector
!! xred(3,natom)= relative coords of atoms in unit cell (dimensionless)
!! zeff(3,3,natom)=effective charge on each atom, versus electric
!!  field and atomic displacement
!!
!! OUTPUT
!!
!! NOTES
!! 
!! PARENTS
!!      anaddb
!!
!! CHILDREN
!!      asria9,asrprs,gtblk9,gtdyn9,make_path,outlwf9,phfrq3,prtph3,sortph
!!      symph3,timein,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine mkphbs(acell,amu,anaddb_dtset,atmfrc,blkflg,blknrm,blkqpt,blktyp,blkval,&
& d2asr,dielt,dyewq0,eigvec_thmeig,outfile_radix,gmet,gprim,indsym,iodyn,&
& mpert,msize,msym,natom,nblok,nrpt,nsym,ntypat,&
& phfreq_thmeig,qtol,rmet,rprim,rprimd,rpt,singular,symrel,tcpui,  &
& trans,twalli,typat,ucvol,uinvers,vtinvers,wghatm,xcart,xred,zeff)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_io_tools
 use m_bz_mesh

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_18_timing
 use interfaces_72_response
 use interfaces_77_ddb, except_this_one => mkphbs
!End of the abilint section

 implicit none

!Arguments -------------------------------
!scalars

 type(anaddb_dataset_type),intent(in) :: anaddb_dtset

 integer,intent(in) :: mpert,msym,natom,nrpt,nsym,ntypat
 integer,intent(in) :: iodyn,msize
 integer,intent(in) :: nblok

 real(dp),intent(in) :: tcpui,twalli,ucvol, qtol

!arrays
 integer,intent(in) :: indsym(4,nsym,natom),symrel(3,3,nsym)
 integer,intent(in) :: typat(natom)

 character(len=fnlen),intent(in) :: outfile_radix

 real(dp),intent(in) :: acell(3),amu(ntypat),dielt(3,3),gmet(3,3),gprim(3,3)
 real(dp),intent(in) :: rmet(3,3),rprim(3,3),rprimd(3,3),rpt(3,nrpt)
 real(dp),intent(in) :: trans(3,natom),wghatm(natom,natom,nrpt),xcart(3,natom),xred(3,natom)
 real(dp),intent(in) :: zeff(3,3,natom)
 real(dp),intent(inout) :: atmfrc(2,3,natom,3,natom,nrpt),dyewq0(3,3,natom)
 real(dp),intent(inout) :: phfreq_thmeig(3*natom,anaddb_dtset%nph1l)
 real(dp),intent(inout) :: eigvec_thmeig(2,3,natom,3*natom,anaddb_dtset%nph1l)

 real(dp),intent(inout) :: singular(1:3*natom*(3*natom-1)/2)
 real(dp),intent(inout) :: uinvers(1:3*natom*(3*natom-1)/2,1:3*natom*(3*natom-1)/2)
 real(dp),intent(inout) :: vtinvers(1:3*natom*(3*natom-1)/2,1:3*natom*(3*natom-1)/2)

 integer, intent(in) :: blkflg(msize,nblok)
 integer, intent(in) :: blktyp(nblok)

 real(dp),intent(in) :: blknrm(3,nblok)
 real(dp),intent(in) :: blkqpt(9,nblok)
 real(dp),intent(in) :: blkval(2,msize,nblok)
 real(dp),intent(inout) :: d2asr(2,3,natom,3,natom)

!Local variables -------------------------
 integer :: phfrq_unit, phvec_unit, iphl1, iblok
 integer :: rftyp, index1, ii, jj
 integer :: idir, jdir
 integer,parameter :: udispl=19,ufreq=18

 real(dp) :: tcpu, twall

 integer :: rfphon(4)
 integer :: rfelfd(4)
 integer :: rfstrs(4)

 real(dp) :: qphnrm(3), qphon(3,3)
 real(dp) :: d2cart(2,msize)

 real(dp) :: displ(2*3*natom*3*natom)
 real(dp) :: eigval(3,natom)

 real(dp), allocatable :: phfrq(:)
 real(dp), allocatable :: eigvec(:,:,:,:,:)

 character(len=fnlen) :: phonon_freq_filename, phonon_vec_filename
 character(len=fnlen) :: tmpfilename
 character(500) :: message

 integer :: nfineqpath
 integer, allocatable :: ndiv(:)
 real(dp), pointer :: fineqpath(:,:)

! *********************************************************************

!DEBUG
!write(6,*)' mkphbs : enter '
!call flush(6) 
!ENDDEBUG

 nullify(fineqpath)
 nfineqpath = anaddb_dtset%nph1l
 fineqpath => anaddb_dtset%qph1l

 if(anaddb_dtset%nph1l==0) then
   if (anaddb_dtset%nqpath==0) then
!    if there is nothing to do, return
     return
   else
!    allow override of nph1l with nqpath if the former is not set
     allocate(ndiv(anaddb_dtset%nqpath-1))
     call make_path(anaddb_dtset%nqpath,anaddb_dtset%qpath,gmet,'G',20,ndiv,nfineqpath,fineqpath)
   end if
 end if


 write(message, '(a,(80a),a,a,a,a)' ) ch10,('=',ii=1,80),ch10,&
& ch10,' Treat the first list of vectors ',ch10
 call wrtout(std_out,message,'COLL')
 call wrtout(ab_out,message,'COLL')

 call timein(tcpu,twall)
 write(message, '(a,f11.3,a,f11.3,a)' )&
& '-begin at tcpu',tcpu-tcpui,'  and twall',twall-twalli,' sec'
 call wrtout(std_out,message,'COLL')
 call wrtout(ab_out,message,'COLL')

!Write some information in the lwf-formatted file
 if (anaddb_dtset%eivec==3) then
   call outlwf9(acell,iodyn,msym,natom,nfineqpath,nsym,ntypat,rprim,symrel,typat,xred)
 end if

 if (anaddb_dtset%outscphon == 1) then
!  open and write header for phonon frequency file
   phfrq_unit=get_unit()
   phonon_freq_filename = trim(outfile_radix)//"_PHFRQ"
   open (unit=phfrq_unit,file=phonon_freq_filename)
   write (phfrq_unit,*) '#'
   write (phfrq_unit,*) '# phonon frequencies (in Ha) on fineqpath list of qpoints'
   write (phfrq_unit,*) '#'

!  open and write header for phonon frequency file
   phvec_unit=get_unit()
   phonon_vec_filename = trim(outfile_radix)//"_PHVEC"
   open (unit=phvec_unit,file=phonon_vec_filename)
   write (phvec_unit,*) '#'
   write (phvec_unit,*) '# phonon eigenvectors (dimensionless) on fineqpath list of qpoints'
   write (phvec_unit,*) '#'
 end if

 allocate(phfrq(3*natom))
 allocate(eigvec(2,3,natom,3,natom))

 qphnrm = one

 do iphl1=1, nfineqpath

!  Initialisation of the phonon wavevector
   qphon(:,1)=fineqpath(:,iphl1)
   if (anaddb_dtset%nph1l /= 0) then
     qphnrm(1) = anaddb_dtset%qnrml1(iphl1)
   end if

!  Generation of the dynamical matrix in cartesian coordinates
   if(anaddb_dtset%ifcflag==1)then

!    Get d2cart using the interatomic forces and the
!    long-range coulomb interaction through Ewald summation
     write(message, '(a)' )' mkphbs    : enter gtdyn9 '
     call wrtout(std_out,message,'COLL')

     call timein(tcpu,twall)
     write(message, '(a,f11.3,a,f11.3,a)' )&
&     '-begin at tcpu',tcpu-tcpui,'  and twall',twall-twalli,' sec'
     call wrtout(std_out,message,'COLL')
     call gtdyn9(acell,atmfrc,dielt,anaddb_dtset%dipdip,&
&     dyewq0,d2cart,gmet,gprim,mpert,natom,&
&     nrpt,qphnrm(1),qphon,rmet,rprim,rpt,&
&     trans,ucvol,wghatm,xred,zeff)

   else if(anaddb_dtset%ifcflag==0)then

!    Look for the information in the DDB (no interpolation here!)
     rfphon(1:2)=1
     rfelfd(1:2)=0
     rfstrs(1:2)=0
     rftyp=anaddb_dtset%rfmeth
     call gtblk9(blkflg,blknrm,blkqpt,blktyp,iblok,mpert,msize,natom,nblok,&
&     qphon,qphnrm,qtol,rfphon,rfelfd,rfstrs,rftyp)

!    Copy the dynamical matrix in d2cart
     d2cart(:,1:msize)=blkval(:,:,iblok)

!    Eventually impose the acoustic sum rule based on previously calculated d2asr
     if (anaddb_dtset%asr==1 .or. anaddb_dtset%asr==2 .or. anaddb_dtset%asr==5) then
       call asria9(anaddb_dtset%asr,2,d2asr,d2cart,mpert,natom)
     end if

!    Impose acoustic sum rule plus rotational symmetry for 0D and 1D systems
     if (anaddb_dtset%asr==3 .or. anaddb_dtset%asr==4) then
       call asrprs(anaddb_dtset%asr,2,3,uinvers,vtinvers,singular,d2cart,mpert,natom,xcart)
     end if
   end if

!  Calculation of the eigenvectors and eigenvalues
!  of the dynamical matrix
   write(message, '(a)' )' mkphbs    : enter phfrq3 '
   call wrtout(std_out,message,'COLL')

   call timein(tcpu,twall)
   write(message, '(a,f11.3,a,f11.3,a)' )&
&   '-begin at tcpu',tcpu-tcpui,'  and twall',twall-twalli,' sec'
   call wrtout(std_out,message,'COLL')
   write(*,*) ' in mkphbs with start phfrq3'
   call phfrq3(amu,displ,d2cart,eigval,eigvec,indsym,&
&   mpert,msym,natom,nsym,ntypat,phfrq,qphnrm(1),qphon,&
&   rprimd,anaddb_dtset%symdynmat,symrel,typat,ucvol)

   if(anaddb_dtset%thmflag==3 .or. anaddb_dtset%thmflag==4) then
     phfreq_thmeig(:,iphl1) = phfrq(:)
     index1 = 0
     do ii=1,natom
       do jj=1,3
         index1=index1+1
         eigvec_thmeig(:,:,:,index1,iphl1) = eigvec(:,:,:,jj,ii)
       end do
     end do
   end if

!  DEBUG
!  write(6,*)' mkphbs : before sortph '
!  call flush(6) 
!  ENDDEBUG

!  In case eivec == 4, write output files for band2eps
!  (visualization of phonon band structures)
   if (anaddb_dtset%eivec == 4) then
     tmpfilename = trim(outfile_radix)//"_B2EPS"
     call sortph(eigvec,displ,tmpfilename,natom,phfrq,udispl,ufreq)
   end if

!  DEBUG
!  write(6,*)' mkphbs : after sortph '
!  call flush(6)
!  ENDDEBUG

!  Write the phonon frequencies
   write(message, '(a)' )' mkphbs    : enter prtph3 '
   call wrtout(std_out,message,'COLL')

   call timein(tcpu,twall)
   write(message, '(a,f11.3,a,f11.3,a)' )&
&   '-begin at tcpu',tcpu-tcpui,'  and twall',twall-twalli,' sec'
   call wrtout(std_out,message,'COLL')
   call prtph3(displ,anaddb_dtset%eivec,anaddb_dtset%enunit,iodyn,ab_out,natom,phfrq,qphnrm(1),qphon)

   if (anaddb_dtset%outscphon == 1) then
!    write to file - present version of prtph3 is not atomic enough to do this and
!    has lots of other junk etc...
     write (phfrq_unit,'(i6)',ADVANCE='NO') iphl1
     do ii=1,3*natom
       write (phfrq_unit,'(E16.8,2x)',ADVANCE='NO') phfrq(ii)
     end do
     write (phfrq_unit,*)

!    write phonon eigenvectors to file
!    dimensions of eigvec are eigvec(2,3,natom,3,natom))
     write (phvec_unit,'(i6)',ADVANCE='NO') iphl1
     do ii=1,natom
       do idir=1,3
         do jj=1,natom
           do jdir=1,3
             write (phvec_unit,'(2E25.15,2x)',ADVANCE='NO') eigvec(:,jdir,jj,idir,ii)
           end do
         end do
       end do
     end do
     write (phvec_unit,*)
   end if 

!  Determine the symmetries of the phonon mode at Gamma
   if(sum(abs(qphon(:,1)))<qtol)then
     call symph3(ab_out,acell,eigvec,indsym,natom,nsym,phfrq,rprim,symrel)
   end if

 end do

 if (anaddb_dtset%outscphon == 1) then
!  close unit for phonon frequencies
   close (phfrq_unit)
   close (phvec_unit)
 end if

 deallocate(phfrq)
 deallocate(eigvec)

!DEBUG
!write(6,*)' mkphbs : exit '
!call flush(6)
!ENDDEBUG

end subroutine mkphbs
!!***
