!{\src2tex{textfont=tt}}
!!****f* ABINIT/mkqptequiv
!!
!! NAME
!! mkqptequiv
!!
!! FUNCTION
!! This routine determines the equivalence between 
!!   1) qpoints and fermi surface kpoints
!!   2) qpoints under symmetry operations
!!
!! COPYRIGHT
!! Copyright (C) 2004-2010 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   kpt_phon = fermi surface kpoints
!!   nkpt_phon = number of kpoints in the full FS set
!!   nqpt = number of qpoints
!!   nsym = number of symmetries
!!   qpt_full = qpoint coordinates
!!   symrec = reciprocal space symops
!!
!! OUTPUT
!!   FSfullpqtofull = mapping of k + q onto k' for k and k' in full BZ
!!   qpttoqpt(itim,isym,iqpt) = qpoint index which
!!     transforms to iqpt under isym and with time reversal itim.
!!
!! NOTES
!!   REMOVED 3/6/2008: much too large matrix, and not used at present
!!       FStoqpt = mapping of kpoint pairs (1 irreducible and 1 full) to qpoints
!!
!! PARENTS
!!      elphon
!!
!! CHILDREN
!!      destroy_kptrank,get_rank_1kpt,mkkptrank,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine mkqptequiv (FSfullpqtofull,kpt_phon,nkpt_phon,nqpt,nsym,&
&   qpttoqpt,qpt_full,symrec)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon
 use m_kptrank

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nkpt_phon,nqpt,nsym
!arrays
 integer,intent(in) :: symrec(3,3,nsym)
 integer,intent(out) :: FSfullpqtofull(nkpt_phon,nqpt),qpttoqpt(2,nsym,nqpt)
 real(dp),intent(in) :: kpt_phon(3,nkpt_phon),qpt_full(3,nqpt)

!Local variables-------------------------------
!scalars
 integer :: ikpt_phon,iFSqpt,iqpt,isym,symrankkpt_phon
 character(len=500) :: message
 type(kptrank_type) :: kptrank_t

!arrays
 real(dp) :: tmpkpt(3)

! *************************************************************************

 
 write (message,'(a)')' mkqptequiv : making rankkpt_phon and invrankkpt_phon'
 call wrtout(std_out,message,'COLL')

 call mkkptrank (kpt_phon,nkpt_phon,kptrank_t)

 FSfullpqtofull(:,:) = -999

 do ikpt_phon=1,nkpt_phon
   do iqpt=1,nqpt
!    tmpkpt = jkpt = ikpt + qpt
     tmpkpt(:) = kpt_phon(:,ikpt_phon) + qpt_full(:,iqpt)

!    which kpt is it among the full FS kpts?
     call get_rank_1kpt (tmpkpt,symrankkpt_phon,kptrank_t)

     FSfullpqtofull(ikpt_phon,iqpt) = kptrank_t%invrank(symrankkpt_phon)
     if (FSfullpqtofull(ikpt_phon,iqpt) == -1) then
       write (*,*) ' mkqptequiv : Error : looks like no kpoint equiv to k+q !!!'
       stop
     end if

   end do
 end do

 call destroy_kptrank (kptrank_t)

!start over with q grid

 write(message,'(a)')' mkqptequiv : FSfullpqtofull made. Do qpttoqpt'
 call wrtout(std_out,message,'COLL')

 call mkkptrank (qpt_full,nqpt,kptrank_t)

 qpttoqpt(:,:,:) = -1
 do iFSqpt=1,nqpt
   do isym=1,nsym
     tmpkpt(:) = symrec(:,1,isym)*qpt_full(1,iFSqpt) &
&     + symrec(:,2,isym)*qpt_full(2,iFSqpt) &
&     + symrec(:,3,isym)*qpt_full(3,iFSqpt)

     call get_rank_1kpt (tmpkpt,symrankkpt_phon,kptrank_t)
     if (kptrank_t%invrank(symrankkpt_phon) == -1) then
       write (*,*) ' mkqptequiv : Error : looks like no kpoint equiv to q by symmetry without time reversal!!!'
       stop
     end if
     qpttoqpt(1,isym,kptrank_t%invrank(symrankkpt_phon)) = iFSqpt

     tmpkpt = -tmpkpt
     call get_rank_1kpt (tmpkpt,symrankkpt_phon,kptrank_t)
     if (kptrank_t%invrank(symrankkpt_phon) == -1) then
       write (*,*) ' mkqptequiv : Error : looks like no kpoint equiv to q by symmetry with time reversal!!!'
       stop
     end if
     qpttoqpt(2,isym,kptrank_t%invrank(symrankkpt_phon)) = iFSqpt
   end do
 end do

 call destroy_kptrank (kptrank_t)

end subroutine mkqptequiv
!!***
