!{\src2tex{textfont=tt}}
!!****f* ABINIT/normsq_gkq
!!
!! NAME
!! normsq_gkq
!!
!! FUNCTION
!! This routine takes the gkq matrix elements for a given qpoint,
!!   does the scalar product with the phonon displacement vector,
!!   squares the gkq matrix elements
!!   multiplies by the appropriate weights and
!!   puts them in a uniform (atom,icart) basis
!!
!! COPYRIGHT
!! Copyright (C) 2004-2010 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   displ_red = phonon mode displacement vectors, post-multiplied by gprim matrix
!!     (ie. turned to reduced coordinates)
!!   eigvec = eigenvectors of phonons (to turn to cartesian coord frame)
!!   elph_ds = datastructure with gkk matrix elements
!!   FSfullpqtofull = mapping of k + q to k
!!   h1_mat_el_sq = matrix elements $<psi_{k+q,m} | H^{1} | psi_{k,n}>$ matrix-squared
!!   iqptirred = index of present qpoint
!!   phfrq_tmp = phonon frequencies
!!   qpt_irred = array of qpoint coordinates
!!   wf = gkk matrix element weight with $1/\sqrt{2 \omega}$
!!
!! OUTPUT
!!   elph_ds%gkq filled
!!   qdata(elph_ds%nbranch,elph_ds%nsppol,3) = array containing the phonon frequency, the linwidth
!!                              and $\lambda_{q,\nu}$ for the considered phonon mode
!!
!! NOTES
!!
!! PARENTS
!!      read_gkk
!!
!! CHILDREN
!!      zgemm
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine normsq_gkq(displ_red,eigvec,elph_ds,FSfullpqtofull,&
&    h1_mat_el_sq,iqptirred,phfrq_tmp,qpt_irred,qdata)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_77_ddb, except_this_one => normsq_gkq
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqptirred
 type(elph_type),intent(inout) :: elph_ds
!arrays
 integer,intent(in) :: FSfullpqtofull(elph_ds%k_phon%nkpt,elph_ds%nqpt_full)
 real(dp),intent(in) :: displ_red(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),intent(in) :: eigvec(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),intent(inout) :: &
& h1_mat_el_sq(2,elph_ds%nFSband*elph_ds%nFSband,elph_ds%nbranch*elph_ds%nbranch,elph_ds%k_phon%nkpt,elph_ds%nsppol)
 real(dp),intent(in) :: phfrq_tmp(elph_ds%nbranch),qpt_irred(3,elph_ds%nqptirred)
 real(dp),intent(out) :: qdata(elph_ds%nbranch,elph_ds%nsppol,3)

!Local variables-------------------------------
!scalars
 integer :: i1,i2,ier,ii,isppol,jbranch,ikpt_phon
!integer :: ibranch,kbranch
 real(dp) :: lambda_tot
 character(len=500) :: message
!arrays
 real(dp) :: accum_mat(2,elph_ds%nbranch,elph_ds%nbranch,elph_ds%nsppol)
 real(dp) :: accum_mat2(2,elph_ds%nbranch,elph_ds%nbranch,elph_ds%nsppol)
 real(dp) :: gam_now2(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp) :: lambda(elph_ds%nsppol)
 real(dp),allocatable :: matrx(:,:),val(:),vec(:,:,:)
 real(dp),allocatable :: zhpev1(:,:),zhpev2(:)

! *************************************************************************

!DEBUG
!write(6,*)' normsq_gkq : enter '
!ENDDEBUG

 accum_mat(:,:,:,:) = zero
 accum_mat2(:,:,:,:) = zero

 if (elph_ds%ep_scalprod == 1) then
   if (elph_ds%ep_keepbands == 0) then
     write (*,*) ' normsq_gkq : calling nmsq_gam_sumFS'
     call nmsq_gam_sumFS (accum_mat,accum_mat2,displ_red,eigvec,elph_ds,FSfullpqtofull,&
&     h1_mat_el_sq,iqptirred)
   else if (elph_ds%ep_keepbands == 1) then
     write (*,*) ' normsq_gkq : calling nmsq_gam'
     call nmsq_gam (accum_mat,accum_mat2,displ_red,eigvec,elph_ds,FSfullpqtofull,&
&     h1_mat_el_sq,iqptirred)
   else
     write (message,'(4a,i4)')ch10,' normsq_gkq : BUG- ',ch10,&
     ' Wrong value for elph_ds%ep_keepbands = ',elph_ds%ep_keepbands
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
   end if
 else if (elph_ds%ep_scalprod == 0) then
!  else elph_ds%ep_scalprod == 0  Interpolate on the pure "matrix of matrix elements"
!  and do the scalar products later.
   if (elph_ds%ep_keepbands == 0) then
     write (*,*) ' normsq_gkq : calling nmsq_pure_gkk_sumFS'

     call nmsq_pure_gkk_sumFS (accum_mat,accum_mat2,displ_red,elph_ds,FSfullpqtofull,&
&     h1_mat_el_sq,iqptirred)
   else if (elph_ds%ep_keepbands == 1) then
     write (*,*) ' normsq_gkq : calling nmsq_pure_gkk'

     call nmsq_pure_gkk (accum_mat,accum_mat2,displ_red,elph_ds,FSfullpqtofull,&
&     h1_mat_el_sq,iqptirred)
   else
     write (message,'(4a,i4)')ch10,' normsq_gkq : BUG- ',ch10,&
&     ' Wrong value for elph_ds%ep_keepbands = ',elph_ds%ep_keepbands
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
   end if


 else
   write (message,'(3a,i4)')' normsq_gkq: BUG-',ch10,&
&   ' Wrong value for elph_ds%ep_scalprod = ',elph_ds%ep_scalprod
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if
!end if flag for doing scalar product now.


!MG: values without the good prefactor
 accum_mat(:,:,:,:) = accum_mat(:,:,:,:)*elph_ds%occ_factor/elph_ds%k_phon%nkpt
!MG: only accum_mat2 contains the line-widhts before the Fourier interpolation
 accum_mat2(:,:,:,:) = accum_mat2(:,:,:,:)*elph_ds%occ_factor/elph_ds%k_phon%nkpt

!MG20060531i
!write e-ph quantities before Fourier interpolation
!save e-ph values in the temporary array qdata that will be copied into elph_ds%qgrid_data

 write (message,'(4a,3es16.6,63a)')ch10,                  &
& ' Phonon linewidths before interpolation ',ch10,        &
& ' Q point = ',qpt_irred(:,iqptirred),ch10,('=',ii=1,60),ch10,&
& ' Mode          Frequency (Ha)  Linewidth (Ha)  Lambda '
 call wrtout(std_out,message,'COLL')

 lambda_tot = zero
 do isppol=1,elph_ds%nsppol
   do ii=1,elph_ds%nbranch
     lambda(isppol)=zero
!    MG: the tolerance factor is somehow arbitrary
     if (abs(phfrq_tmp(ii)) > tol10) lambda(isppol)=accum_mat2(1,ii,ii,isppol)/&
&     (pi*elph_ds%n0(isppol)*phfrq_tmp(ii)**2)
     lambda_tot=lambda_tot+lambda(isppol)
     write(message,'(i8,es20.6,2es16.6)' )ii,phfrq_tmp(ii),accum_mat2(1,ii,ii,isppol),lambda(isppol)
     call wrtout(std_out,message,'COLL')
!    save values
     qdata(ii,isppol,1)=phfrq_tmp(ii)
     qdata(ii,isppol,2)=accum_mat2(1,ii,ii,isppol)
     qdata(ii,isppol,3)=lambda(isppol)
   end do !loop over branch
 end do !loop over sppol

!normalize for number of spins
 lambda_tot = lambda_tot / elph_ds%nsppol

 write(message,'(61a,44x,es16.6,62a)' )('=',ii=1,60),ch10,lambda_tot,ch10,('=',ii=1,60),ch10
 call wrtout(std_out,message,'COLL')
!ENDMG20060531

!immediately calculate linewidths:
 write (*,*) 'summed accum_mat = '
 write (*,'(3(2E18.6,1x))') accum_mat(:,:,:,1)
 write (*,*) 'summed accum_mat2 = '
 write (*,'(3(2E18.6,1x))')  (accum_mat2(:,ii,ii,1),ii=1,elph_ds%nbranch)
 write (*,*) 'displ_red  = '
 write (*,'(3(2E18.6,1x))') displ_red

 if (elph_ds%ep_scalprod == 1) then
   do isppol=1,elph_ds%nsppol
!    Diagonalize gamma matrix at qpoint (complex matrix). Copied from phfrq3
     ier=0
     ii=1
     allocate(matrx(2,(elph_ds%nbranch*(elph_ds%nbranch+1))/2))
     do i2=1,elph_ds%nbranch
       do i1=1,i2
         matrx(1,ii)=accum_mat2(1,i1,i2,isppol)
         matrx(2,ii)=accum_mat2(2,i1,i2,isppol)
         ii=ii+1
       end do
     end do
     allocate(zhpev1(2,2*elph_ds%nbranch-1),zhpev2(3*elph_ds%nbranch-2))
     allocate(val(elph_ds%nbranch),vec(2,elph_ds%nbranch,elph_ds%nbranch))
     call ZHPEV ('V','U',elph_ds%nbranch,matrx,val,vec,elph_ds%nbranch,zhpev1,&
&     zhpev2,ier)

     write (*,*) ' normsq_gkq : accumulated eigenvalues isppol ',isppol, ' = '
     write (*,'(3E18.6)') val
     deallocate(matrx,zhpev1,zhpev2,vec,val)
   end do ! isppol

 else if (elph_ds%ep_scalprod == 0) then


   do isppol=1,elph_ds%nsppol
     call gam_mult_displ(elph_ds%nbranch, displ_red, accum_mat(:,:,:,isppol), gam_now2)

     write (*,*) ' normsq_gkq : accumulated eigenvalues isppol ', isppol, ' = '
     write (*,'(3(E14.6,1x))') (gam_now2(1,jbranch,jbranch), jbranch=1,elph_ds%nbranch)
     write (*,*) ' normsq_gkq : imag part = '
     write (*,'(3(E14.6,1x))') (gam_now2(2,jbranch,jbranch), jbranch=1,elph_ds%nbranch)
   end do ! isppol

 end if

!save gkk_qpt, eventually to disk, but only for ngkkband, which is 1 instead of nFSband, if the sum over bands has been performed
 if (elph_ds%gkqwrite == 0) then
   elph_ds%gkk_qpt(:,:,:,:,:,iqptirred) = h1_mat_el_sq(:,1:elph_ds%ngkkband*elph_ds%ngkkband,:,:,:)
 else
!  write all kpoints to disk
   write (*,*) 'size of record to be written: ', 8  * 2*elph_ds%ngkkband*elph_ds%ngkkband*&
&   elph_ds%nbranch*elph_ds%nbranch*elph_ds%k_phon%nkpt*elph_ds%nsppol
   inquire(unit=elph_ds%unitgkq, recl=isppol)
   print *, 'recl =', isppol
   write (*,*) 'iqptirred ', iqptirred 

!  write (elph_ds%unitgkq,REC=iqptirred) h1_mat_el_sq(:,1:elph_ds%ngkkband*elph_ds%ngkkband,:,:,:)
   do ikpt_phon=1,elph_ds%k_phon%nkpt
     write (elph_ds%unitgkq,REC=((iqptirred-1)*elph_ds%k_phon%nkpt+ikpt_phon)) &
&     h1_mat_el_sq(:,1:elph_ds%ngkkband*elph_ds%ngkkband,:,ikpt_phon,:)
   end do
 end if

!DEBUG
 write(6,*)' normsq_gkq : exit '
!ENDDEBUG

end subroutine normsq_gkq
!!***

!!****f* ABINIT/gam_mult_displ
!!
!! NAME
!! gam_mult_displ
!!
!! FUNCTION
!! This routine takes the bare gamma matrices and multiplies them
!!  by the displ_red matrices (related to the scalprod variable)
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   nbranch = number of phonon branches (3*natom)
!!   displ_red = phonon mode displacement vectors, post-multiplied by gprim matrix
!!     (ie. turned to reduced coordinates)
!!   gam_bare = bare gamma matrices before multiplication
!!
!! OUTPUT
!!   gam_now = output gamma matrices multiplied by displacement matrices
!!
!! NOTES
!!
!! PARENTS
!!      mka2f,mka2f_tr,mkph_linwid,nmsq_gam,nmsq_gam_sumfs,nmsq_pure_gkk
!!      nmsq_pure_gkk_sumfs,normsq_gkq
!!
!! CHILDREN
!!      zgemm
!!
!! SOURCE

subroutine gam_mult_displ(nbranch, displ_red, gam_bare, gam_now)

  use defs_basis

  implicit none

!Arguments -------------------------------
  integer, intent(in)  :: nbranch

  real(dp), intent(in)  :: displ_red(2,nbranch,nbranch)
  real(dp), intent(in)  :: gam_bare(2,nbranch,nbranch)
  real(dp), intent(out) :: gam_now(2,nbranch,nbranch)

!Local variables -------------------------
  real(dp) :: zgemm_tmp_mat(2,nbranch,nbranch)

! *********************************************************************

 gam_now(:,:,:) = zero

 call zgemm('c','n',nbranch,nbranch,nbranch,cone,&
& displ_red,nbranch,gam_bare,&
& nbranch,czero,zgemm_tmp_mat,nbranch)

 call zgemm('n','n',nbranch,nbranch,nbranch,cone,&
& zgemm_tmp_mat,nbranch,displ_red,&
& nbranch,czero,gam_now,nbranch)

!FIXME: replace by a BLAS call or 2.
!do jbranch = 1, nbranch
!do ibranch = 1, nbranch
!do kbranch = 1, nbranch
!!     gam = displ gam_red displ^{*T}
!gam_now(1,jbranch,jbranch) = gam_now(1,jbranch,jbranch) + &
!&       displ_red(1,ibranch,jbranch)*gam_bare(1,ibranch,kbranch)*displ_red(1,kbranch,jbranch) &
!&      +displ_red(1,ibranch,jbranch)*gam_bare(2,ibranch,kbranch)*displ_red(2,kbranch,jbranch) &
!&      +displ_red(2,ibranch,jbranch)*gam_bare(1,ibranch,kbranch)*displ_red(2,kbranch,jbranch) &
!&      -displ_red(2,ibranch,jbranch)*gam_bare(2,ibranch,kbranch)*displ_red(1,kbranch,jbranch)
!gam_now(2,jbranch,jbranch) = gam_now(2,jbranch,jbranch)   &
!&      +displ_red(2,ibranch,jbranch)*gam_bare(2,ibranch,kbranch)*displ_red(2,kbranch,jbranch) &
!&      +displ_red(2,ibranch,jbranch)*gam_bare(1,ibranch,kbranch)*displ_red(1,kbranch,jbranch) &
!&      +displ_red(1,ibranch,jbranch)*gam_bare(2,ibranch,kbranch)*displ_red(1,kbranch,jbranch) &
!&      -displ_red(1,ibranch,jbranch)*gam_bare(1,ibranch,kbranch)*displ_red(2,kbranch,jbranch)
!end do
!end do
!end do

end subroutine gam_mult_displ
!!***
