!{\src2tex{textfont=tt}}
!!****f* ABINIT/outphdos
!! NAME
!! outphdos
!!
!! FUNCTION
!!  Print out phonon density of states
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!   deltaene = step on energy/frequency grid, in Hartree
!!   dos_phon = phonon DOS calculated on a grid
!!   enemin = minimal frequency
!!   enemax = maximal frequency
!!   filnam = file name for output to disk
!!   g2fsmear = smearing width
!!   nene = number of points on energy axis
!!   nqpt = number of q-points
!!   ntetra = number of tetrahedra, if tetrahedron interpolation is used
!!   telphint = flag for el-phonon interpolation method (to indicate Gaussian or tetrahedron integration)
!!   unit_phdos = unit for phonon DOS output
!!
!!
!! OUTPUT
!!  only write
!!
!! SIDE EFFECTS
!!
!! NOTES
!!   FIXME
!!   overcomplete inputs. Eliminate unit_phdos (just filnam) and deltaene (gotten from max-min/nene)
!!
!! PARENTS
!!      thmeig
!!
!! CHILDREN
!!      leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine outphdos(deltaene,dos_phon,enemin,enemax,filnam,g2fsmear,nene,nqpt,ntetra,telphint,unit_phdos)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nene,nqpt,ntetra,telphint,unit_phdos
 character(len=fnlen),intent(in) :: filnam
 real(dp) :: deltaene,enemin,enemax,g2fsmear
!arrays
 real(dp) :: dos_phon(nene)

!Local variables-------------------------------
!scalars
 integer :: iomega,iost
 real(dp) :: omega
 character(len=fnlen) :: outfile
 character(len=500) :: message
!arrays

! *************************************************************************

 outfile = trim(filnam) // '_PDS'
 open (unit=unit_phdos,file=outfile,status='replace',iostat=iost)
 if (iost /= 0) then
   write (message,'(3a)')' thmeig : ERROR- opening file ',trim(outfile),' as new'
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

 write (6, '(a)') 'phonon DOS'
 write (unit_phdos,'(a)') '#'
 write (unit_phdos,'(a)') '# ABINIT package : phonon DOS file'
 write (unit_phdos,'(a)') '#'
 write (unit_phdos,'(a,I10)') '#     number of Qpoints integrated over : ', nqpt
 write (unit_phdos,'(a,I10)') '#     number of energy points : ', nene
 write (unit_phdos,'(a,E16.6,a,E16.6,a)') '#       between omega_min = ', enemin, &
& ' Ha and omega_max = ', enemax, ' Ha'
 if(telphint==1)then
   write (unit_phdos,'(a,E16.6)') '#   and the smearing width for gaussians is ', g2fsmear
   write (unit_phdos,'(a)') '#'
 end if
 if(telphint==0)then
   write (unit_phdos,'(a,I10)') '#   number of tetrahedrons', ntetra
   write (unit_phdos,'(a)') '#'
 end if

 omega = enemin
 do iomega=1,nene
   write (6,'(es18.6,es18.6)') omega, dos_phon(iomega)
   write (unit_phdos,*) omega*Ha_eV*1000, dos_phon(iomega)
   omega=omega+deltaene
 end do
 
 close (unit=unit_phdos)

end subroutine outphdos
!!***
