!{\src2tex{textfont=tt}}
!!****f* ABINIT/read_gkk
!!
!! NAME
!! read_gkk
!!
!! FUNCTION
!! This routine reads in elphon matrix elements and completes them
!!  using the appropriate symmetries
!!
!! COPYRIGHT
!! Copyright (C) 2004-2010 ABINIT group (MVer, MG)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  elph_ds = datastructure containing elphon matrix elements
!!  FSfullpqtofull = mapping of k+q to k
!!  gprimd = reciprocal lattice vectors (dimensionful)
!!  indsym = map of atoms through symrel
!!  n1wf = number of 1WF files to be read and analyzed
!!  natom = number of atoms
!!  nband = number of bands per kpoint
!!  nsym = number of symmetries for full lattice
!!  phon_ds = phonon datastructure with real space interatomic force constants
!!  symrec = symmetry operations in reciprocal space
!!  symrel = symmetry operations in real space
!!  tnons = translations associated to symrel
!!  unitgkk = unit of GKK file for reading
!!
!! OUTPUT
!!  elph_ds = modified gkq
!!  gkk_qpt = el-ph matrix elements for irreducible qpoints and
!!    kpoints (as a function of the reduced symmetry for the qpoint)
!!  gkk_flag = flag array:
!!       -1 -> element is missing
!!        0 -> element is from symmetric qpt (Now done in complete_gkk)
!!        1 -> element is from symmetric pert
!!        2 -> element is kptsym of gkk file
!!        3 -> element was read from gkk file
!!
!! NOTES
!!
!! PARENTS
!!      get_all_gkq
!!
!! CHILDREN
!!      completeperts,hdr_clean,hdr_io,inpphon,insy3,leave_new,mati3inv
!!      normsq_gkq,prt_gkk_yambo,symq3,wrap2_pmhalf,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine read_gkk(elph_ds,FSfullpqtofull,    &
&                   gkk_flag,gprimd,indsym,n1wf,natom,nband,nsym,&
&                   phon_ds,symrec,symrel,tnons,&
&                   ep_prt_yambo,unitgkk)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon

 use m_header,          only : hdr_clean

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_32_util
 use interfaces_59_io_mpi
 use interfaces_72_response
 use interfaces_77_ddb, except_this_one => read_gkk
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: n1wf,natom,nband,nsym,unitgkk
 integer,intent(in) :: ep_prt_yambo
 type(elph_type),intent(inout) :: elph_ds
 type(phon_type),intent(inout) :: phon_ds
!arrays
 integer,intent(in) :: FSfullpqtofull(elph_ds%k_phon%nkpt,elph_ds%nqpt_full)
 integer,intent(in) :: indsym(4,nsym,natom)
 integer,intent(in) :: symrec(3,3,nsym),symrel(3,3,nsym)
 integer,intent(out) :: gkk_flag(elph_ds%nbranch,elph_ds%nbranch,elph_ds%k_phon%nkpt,elph_ds%nsppol,elph_ds%nqptirred)
 real(dp),intent(in) :: gprimd(3,3)
 real(dp),intent(in) :: tnons(3,nsym)

!Local variables-------------------------------
!scalars
 integer :: fform,i1wf,ikpt_phon,iatom,iatom1,iatom2
 integer :: ib,ib1,ib2,ibb,ibranch,idir,idir1,idir2,ierr,ii,ikpt1
 integer :: ipert,ipert1,ipert2,iqptirred,iqptfull,isppol,isym1
 integer :: itim1,jkpt_phon,jatom,jbranch,jdir,k1,kdir,new
 integer :: nsym1,qtimrev,rdwr,symikpt_phon,syuse
 integer :: tdonecompl,test_flag,verify
 integer :: nqptirred_local
 real(dp) :: eigentol,eigentol2,res,ss,timsign
 character(len=500) :: message
 type(hdr_type) :: hdr1
!arrays
 integer :: FSirrtok(3,elph_ds%k_phon%nkpt),dummysymafm(nsym)
 integer :: irredpert(7,elph_ds%nbranch,elph_ds%nbranch,elph_ds%nqptirred)
 integer :: symaf1(nsym),symq(4,2,nsym)
 integer :: symrc1(3,3,nsym),symrl1(3,3,nsym)
 integer :: tmpflg(3,natom+2,3,natom+2)
 integer :: vdir(3)
 real(dp) :: displ(2,3*natom,3*natom)
 real(dp) :: displ_red(2,3*natom,3*natom),eigval(3*natom)
 real(dp) :: eigvec(2,3*natom,3*natom),kpt(3),phfrq_tmp(3*natom),redkpt(3)
 real(dp) :: qptirred_local(3,n1wf)
 real(dp) :: tnons1(3,nsym)
 real(dp) :: wf(elph_ds%nbranch)
 real(dp),allocatable :: accum_eigen1(:,:,:),eigen1(:,:,:),gkk_qpt_tmp(:,:,:,:)
 real(dp),allocatable :: h1_mat_el(:,:,:,:,:),h1_mat_el_sq(:,:,:,:,:)
 real(dp),allocatable :: qdata(:,:,:),qdata_tmp(:,:,:,:)

! *************************************************************************

 allocate(h1_mat_el(2, elph_ds%nFSband*elph_ds%nFSband, elph_ds%nbranch, &
& elph_ds%k_phon%nkpt, elph_ds%nsppol), stat=ierr)
 if (ierr /= 0 ) then
   write (message,'(3a)')' read_gkk : ERROR- ',ch10,&
&   ' trying to allocate array h1_mat_el '
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

 h1_mat_el(:,:,:,:,:) = zero

 allocate(h1_mat_el_sq(2, elph_ds%nFSband*elph_ds%nFSband, elph_ds%nbranch*elph_ds%nbranch, &
& elph_ds%k_phon%nkpt, elph_ds%nsppol), stat=ierr)
 if (ierr /= 0 ) then
   write (message,'(3a)')' read_gkk : ERROR- ',ch10,&
&   ' trying to allocate array h1_mat_el_sq '
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

 allocate(elph_ds%qirredtofull(elph_ds%nqptirred))

!Tolerance for eigenvalues from 1WF files being non-zero
 eigentol = 1.0d-50
 eigentol2 = 2.0d-50

!MG array to store the e-ph quantities calculated over the input Q-grid
 allocate (qdata_tmp(elph_ds%nqptirred,elph_ds%nbranch,elph_ds%nsppol,3))
 qdata_tmp(:,:,:,:)=zero

 nqptirred_local=0 !zero number of irred q-points found
 qptirred_local(:,:)=zero

 gkk_flag(:,:,:,:,:) = -1

 if (elph_ds%gkqwrite ==0) then
   elph_ds%gkk_qpt(:,:,:,:,:,:) = zero
 else if (elph_ds%gkqwrite == 1) then
   allocate(gkk_qpt_tmp(2,elph_ds%ngkkband*elph_ds%ngkkband,&
&   elph_ds%nbranch*elph_ds%nbranch,elph_ds%nsppol),stat=ierr)
   if (ierr /= 0 ) then
     write (message,'(3a)')' read_gkk : ERROR- ',ch10,&
&     ' trying to allocate array gkk_qpt_tmp '
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
   end if
   gkk_qpt_tmp = zero
   do iqptirred=1,elph_ds%nqptirred*elph_ds%k_phon%nkpt
     write (elph_ds%unitgkq,REC=iqptirred) gkk_qpt_tmp
   end do
   deallocate (gkk_qpt_tmp)
 else
   write (message,'(3a,i3)')&
&   ' read_gkk : BUG-',ch10,&
&   ' Wrong values for gkqwrite = ',elph_ds%gkqwrite
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if !gkqwrite

 allocate(eigen1(2,nband,nband),accum_eigen1(2,nband,nband))

 irredpert(:,:,:,:) = -999
 h1_mat_el(:,:,:,:,:) = zero

!===========================================================
!Loop over all files we have
!read in header for perturbation
!should check that all files are complete, have same header
!(taking into account the symmetries for the qpoint),
!represent the correct qpoints ...
!MG: this task should be performed in mrggkk
!===========================================================

 do i1wf=1,n1wf

   write (message,'(2a,i4,a,i4)')ch10,' read_gkk : reading 1WF header # ',i1wf,' /',n1wf
   call wrtout(std_out,message,'COLL')

!  Could check for compatibility of natom, kpt grids, ecut, qpt with DDB grid...
!  MG: Also this task should be done in mrggkk

   rdwr = 5 !read without rewinding
   call hdr_io(fform,hdr1,rdwr,unitgkk)
   if (fform == 0) then
     write (message,'(4a,i5,a)')ch10,' read_gkk : ERROR- :',ch10,&
&     ' 1WF header number ',i1wf,' was mis-read. fform == 0'
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
   end if

   write(message,'(a,i4)')' read_gkk : have read 1WF header #',i1wf
   call wrtout(std_out,message,'COLL')
   write (message,'(2a,i4,a)')ch10,' read_gkk : # of kpt for this pert: ',hdr1%nkpt,ch10
   call wrtout(std_out,message,'COLL')

!  Find qpoint in full grid
   new=1
   do iqptfull=1,elph_ds%nqpt_full
     kpt(:) = hdr1%qptn(:) - elph_ds%qpt_full(:,iqptfull)
     call wrap2_pmhalf(kpt(1),redkpt(1),res)
     call wrap2_pmhalf(kpt(2),redkpt(2),res)
     call wrap2_pmhalf(kpt(3),redkpt(3),res)
     ss=redkpt(1)**2+redkpt(2)**2+redkpt(3)**2
     if(ss < tol6) then
       new = 0
       exit !exit with iqptfull
     end if
   end do !iqptfull

   if (new == 1) then
!    Test should be at the end: dont care if there are additional
!    qpts in gkk file which are not on the main grid. Ignore them.
     write (message,'(4a,3es16.6,2a)')ch10,&
&     ' read_gkk : WARNING-  ',ch10,&
&     ' qpoint = ',hdr1%qptn(:),ch10,&
&     ' not found in the input q-grid. Ignoring this point '
     call wrtout(ab_out,message,'COLL')
     call wrtout(std_out,message,'COLL')

     do isppol=1,hdr1%nsppol
       do ikpt1=1,hdr1%nkpt
         read(unitgkk) ((eigen1(:,ii,ib),ii=1,nband),ib=1,nband)
       end do
     end do
     cycle !cycle the loop on i1wf
   end if !end if (new ==1)

!  Check whether other pieces of the DDB have used this qpt already
   new=1
   do iqptirred=1,nqptirred_local
     kpt(:) = qptirred_local(:,iqptirred) - hdr1%qptn(:)
     call wrap2_pmhalf(kpt(1),redkpt(1),res)
     call wrap2_pmhalf(kpt(2),redkpt(2),res)
     call wrap2_pmhalf(kpt(3),redkpt(3),res)
     ss=redkpt(1)**2+redkpt(2)**2+redkpt(3)**2
     if(ss < tol6) then
       new=0
       exit  !MG We can use this information to avoid recalculating the dynamical matrix 
     end if !but we need to use a fixed format in GKK!
   end do !iqptirred

   if (new==1) then  !we have a new valid irreducible qpoint, add it!
     nqptirred_local = nqptirred_local+1
     if (nqptirred_local > elph_ds%nqptirred) then
       write (message, '(a,a,a,i6,i6)') &
&       'Error: found too many qpoints in GKK file wrt anaddb input ', ch10, &
&       ' nqpt_anaddb nqpt_gkk = ', elph_ds%nqptirred, nqptirred_local
       call wrtout(std_out,message,'COLL')
       call leave_new('COLL')
     end if
     qptirred_local(:,nqptirred_local) = hdr1%qptn(:)
     iqptirred = nqptirred_local
     tdonecompl = 0
     h1_mat_el(:,:,:,:,:) = zero
   end if

!  now iqptirred is the index of the present qpoint in the array qptirred_local
!  and iqptfull is the index in the full qpt_full array for future reference
   elph_ds%qirredtofull(iqptirred) = iqptfull

   write (message,'(a,i5,a,3es16.8)')&
&   ' read_gkk : full zone qpt number ',iqptfull,' is ',elph_ds%qpt_full(:,iqptfull)
   call wrtout(std_out,message,'COLL')

!  if this perturbation has already been filled (overcomplete gkk)
!  check only 1st kpoint and spinpol, then check others
   verify = 0
   if (gkk_flag(hdr1%pertcase,hdr1%pertcase,1,1,iqptirred) /= -1) then
     do isppol=1,elph_ds%nsppol
       do ikpt_phon=1,elph_ds%k_phon%nkpt
         if (gkk_flag(hdr1%pertcase,hdr1%pertcase,ikpt_phon,isppol,iqptirred) == -1) then
           write (message,'(4a)')ch10,&
&           ' read_gkk : ERROR-',ch10,&
&           ' partially filled perturbation '
           call wrtout(std_out,message,'COLL')
           write (*,*)hdr1%pertcase,ikpt_phon,iqptirred
           call leave_new('COLL')
         end if
       end do ! ikpt_phon
     end do ! isppol
     write(message,'(4a)')ch10,&
&     ' read_gkk : WARNING- ',ch10,&
&     ' gkk perturbation is already filled'
     call wrtout(std_out,message,'COLL')
     write(*,*)' hdr1%pertcase,iqptirred,iqptfull = ',hdr1%pertcase,iqptirred,iqptfull,&
&     gkk_flag(hdr1%pertcase,hdr1%pertcase,1,1,iqptirred)
     verify = 1
     write (125,*) '# matrix elements for symmetric perturbation'
!    Instead of reading eigen1 into void, verify == 1 checks
!    them later on wrt values in memory
   end if !gkk_flag

!  Examine the symmetries of the q wavevector
!  these will be used to complete the perturbations for other atoms and idir

   call symq3(nsym,qptirred_local(:,iqptirred),symq,symrec,qtimrev)

!  Determine dynamical matrix, phonon frequencies and displacement vector for qpoint
!  MG: For each qpt we are calculating the dynamical matrix for each perturbation
!  Possible solution: use a fixed format for the GKK file and a flag which
!  calls inpphon only for the first perturbation of each q point
   
   write (message,'(2a)')ch10,' read_gkk : calling inpphon to calculate the dynamical matrix'
   call wrtout(std_out,message,'COLL')

   call inpphon(displ,eigval,eigvec,phfrq_tmp,phon_ds,qptirred_local(:,iqptirred))

!  Get displacement vectors for all branches in reduced coordinates
!  used in scalar product with H(1)_atom,idir  matrix elements
!  Calculate $displ_red = displ \cdot gprimd$ for each phonon branch

   displ_red(:,:,:) = zero
   do jbranch=1,elph_ds%nbranch
     do iatom=1,natom
       do idir=1,3
         ibranch=idir+3*(iatom-1)
         do kdir=1,3
           k1 = kdir+3*(iatom-1)
!          WARNING: could be non-transpose of rprimd matrix : to be checked.
!          23 june 2004: rprimd becomes gprimd
!          could be gprim and then multiply by acell...
!          Nope, checked and ok with gprimd 24 jun 2004
           displ_red(1,ibranch,jbranch) = displ_red(1,ibranch,jbranch) + &
&           gprimd(kdir,idir)*displ(1,k1,jbranch)

           displ_red(2,ibranch,jbranch) = displ_red(2,ibranch,jbranch) + &
&           gprimd(kdir,idir)*displ(2,k1,jbranch)

         end do !kdir
       end do !idir
     end do !iatom

   end do !jbranch

   accum_eigen1(:,:,:) = zero

!  prefactors for gk+q,n\prime;k,n matrix element
!  COMMENT : in decaft there is a weird term in the mass factor, of M-zval(species)
!  dont know why. Not needed to reproduce decaft results, though... 
!  weight is squared in evaluation of
!  gamma_{k,q,j} = 2 \pi omega_{q,j} sum_{nu,nu\prime} |g^{q,j}_{k+q,nu\prime; k,nu}|^2
!  normally cancels with the 2 \pi omega_{q,j} factor in front of the sum...

   do jatom=1,natom
     do jdir=1,3
       jbranch=3*(jatom-1)+jdir

!      WARNING : the tolerance for which a phonon freq is 0 is a bit arbitrary.
!      Should be smaller.
       if (abs(phfrq_tmp(jbranch)) > tol10) then
!        It looks like the 1/sqrt(M) factor is already in displ from phfrq3
!        Not used in case ep_scalprod==0
         wf(jbranch) = one/sqrt(two*abs(phfrq_tmp(jbranch)))
       else
         wf(jbranch) = zero
       end if
     end do !jdir
   end do !jatom

!  hdr1%pertcase = idir + (ipert-1)*3
!  where ipert=iatom in the interesting cases
   idir = mod (hdr1%pertcase-1,3)+1
!  vdir is the a,b, or c basis vector, for transformation under symops
   vdir(:) = 0
   vdir(idir) = 1
   ipert = int(dble(hdr1%pertcase-idir)/three)+1

   write (message,'(4a,i3,a,i3,a,i4,a)')ch10,&
&   ' read_gkk : calling insy3 to examine the symmetries of the full perturbation ',ch10,&
&   ' idir = ',idir,' ipert = ',ipert,' and Q point = ',iqptirred,ch10
   call wrtout(std_out,message,'COLL') 

!  Examine the symmetries of the full perturbation these will be used to complete the kpoints
!  DOESNT USE TIME REVERSAL IN insy3 except for gamma

   syuse = 0
   dummysymafm(:) = 1
   call insy3(gprimd,idir,indsym,ipert,natom,nsym,nsym1,2,dummysymafm,symaf1,&
&   symq,symrec,symrel,symrl1,syuse,tnons,tnons1)
   do isym1=1,nsym1
     call mati3inv(symrl1(:,:,isym1),symrc1(:,:,isym1))
   end do
   FSirrtok (:,:) = 0

!  ========================================================
!  Loop over irred kpts in file, and fill the default gkk
!  ========================================================

!  MG NOTE : in the present implementation, if nsppol /=1 the code stops in rchkGSheader!
   do isppol=1,hdr1%nsppol !Loop over spins is trivial? Not tested.
     write (*,*) ' read_gkk : isppol = ', isppol 
     do ikpt1=1,hdr1%nkpt   !Loop over irred kpoints, WARNING  nkpt depends on qpoint and symmetry!

!      
!      this is the main read of the gkk matrix elements from the file (eigen1 arrays)
!      it has to be done exactly nsppol*nkpt times, and the kpt_phon are completed
!      where appropriate in the loop below (normally succeeding only once for each kpt)
!      
       read(unitgkk) ((eigen1(:,ii,ib),ii=1,nband),ib=1,nband)

!      Check to see if kpoint is in FS set
!      WARNING! the kpoints in the file (kptns) could be ordered arbitrarily
       do ikpt_phon=1,elph_ds%k_phon%nkpt
         kpt(:) = hdr1%kptns(:,ikpt1)-elph_ds%k_phon%kpt(:,ikpt_phon)-qptirred_local(:,iqptirred)
         call wrap2_pmhalf(kpt(1),redkpt(1),res)
         call wrap2_pmhalf(kpt(2),redkpt(2),res)
         call wrap2_pmhalf(kpt(3),redkpt(3),res)

         ss=redkpt(1)**2+redkpt(2)**2+redkpt(3)**2

!        this is not the point on the FS we are looking for
         if (ss > tol6) cycle

         if (verify == 1) then
           do ib1=1,elph_ds%nFSband
             do ib2=1,elph_ds%nFSband
               ibb = (ib1-1)*elph_ds%nFSband+ib2
               write (125,'(2(2E16.6,2x))') h1_mat_el(:,ibb,hdr1%pertcase,ikpt_phon,isppol),&
&               eigen1(:,elph_ds%minFSband-1+ib2,elph_ds%minFSband-1+ib1)
             end do
           end do
         end if !verify

!        if this kpoint has already been filled (overcomplete gkk)
         if (gkk_flag(hdr1%pertcase,hdr1%pertcase,ikpt_phon,isppol,iqptirred) /= -1) then
           write(*,*)' read_gkk warning : gkk element is already filled'
           write (*,*)' hdr1%pertcase,ikpt_phon,isppol,iqptirred = ',&
&           hdr1%pertcase,ikpt_phon,isppol,iqptirred,&
&           gkk_flag(hdr1%pertcase,hdr1%pertcase,ikpt_phon,isppol,iqptirred)
           exit
         end if !gkk_flag

!        save this kpoint
         do ib1=1,elph_ds%nFSband
           do ib2=1,elph_ds%nFSband
             ibb = (ib1-1)*elph_ds%nFSband+ib2
             
!            17.05.04 corrected ib1ib2 order in eigen1 indices...

!            real
             res=eigen1(1,elph_ds%minFSband-1+ib2,elph_ds%minFSband-1+ib1)
!            if (abs(res*1.0d10) > eigentol2) then
             h1_mat_el(1,ibb,hdr1%pertcase,ikpt_phon,isppol) = res
!            end if

!            imag
             res=eigen1(2,elph_ds%minFSband-1+ib2,elph_ds%minFSband-1+ib1)
!            if (abs(res*1.0d10) > eigentol2) then
             h1_mat_el(2,ibb,hdr1%pertcase,ikpt_phon,isppol) = res
!            end if
           end do !ib2
         end do !ib1
         gkk_flag(hdr1%pertcase,hdr1%pertcase,ikpt_phon,isppol,iqptirred) = 3


!        ===============================================================
!        we now have contribution to g(k+q,k; \kappa,\alpha) from one
!        kpoint,and one perturbation,
!        NB: each perturbation will contribute to all the modes later!
!        find correspondence between this kpt_phon and the others
!        provided sym conserves pert as well as qpoint: add to FSirrtok
!        
!        SHOULD ONLY DO THIS FOR THE SYMS NEEDED 
!        TO COMPLETE THE PERTURBATIONS!!!
!        ================================================================

         new=0
         do isym1=1,nsym1
           do itim1=0,qtimrev
             timsign=one-two*itim1
             kpt(:) = timsign*(symrc1(:,1,isym1)*elph_ds%k_phon%kpt(1,ikpt_phon)+&
&             symrc1(:,2,isym1)*elph_ds%k_phon%kpt(2,ikpt_phon)+&
&             symrc1(:,3,isym1)*elph_ds%k_phon%kpt(3,ikpt_phon))
             call wrap2_pmhalf(kpt(1),redkpt(1),res)
             call wrap2_pmhalf(kpt(2),redkpt(2),res)
             call wrap2_pmhalf(kpt(3),redkpt(3),res)
             new=1
!            FIXME: use rank scheme to avoid this loop
             do jkpt_phon=1,elph_ds%k_phon%nkpt
               ss=  (redkpt(1)-elph_ds%k_phon%kpt(1,jkpt_phon))**2&
&               +(redkpt(2)-elph_ds%k_phon%kpt(2,jkpt_phon))**2&
&               +(redkpt(3)-elph_ds%k_phon%kpt(3,jkpt_phon))**2
               if (ss < tol6) then
                 new=0
                 FSirrtok(1,jkpt_phon) = ikpt_phon
                 FSirrtok(2,jkpt_phon) = isym1
                 FSirrtok(3,jkpt_phon) = itim1
                 exit !exit jkpt_phon
               end if
             end do !jkpt_phon
             if (new == 1) then
               write (message,'(4a,3es16.6,a,i5,a,i4,a)')ch10,&
&               ' read_gkk  ERROR- :',ch10,&
&               ' equivalent of kpt ',elph_ds%k_phon%kpt(:,ikpt_phon),' by sym ',isym1,' and itime ',itim1,' was not found'
               call wrtout(std_out,message,'COLL')
               call leave_new('COLL')
             end if
           end do !itim1
         end do !isim1

!        can we safely exit here? The ikpt has been identified to ikpt_phon,
!        so no need to search the other elph_ds%k_phon%kpt
         exit
       end do !ikpt_phon
     end do !ikpt1
   end do !isppol

   if (verify == 1) then
     cycle
   end if

   if (elph_ds%tuniformgrid == 1) then
!    check if irred kpoints found do reconstitute the FS kpts
     do ikpt_phon=1,elph_ds%k_phon%nkpt
       if (FSirrtok(1,ikpt_phon) == 0) then
         write(message,'(4a,3es16.6,2a)')ch10,                        &
&         ' read_gkk : ERROR-',ch10,                                   &
&         ' kpt = ',elph_ds%k_phon%kpt(:,ikpt_phon),ch10,                              &
&         ' is not the symmetric of one of those found in the GKK file'
         call wrtout(std_out,message,'COLL')
         call leave_new('COLL')
       end if
     end do !ikpt_phon
   end if

!  ===============================================================
!  We now have all irred kpoints : complete the others
!  complete gkk for symmetric ikpt_phon with sym1 which conserve
!  the full perturbation+qpoint
!  Not tested explicitly, but the results for Pb using reduced kpts look good
!  should do same RF calculation with nsym=1 and check
!  ===============================================================

   do symikpt_phon=1,elph_ds%k_phon%nkpt
!    if the element has already been filled with another sym op, cycle
     if (gkk_flag(hdr1%pertcase,hdr1%pertcase,symikpt_phon,1,iqptirred) /= -1) cycle

     ikpt_phon=FSirrtok(1,symikpt_phon)
     isym1    =FSirrtok(2,symikpt_phon)
     itim1    =FSirrtok(3,symikpt_phon)
     timsign  = one-two*itim1

!    copy kpt to symmetric kpoint
     do ibb=1,elph_ds%nFSband*elph_ds%nFSband
       h1_mat_el(1,ibb,hdr1%pertcase,symikpt_phon,:) = h1_mat_el(1,ibb,hdr1%pertcase,ikpt_phon,:)
       h1_mat_el(2,ibb,hdr1%pertcase,symikpt_phon,:) = h1_mat_el(2,ibb,hdr1%pertcase,ikpt_phon,:)
     end do
     gkk_flag(hdr1%pertcase,hdr1%pertcase,symikpt_phon,:,iqptirred) = 2
   end do !symikpt_phon

   if (elph_ds%tuniformgrid == 1) then
!    normally at this point we have used all the gkk for all kpoints on the FS
!    for the given irred perturbation: check
     do ikpt_phon=1,elph_ds%k_phon%nkpt
       if (gkk_flag(hdr1%pertcase,hdr1%pertcase,ikpt_phon,1,iqptirred) == -1) then
         write (message,'(3a,i3,a,3es18.6,2a,i3,a,i3,a,3es18.6,a,a,i4,a,a)')&
&         ' read_gkk  ERROR- :',ch10,          &
&         ' For full qpt ', iqptirred,') ',qptirred_local(:,iqptirred),ch10, &
&         ' the gkk element : pertcase = ',hdr1%pertcase,' ikpt = ',ikpt_phon, &
&         ' kpt = ',elph_ds%k_phon%kpt(:,ikpt_phon),ch10,&
&         ' and isppol ',1,ch10,&
&         ' was not found by symmetry operations on the irreducible kpoints given'
         call wrtout(std_out,message,'COLL')
         call leave_new('COLL')
       end if
       if (FSirrtok(1,ikpt_phon) == 0) then
         write (message,'(3a)')' read_gkk : ERROR-',ch10,&
         ' One of the kpoints was not equivalent to an irred one found in the gkk file'
         call wrtout(std_out,message,'COLL')
         call leave_new('COLL')
       end if
     end do !ikpt_phon
   end if

   write(message,'(a,i4)')' read_gkk : Done completing the kpoints for pert ',hdr1%pertcase
   call wrtout(std_out,message,'COLL')

   tmpflg(:,:,:,:) = 0

   do idir1=1,3
     do iatom1=1,natom
       ipert1 = (iatom1-1)*3+idir1
       do idir2=1,3
         do iatom2=1,natom
           ipert2 = (iatom2-1)*3+idir2
           if (gkk_flag(ipert1,ipert1,1,1,iqptirred) >= 0 .and. &
&           gkk_flag(ipert2,ipert2,1,1,iqptirred) >= 0) then
             tmpflg(idir1,iatom1,idir2,iatom2) = 1
           end if
         end do
       end do
     end do
   end do


!  ===============================================
!  Full test: need all perturbations explicitly
!  ===============================================

   test_flag = 0
   if (sum(tmpflg(:,1:natom,:,1:natom)) == 3*natom*3*natom .and. tdonecompl == 0) test_flag = 1
!  write(*,*) 'read_gkk : test_flag = ', test_flag

   write(*,*)'read_gkk: tdonecompl = ', tdonecompl

!  de-activate completion of perts by symmetry for now.
!  Must be called when all irreducible perturbations are in memory!!!!
   if (test_flag == 1 .and. tdonecompl == 0) then

!    write (*,*) ' read_gkk : enter fxgkkphase before completeperts'
!    call fxgkkphase(elph_ds,gkk_flag,h1_mat_el,iqptirred)

     if (ep_prt_yambo==1) then
       call prt_gkk_yambo(displ,elph_ds%k_phon%kpt,h1_mat_el,iqptirred,&
&       natom,elph_ds%nFSband,elph_ds%k_phon%nkpt,&
&       phfrq_tmp,hdr1%qptn)
     end if

!    ========================================================================
!    Now use more general symops to complete the other equivalent
!    perturbations: the kpoints are also shuffled by these symops
!    afterwards h1_mat_el_sq contains gamma_\tau\alpha,\tau'\alpha'
!    in reduced coordinates
!    
!    \gamma_{\tau'\alpha',\tau\alpha} =
!    <psi_{k+q,ib2} | H(1)_{\tau'\alpha'} | psi_{k,ib1} >*
!    \cdot  <psi_{k+q,ib2} | H(1)_{\tau\alpha}   | psi_{k,ib1} >
!    
!    ========================================================================

     call completeperts(elph_ds,gkk_flag,h1_mat_el,h1_mat_el_sq,indsym,&
&     iqptirred,natom,nsym,qptirred_local(:,iqptirred),symq,symrec,symrel,qtimrev)

     tdonecompl = 1

   end if

!  ==============================================================
!  if we have all the perturbations for this qpoint, proceed
!  with scalar product, norm squared, and add weight factors
!  
!  SHOULD HAVE A TEST SO h1_mat_el IS NOT OVERWRITTEN
!  BEFORE PREVIOUS QPOINT IS FINISHED!!!!!
!  REMARK: there is just a factor of |rprimd(:,i)| between
!  abinit and decaft matrix elements.
!  ==============================================================

   test_flag = 1
   do isppol=1,elph_ds%nsppol
     do ikpt_phon=1,elph_ds%k_phon%nkpt
       do ibranch=1,elph_ds%nbranch
!        do jbranch=1,elph_ds%nbranch
         if (gkk_flag (ibranch,ibranch,ikpt_phon,isppol,iqptirred) == -1) then
           test_flag = 0
           exit
         end if
!        end do
       end do
     end do
   end do

   if (test_flag /= 0) then

     write(message,'(a)')' read_gkk : enter normsq_gkq'
     call wrtout(std_out,message,'COLL')

!    MG temporary array to save ph-linewidths before Fourier interpolation
     allocate (qdata(elph_ds%nbranch,elph_ds%nsppol,3))
     qdata(:,:,:)=zero

     call normsq_gkq(displ_red,eigvec,elph_ds,FSfullpqtofull,&
&     h1_mat_el_sq,iqptirred,phfrq_tmp,qptirred_local,qdata)

     qdata_tmp(iqptirred,:,:,:)=qdata(:,:,:)
     deallocate (qdata)
   end if

   call hdr_clean(hdr1)

 end do !of i1wf 

!got all the gkk perturbations

 deallocate(eigen1)
 deallocate(h1_mat_el,h1_mat_el_sq)

 if (nqptirred_local /= elph_ds%nqptirred) then
   write (message, '(a,a,a,i6,i6)') &
&   'Error: found wrong number of qpoints in GKK file wrt anaddb input ', ch10, &
&   ' nqpt_anaddb nqpt_gkk = ', elph_ds%nqptirred, nqptirred_local
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

!normally at this point we have the gkk for all kpoints on the FS
!for all the perturbations. Otherwise a 1WF file is missing.
!NOTE: still havent checked the qpoint grid completeness
 do iqptirred=1,elph_ds%nqptirred
   do isppol=1,elph_ds%nsppol
     do ikpt_phon=1,elph_ds%k_phon%nkpt
       do ipert=1,elph_ds%nbranch
         if (gkk_flag(ipert,ipert,ikpt_phon,isppol,iqptirred) == -1) then
           write (message,'(3a,i5,1x,i5,1x,i5,1x,i5,a,a)')' read_gkk  : ERROR-',ch10,  &
&           ' gkk element',ipert,ikpt_phon,isppol,iqptirred,' was not found by symmetry operations ',&
&           ' on the irreducible perturbations and qpoints given'
!          write (*,*) '  content = ', elph_ds%gkk_qpt(:,ipert,1,1,ikpt_phon,iqptirred)
           call wrtout(std_out,message,'COLL')
           call leave_new('COLL')
         end if
       end do !ipert
     end do !ikpt_phon
   end do !isppol
 end do !iqptirred

 write(message,'(a)')'read_gkk : done completing the perturbations (and checked!)'
 call wrtout(std_out,message,'COLL')

!MG save phonon frequencies, ph-linewidths and lambda(q,n) values before Fourier interpolation
 allocate(elph_ds%qgrid_data(elph_ds%nqptirred,elph_ds%nbranch,elph_ds%nsppol,3))

 do iqptirred=1,elph_ds%nqptirred
   elph_ds%qgrid_data(iqptirred,:,:,:)=qdata_tmp(iqptirred,:,:,:)
 end do

 deallocate(qdata_tmp)

end subroutine read_gkk
!!***
