!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_wfsinp_scratch
!! NAME
!! wvl_wfsinp_scratch
!!
!! FUNCTION
!! This method allocates and initialises wavefunctions with values from input guess.
!! See wvl_wfsinp_disk() or wvl_wfsinp_reformat() from other initialisation
!! routines.
!! 
!! When initialised from scratch or from disk, wvl%wfs%[h]psi comes unallocated
!! and will be allocated inside this routine.
!! When initialised from memory (reformating), wvl%wfs%[h]psi will be reallocated.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  hdr0 <type(hdr_type)>=the header of wf, den and pot files (read from restart)
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  ireadwf=1 for reading from file, 0 otherwise.
!!  mpi_enreg=informations about MPI parallelization
!!  option=1 for reading a file following ABINIT format, -1 for a BigDFT format.
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  wff <type(wffile_type)>= structure with informations on wf file.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  wvl <type(wvl_data)>=wavefunctions & projectors informations for wavelets.
!!  xred(3,natom)=reduced dimensionless atomic coordinates (in fact IN but here
!!                because of INOUT xredxcart() behavior).
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_wfsinp_scratch(dtset, mpi_enreg, psps, rprimd, wvl, xred)

  use defs_basis
  use defs_datatypes
  use m_wffile
 use defs_abitypes
  use defs_wvltypes
#if defined HAVE_BIGDFT
  use BigDFT_API, only : createIonicPotential, input_wf_diag, locreg_descriptors
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_42_geometry
 use interfaces_62_poisson
!End of the abilint section

  implicit none

!Arguments -------------------------------
  !scalars
  type(dataset_type), intent(in)            :: dtset
  type(MPI_type), intent(in)                :: mpi_enreg
  type(pseudopotential_type),intent(in)     :: psps
  type(wvl_data), intent(inout)             :: wvl
  !arrays
  real(dp), intent(in)                      :: rprimd(3, 3)
  real(dp), intent(inout)                   :: xred(3, dtset%natom)

!Local variables-------------------------------
  character(len = 500)  :: message
  integer               :: nvirte, nvirtep, nvirt, nspin
  real(dp)              :: eion
  real(dp), allocatable :: xcart(:,:)
  real(dp), allocatable :: rhor(:,:), vpsp(:)
  real(dp), pointer     :: kernel(:), psivirt(:)

#if defined HAVE_BIGDFT
  type(locreg_descriptors) :: ld
#endif

! *********************************************************************

 write(message, '(a,a)' ) ch10,&
& ' wvl_wfsinp_scratch: wavefunction initialisation.'
 call wrtout(std_out,message,'COLL')

#if defined HAVE_BIGDFT
!Store xcart for each atom
 allocate(xcart(3, dtset%natom))
 call xredxcart(dtset%natom, 1, rprimd, xcart, xred)

!We grep the kernel for the Poisson solver.
 call PSolver_kernel(dtset, 2, kernel, mpi_enreg, rprimd)

!We allocate temporary arrays for rho and vpsp.
!allocate ionic potential
 if (mpi_enreg%ngfft3_ionic > 0) then
   allocate(vpsp(dtset%wvl%ni(1) * &
&   dtset%wvl%ni(2) * mpi_enreg%ngfft3_ionic))
 else
   allocate(vpsp(1))
 end if

 call createIonicPotential(dtset%wvl%atoms%geocode, &
& mpi_enreg%me, mpi_enreg%nproc, dtset%natom, &
& dtset%ntypat, dtset%typat, psps%gth_params%psppar, &
& int(psps%ziontypat), xcart, dtset%wvl%h(1) / 2., &
& dtset%wvl%h(2) / 2., dtset%wvl%h(3) / 2., &
& real(0, dp), dtset%wvl%n(1), dtset%wvl%n(2), dtset%wvl%n(3), &
& mpi_enreg%ngfft3_ionic, mpi_enreg%nscatterarr(mpi_enreg%me, 3) + 1, &
& dtset%wvl%ni(1), dtset%wvl%ni(2), dtset%wvl%ni(3), &
& kernel, vpsp, eion, 0.d0)

 nspin = dtset%nsppol
!Allocate Charge density, Potential in real space
 if (mpi_enreg%nscatterarr(mpi_enreg%me, 1) > 0) then
   allocate(rhor(dtset%wvl%ni(1) * dtset%wvl%ni(2) * &
&   mpi_enreg%nscatterarr(mpi_enreg%me, 1), nspin))
 else
   allocate(rhor(1, nspin))
 end if

 call create_Glr(dtset%wvl%atoms%geocode, &
& dtset%wvl%n(1), dtset%wvl%n(2), dtset%wvl%n(3), &
& dtset%wvl%fGrid(1, 1), dtset%wvl%fGrid(1, 2), &
& dtset%wvl%fGrid(1, 3), dtset%wvl%fGrid(2, 1), &
& dtset%wvl%fGrid(2, 2), dtset%wvl%fGrid(2, 3), &
& dtset%wvl%ni(1), dtset%wvl%ni(2), dtset%wvl%ni(3), &
& wvl%wfs%keys, wvl%wfs%bounds, ld)

!This routine allocates psi, hpsi and psit.
 nvirt = 0
 call input_wf_diag(mpi_enreg%me, mpi_enreg%nproc, &
& dtset%wvl_cpmult, dtset%wvl_fpmult, psps%gth_params%radii_cf, dtset%wvl%atoms, &
& wvl%wfs%nstates, wvl%wfs%mbandp, nvirte, nvirtep, nvirt, wvl%wfs%mvctrp, &
& ld, dtset%wvl%h(1), dtset%wvl%h(2), dtset%wvl%h(3), xcart, &
& rhor, vpsp, wvl%projectors%keys, wvl%projectors%proj, kernel, dtset%ixc, &
& wvl%wfs%psi, wvl%wfs%hpsi, wvl%wfs%psit, psivirt, wvl%wfs%eval, &
& mpi_enreg%nscatterarr, mpi_enreg%ngatherarr, &
& nspin, wvl%wfs%spinar, .false.)

 write(message, '(a)' ) &
& '  | wavefunctions have been calculated.'
 call wrtout(std_out,message,'COLL')

 deallocate(xcart)
 deallocate(vpsp)
 deallocate(rhor)

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_wfsinp_scratch: BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 call wrtout(std_out,message,'COLL')
 call leave_new('COLL')
#endif
end subroutine wvl_wfsinp_scratch
!!***

