!{\src2tex{textfont=tt}}
!!****f* ABINIT/pred_bfgs
!! NAME
!! pred_bfgs
!!
!! FUNCTION
!! Ionmov predictors (2 & 3) Broyden-Fletcher-Goldfarb-Shanno
!!
!! IONMOV 2:
!! Given a starting point xred that is a vector of length 3*natom
!! (reduced nuclei coordinates), and unit cell parameters
!! (acell and rprim) the Broyden-Fletcher-Goldfarb-Shanno
!! minimization is performed on the total energy function, using
!! its gradient (atomic forces and stress : fred or fcart and
!! stress) as calculated by the routine scfcv. Some atoms can be
!! kept fixed, while the optimization of unit cell parameters is
!! only performed if optcell/=0. The convergence requirement on
!! the atomic forces, dtset%tolmxf,  allows an early exit.
!! Otherwise no more than dtset%ntime steps are performed.
!! Returned quantities are xred, and eventually acell and rprim
!! (new ones!).
!! Could see Numerical Recipes (Fortran), 1986, page 307.
!!
!! IONMOV 3:
!! Conduct structural optimization using the Broyden-Fletcher-
!! Goldfarb-Shanno minimization (BFGS), modified to take into
!! account the total energy as well as the gradients (as in usual
!! BFGS). See the paper by Schlegel, J. Comp. Chem. 3, 214 (1982).
!! Might be better than ionmov=2 for few degrees of freedom (less
!! than 3 or 4)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR, JCC, SE)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT (in)
!! ab_mover <type(ab_movetype)> : Datatype with all the information
!!                                needed by the preditor
!! itime  : Index of the present iteration
!! ntime  : Maximal number of iterations
!! ionmov : (2 or 3) Specific kind of BFGS
!!
!! OUTPUT (out)
!!
!! SIDE EFFECTS (inout)
!! hist <type(ab_movehistory)> : History of positions,forces
!!                               acell, rprimd, stresses
!!
!! NOTES
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!      brdene,chkrprimd,hessinit_new,hessupdt,hist2var,metric,mkrdim,var2hist
!!      xfh_recover_new,xfpack,xredxcart
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pred_bfgs(ab_mover,ab_xfh,hist,ionmov,itime)

! define dp,sixth,third,etc...
use defs_basis
! type(ab_movetype), type(ab_movehistory), type(ab_xfh_type)
use defs_mover

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_42_geometry
 use interfaces_42_geomoptim
 use interfaces_67_common
!End of the abilint section

implicit none

!Arguments ------------------------------------
!scalars
type(ab_movetype),intent(in) :: ab_mover
type(ab_xfh_type) :: ab_xfh
type(ab_movehistory),intent(inout) :: hist
integer, intent(in) :: itime
integer, intent(in) :: ionmov

!Local variables-------------------------------
!scalars
integer  :: ndim,option,cycl_main
integer  :: ii,jj,kk
real(dp),save :: ucvol0
real(dp) :: ucvol
real(dp) :: etotal,etotal_prev
real(dp) :: favg
logical  :: DEBUG=.FALSE.

!arrays
real(dp),allocatable,save :: hessin(:,:),vin(:),vin_prev(:)
real(dp),allocatable,save :: vout(:),vout_prev(:)
real(dp),save :: acell0(3) ! Initial acell
real(dp),save :: rprimd0(3,3) ! Initial rprimd
real(dp) :: acell(3)
real(dp) :: rprimd(3,3),rprim(3,3)
real(dp) :: gprimd(3,3)
real(dp) :: gmet(3,3)
real(dp) :: rmet(3,3)
real(dp) :: fred(3,ab_mover%natom),fred_corrected(3,ab_mover%natom)
real(dp) :: xred(3,ab_mover%natom),xcart(3,ab_mover%natom)
real(dp) :: strten(6)

!write(*,*) 'bfgs 01'
! ##########################################################
! ### 01. Compute the dimension of vectors (ndim)

ndim=3*ab_mover%natom
if(ab_mover%optcell==1 .or.&
  & ab_mover%optcell==4 .or.&
  & ab_mover%optcell==5 .or.&
  & ab_mover%optcell==6) ndim=ndim+1
if(ab_mover%optcell==2 .or.&
  & ab_mover%optcell==3) ndim=ndim+6
if(ab_mover%optcell==7 .or.&
  & ab_mover%optcell==8 .or.&
  & ab_mover%optcell==9) ndim=ndim+3

!write(*,*) 'bfgs 02'
! ##########################################################
! ### 02. Allocate the vectors vin, vout and hessian matrix

! Notice that vin, vout, etc could be allocated
! From a previous dataset with a different ndim
if(itime==1)then
   if (allocated(vin)) deallocate(vin)
   if (allocated(vout)) deallocate(vout)
   if (allocated(vin_prev)) deallocate(vin_prev)
   if (allocated(vout_prev)) deallocate(vout_prev)
   if (allocated(hessin)) deallocate(hessin)
   allocate(vin(ndim))
   allocate(vout(ndim))
   allocate(vin_prev(ndim))
   allocate(vout_prev(ndim))
   allocate(hessin(ndim,ndim))
end if

!write(*,*) 'bfgs 03'
! ##########################################################
! ### 03. Obtain the present values from the history

call hist2var(ab_mover,hist,acell,rprimd,xcart,xred)

fred(:,:)=hist%histXF(:,:,4,hist%ihist)
etotal=hist%histE(hist%ihist)
strten(:)=hist%histS(:,hist%ihist)

! Compute rprim from rprimd and acell
do kk=1,3
  do jj=1,3
    rprim(jj,kk)=rprimd(jj,kk)/acell(kk)
  end do
end do

call metric(gmet,gprimd,-1,rmet,rprimd,ucvol)

! Save initial values
if (itime==1)then
  acell0(:)=acell(:)
  rprimd0(:,:)=rprimd(:,:)
  ucvol0=ucvol
end if

!DEBUG (UCVOL)
if(DEBUG)then
  write(ab_out,*) 'UCVOL',ucvol,ucvol0
end if

! Get rid of mean force on whole unit cell, but only if no
! generalized constraints are in effect
if(ab_mover%nconeq==0)then
  do ii=1,3
    favg=sum(fred(ii,:))/dble(ab_mover%natom)
    fred_corrected(ii,:)=fred(ii,:)-favg
    if(ab_mover%jellslab/=0.and.ii==3)&
      & fred_corrected(ii,:)=fred(ii,:)
  end do
else
  fred_corrected(:,:)=fred(:,:)
end if

!write(*,*) 'bfgs 04'
! ##########################################################
! ### 04. Fill the vectors vin and vout

! DEBUG (XRA BEFORE PACK)
if(DEBUG)then
  write (ab_out,*) '---XRA BEFORE PACK---'
  call chkrprimd(acell,rprim,rprimd,ab_out)
  write (ab_out,*) 'XCART'
  do kk=1,ab_mover%natom
    write (ab_out,*) xcart(:,kk)
  end do
  write (ab_out,*) 'XRED'
  do kk=1,ab_mover%natom
    write (ab_out,*) xred(:,kk)
  end do
  write (ab_out,*) 'FRED'
  do kk=1,ab_mover%natom
    write (ab_out,*) fred(:,kk)
  end do
  write(ab_out,*) 'RPRIM'
  do kk=1,3
    write(ab_out,*) rprim(:,kk)
  end do
  write(ab_out,*) 'RPRIMD'
  do kk=1,3
    write(ab_out,*) rprimd(:,kk)
  end do
  write(ab_out,*) 'ACELL'
  write(ab_out,*) acell(:)
end if

! Initialize input vectors : first vin, then vout
! The values of vin from the previous iteration
! should be the same
!if (itime==1)then
option=1
call xfpack(acell, acell0, fred_corrected, ab_mover%natom, ndim,&
  & ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
  & ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
  & vin, vout, xred)
!end if

option=3
call xfpack(acell, acell0, fred_corrected, ab_mover%natom, ndim,&
  & ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
  & ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
  & vin, vout, xred)

if(DEBUG)then
  write (ab_out,*) '---XRA POST PACK---'
  call chkrprimd(acell,rprim,rprimd,ab_out)
  write(ab_out,*) 'RPRIM'
  do kk=1,3
    write(ab_out,*) rprim(:,kk)
  end do
  write(ab_out,*) 'RPRIMD'
  do kk=1,3
    write(ab_out,*) rprimd(:,kk)
  end do
  write(ab_out,*) 'ACELL'
  write(ab_out,*) acell(:)
end if


!write(*,*) 'bfgs 05'
! ##########################################################
! ### 05. Initialize or update the hessian matrix

! Initialise the Hessian matrix using gmet
if (itime==1)then

   call hessinit_new(ab_mover, hessin, gmet, ndim, ucvol)

  ! ! Initialize inverse hessian with identity matrix
  ! ! in cartesian coordinates, which makes use of metric tensor gmet
  ! ! in reduced coordinates.
  ! hessin(:,:)=zero
  ! do ii=1,ab_mover%natom
  !   do kk=1,3
  !     do jj=1,3
  !       ! Warning : implemented in reduced coordinates
  !       if (ab_mover%iatfix(kk,ii)==0 .and.&
  !         & ab_mover%iatfix(jj,ii)==0 )then
  !         hessin(kk+3*(ii-1),jj+3*(ii-1))=gmet(kk,jj)
  !       end if
  !     end do
  !   end do
  ! end do
  ! if(ab_mover%optcell/=0)then
  !   ! These values might lead to too large changes in some cases
  !   diag=ab_mover%strprecon*30.0_dp/ucvol
  !   if(ab_mover%optcell==1) diag=diag/three
  !   do ii=3*ab_mover%natom+1,ndim
  !     hessin(ii,ii)=diag
  !   end do
  ! end if

   if (ab_mover%restartxf/=0) then

      call xfh_recover_new(ab_xfh,ab_mover,acell,acell0,cycl_main,fred,&
           & hessin,ndim,rprim,rprimd0,strten,ucvol,ucvol0,vin,&
           & vin_prev,vout,vout_prev,xred)

   end if

end if

if(itime>1)then
  ! Update the hessian matrix, by taking into account the
  ! current pair (x,f) and the previous one.
  call hessupdt(hessin,ab_mover%iatfix,ab_mover%natom,ndim,vin,&
    &     vin_prev,vout,vout_prev)

end if

if(DEBUG)then
  write (ab_out,*) '---XRA POST Hessupdt---'
  call chkrprimd(acell,rprim,rprimd,ab_out)
  write(ab_out,*) 'RPRIM'
  do kk=1,3
    write(ab_out,*) rprim(:,kk)
  end do
  write(ab_out,*) 'RPRIMD'
  do kk=1,3
    write(ab_out,*) rprimd(:,kk)
  end do
  write(ab_out,*) 'ACELL'
  write(ab_out,*) acell(:)
end if

! DEBUG (VIN,VOUT,HESSIN BEFORE PREDICTION)
if(DEBUG)then
  write(ab_out,*) 'VIN,VOUT,HESSIN BEFORE PREDICTION'
  write(ab_out,*) 'VECTOR INPUT (vin)'
  do ii=1,ndim,3
    if (ii+2<=ndim)then
      write(ab_out,*) ii,vin(ii:ii+2)
    else
      write(ab_out,*) ii,vin(ii:ndim)
    end if
  end do
  write(ab_out,*) 'VECTOR OUTPUT (vout)'
  do ii=1,ndim,3
    if (ii+2<=ndim)then
      write(ab_out,*) ii,vout(ii:ii+2)
    else
      write(ab_out,*) ii,vout(ii:ndim)
    end if
  end do
  write(ab_out,*) 'Hessian matrix ',ndim,'x',ndim
  do kk=1,ndim
    do jj=1,ndim,3
      if (jj+2<=ndim)then
        write(ab_out,*) jj,hessin(jj:jj+2,kk)
      else
        write(ab_out,*) jj,hessin(jj:ndim,kk)
      end if
    end do
  end do
end if

!write(*,*) 'bfgs 06'
! ##########################################################
! ### 06. Compute the next values

if(ionmov==2 .or. itime==1)then

  ! Previous cartesian coordinates
  vin_prev(:)=vin(:)

  ! New atomic cartesian coordinates are obtained from vin, hessin
  ! and vout
  do ii=1,ndim
    vin(:)=vin(:)-hessin(:,ii)*vout(ii)
  end do
  ! Previous atomic forces
  vout_prev(:)=vout(:)

  ! DEBUG (VIN,VOUT,HESSIN AFTER PREDICTION)
  if(DEBUG)then
    write(ab_out,*) 'VIN,VOUT,HESSIN AFTER PREDICTION'
    write(ab_out,*) 'VECTOR INPUT (vin)'
    do ii=1,ndim,3
      if (ii+2<=ndim)then
        write(ab_out,*) ii,vin(ii:ii+2)
      else
        write(ab_out,*) ii,vin(ii:ndim)
      end if
    end do
    write(ab_out,*) 'VECTOR OUTPUT (vout)'
    do ii=1,ndim,3
      if (ii+2<=ndim)then
        write(ab_out,*) ii,vout(ii:ii+2)
      else
        write(ab_out,*) ii,vout(ii:ndim)
      end if
    end do
  end if

else
  if(ionmov==3)then

    etotal_prev=hist%histE(hist%ihist-1)
    ! Here the BFGS algorithm, modified to take into account the
    ! energy
    call brdene(etotal,etotal_prev,hessin,&
      & ndim,vin,vin_prev,vout,vout_prev)

  end if

  ! Implement fixing of atoms : put back old values for fixed
  ! components
  do kk=1,ab_mover%natom
    do jj=1,3
      ! Warning : implemented in reduced coordinates
      if ( ab_mover%iatfix(jj,kk)==1) then
        vin(jj+(kk-1)*3)=vin_prev(jj+(kk-1)*3)
      end if
    end do
  end do
end if

!write(*,*) 'bfgs 07'
! ##########################################################
! ### 07. Update the history with the prediction

! Increase indexes
hist%ihist=hist%ihist+1

if(DEBUG)then
  write (ab_out,*) '---XRA before xfpack option 2---'
  call chkrprimd(acell,rprim,rprimd,ab_out)
  write(ab_out,*) 'RPRIM'
  do kk=1,3
    write(ab_out,*) rprim(:,kk)
  end do
  write(ab_out,*) 'RPRIMD'
  do kk=1,3
    write(ab_out,*) rprimd(:,kk)
  end do
  write(ab_out,*) 'ACELL'
  write(ab_out,*) acell(:)
end if

! Transfer vin  to xred, acell and rprim
option=2
call xfpack(acell, acell0, fred, ab_mover%natom, ndim,&
  & ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
  & ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
  & vin, vout, xred)

if(ab_mover%optcell/=0)then
  call mkrdim(acell,rprim,rprimd)
  call metric(gmet,gprimd,-1,rmet,rprimd,ucvol)
end if

! DEBUG (XRA AFTER PREDICTION)
if(DEBUG)then
  write (ab_out,*) '---XRA AFTER PREDICTION ---'
  call chkrprimd(acell,rprim,rprimd,ab_out)
  write (ab_out,*) 'XCART'
  do kk=1,ab_mover%natom
    write (ab_out,*) xcart(:,kk)
  end do
  write (ab_out,*) 'XRED'
  do kk=1,ab_mover%natom
    write (ab_out,*) xred(:,kk)
  end do
  write (ab_out,*) 'RPRIM'
  do kk=1,3
    write (ab_out,*) rprim(:,kk)
  end do
  write(ab_out,*) 'RPRIMD'
  do kk=1,3
    write(ab_out,*) rprimd(:,kk)
  end do
  write(ab_out,*) 'ACELL'
  write(ab_out,*) acell(:)
end if

! Compute xcart from xred, and rprimd
call xredxcart(ab_mover%natom,1,rprimd,xcart,xred)

! Fill the history with the variables
! xcart, xred, acell, rprimd
call var2hist(ab_mover,hist,acell,rprimd,xcart,xred)

hist%histV(:,:,hist%ihist)=hist%histV(:,:,hist%ihist-1)

end subroutine pred_bfgs
!!***
