!{\src2tex{textfont=tt}}
!!****f* ABINIT/pred_delocint
!! NAME
!! pred_delocint
!!
!! FUNCTION
!! Ionmov predictors (10) BFGS with delocalized internal coordinates
!!
!! IONMOV 10:
!! Given a starting point xred that is a vector of length 3*(natom-1)
!! (reduced nuclei coordinates),
!! and unit cell parameters (acell and rprim) the
!! Broyden-Fletcher-Goldfarb-Shanno minimization is performed on the
!! total energy function, using its gradient (atomic forces and
!! stress : fred or fcart and stress) as calculated by the routine scfcv.
!! Some atoms can be kept fixed, while the optimization of unit cell
!! parameters is only performed if optcell/=0.
!! The convergence requirement on
!! the atomic forces, 'tolmxf',  allows an early exit.
!! Otherwise no more than 'ntime' steps are performed.
!! Returned quantities are xred, and eventually acell and rprim (new ones!).
!! Could see Numerical Recipes (Fortran), 1986, page 307.
!!
!!  Implements the delocalized internal coordinate scheme
!!  of Andzelm et al. in CPL .335. 321 (2001) \
!!  and Baker et al. JCP .105. 192 (1996)
!!
!!    B matrix is derivative of delocalized internals wrt cartesian coordinates
!!    U matrix is eigenvectors of G = B*B^{T}
!!    S matrix is eigenvectors of F = B^{T}B
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR, JCC, SE)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT (in)
!! ab_mover <type(ab_movetype)> : Datatype with all the information
!!                                needed by the preditor
!! itime  : Index of the present iteration
!! ntime  : Maximal number of iterations
!!
!! OUTPUT (out)
!!
!! SIDE EFFECTS (inout)
!! hist <type(ab_movehistory)> : History of positions,forces
!!                               acell, rprimd, stresses
!!
!! NOTES
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!      chkrprimd,hessupdt,hist2var,metric,mkrdim,var2hist,xfpack
!!      xredxcart
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pred_delocint(ab_mover,ab_xfh,hist,ionmov,itime)

! define dp,sixth,third,etc...
 use defs_basis
! type(ab_movetype), type(ab_movehistory), type(ab_xfh_type)
 use defs_mover

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_42_geometry
 use interfaces_42_geomoptim
 use interfaces_67_common
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(ab_movetype),intent(in) :: ab_mover
 type(ab_xfh_type) :: ab_xfh
 type(ab_movehistory),intent(inout) :: hist
 integer, intent(in) :: itime
 integer, intent(in) :: ionmov

!Local variables-------------------------------
!scalars
 integer  :: ndim,option,cycl_main
 integer  :: ii,jj,kk
 real(dp),save :: ucvol0
 real(dp) :: ucvol
 real(dp) :: etotal,etotal_prev
 real(dp) :: favg
 logical  :: DEBUG=.FALSE.
 integer,save :: icenter,irshift ! DELOCINT indexes
 integer,save :: nshell,ndeloc ! DELOCINT number of
 type(ab_delocint),save :: deloc ! DELOCINT main type
! character(len=500) :: message

!arrays
 real(dp),allocatable,save :: hessin(:,:),vin(:),vin_prev(:)
 real(dp),allocatable,save :: vout(:),vout_prev(:)
 real(dp),save :: acell0(3) ! Initial acell
 real(dp),save :: rprimd0(3,3) ! Initial rprimd
 real(dp),allocatable,save :: prim_int(:),prim_force(:),u_matrix(:,:) ! DELOCINT
 real(dp) :: acell(3)
 real(dp) :: rprimd(3,3),rprim(3,3)
 real(dp) :: gprimd(3,3)
 real(dp) :: gmet(3,3)
 real(dp) :: rmet(3,3)
 real(dp) :: fred(3,ab_mover%natom),fred_corrected(3,ab_mover%natom)
 real(dp) :: xred(3,ab_mover%natom),xcart(3,ab_mover%natom)
 real(dp) :: strten(6)
 real(dp) :: deloc_force(3*(ab_mover%natom-1))
 real(dp) :: deloc_int(3*(ab_mover%natom-1))
 real(dp) :: bt_inv_matrix(3*(ab_mover%natom-1),3*ab_mover%natom)

!write(*,*) 'delocint 01'
! ##########################################################
! ### 01. Compute the dimension of vectors (ndim)

! With internal we have 1 coordinate less
 ndeloc = 3*(ab_mover%natom-1)
 ndim=ndeloc
 deloc_int(:)=zero
 deloc_force(:)=zero
 if(ab_mover%optcell==1 .or.&
  & ab_mover%optcell==4 .or.&
  & ab_mover%optcell==5 .or.&
  & ab_mover%optcell==6) ndim=ndim+1
 if(ab_mover%optcell==2 .or.&
  & ab_mover%optcell==3) ndim=ndim+6
 if(ab_mover%optcell==7 .or.&
  & ab_mover%optcell==8 .or.&
  & ab_mover%optcell==9) ndim=ndim+3

!write(*,*) 'delocint 02'
! ##########################################################
! ### 02. Allocate the vectors vin, vout and hessian matrix

! Notice thqt vin, vout, etc could be allocated
! From a previous dataset with a different ndim
 if(itime==1)then
    if (allocated(vin)) deallocate(vin)
    if (allocated(vout)) deallocate(vout)
    if (allocated(vin_prev)) deallocate(vin_prev)
    if (allocated(vout_prev)) deallocate(vout_prev)
    if (allocated(hessin)) deallocate(hessin)
    allocate(vin(ndim))
    allocate(vout(ndim))
    allocate(vin_prev(ndim))
    allocate(vout_prev(ndim))
    allocate(hessin(ndim,ndim))
    ! DELOCINT
    ! Allocate all the variables of deloc,
    ! Needed for compilers such as Pathscale that fails if
    ! unallocated variables are passed as arguments
    if (associated(deloc%rshift))    nullify(deloc%rshift)
    if (associated(deloc%bonds))     nullify(deloc%bonds)
    if (associated(deloc%angs))      nullify(deloc%angs)
    if (associated(deloc%carts))     nullify(deloc%carts)
    if (associated(deloc%dihedrals)) nullify(deloc%dihedrals)

    nshell=3
    deloc%nrshift=(2*nshell+1)**3
    icenter = nshell*(2*nshell+1)**2 + nshell*(2*nshell+1) + nshell + 1

    allocate(deloc%rshift(3,deloc%nrshift))
    allocate(deloc%angs(1,1,1))
    allocate(deloc%bonds(1,1,1))
    allocate(deloc%carts(1,1))
    allocate(deloc%dihedrals(1,1,1))

    deloc%angs(:,:,:)=zero
    deloc%bonds(:,:,:)=zero
    deloc%carts(:,:)=zero
    deloc%dihedrals(:,:,:)=zero

    irshift=0
    do ii=-nshell,nshell
       do jj=-nshell,nshell
          do kk=-nshell,nshell
             irshift=irshift+1
             deloc%rshift(:,irshift) = (/dble(ii),dble(jj),dble(kk)/)
          end do
       end do
    end do

 end if

!write(*,*) 'delocint 03'
! ##########################################################
! ### 03. Obtain the present values from the history

call hist2var(ab_mover,hist,acell,rprimd,xcart,xred)

fred(:,:)=hist%histXF(:,:,4,hist%ihist)
etotal=hist%histE(hist%ihist)
strten(:)=hist%histS(:,hist%ihist)

! Compute rprim from rprimd and acell
do kk=1,3
  do jj=1,3
    rprim(jj,kk)=rprimd(jj,kk)/acell(kk)
  end do
end do

call metric(gmet,gprimd,-1,rmet,rprimd,ucvol)

! Save initial values
if (itime==1)then
  acell0(:)=acell(:)
  rprimd0(:,:)=rprimd(:,:)
  ucvol0=ucvol
end if

! Get rid of mean force on whole unit cell, but only if no
! generalized constraints are in effect
if(ab_mover%nconeq==0)then
  do ii=1,3
    favg=sum(fred(ii,:))/dble(ab_mover%natom)
    fred_corrected(ii,:)=fred(ii,:)-favg
    if(ab_mover%jellslab/=0.and.ii==3)&
      & fred_corrected(ii,:)=fred(ii,:)
  end do
else
  fred_corrected(:,:)=fred(:,:)
end if

!write(*,*) 'delocint 04'
! ##########################################################
! ### 04. Compute internals for first time

if (itime==1)then
    call make_prim_internals(deloc,icenter,ab_mover%natom,&
& ab_mover%ntypat,rprimd,ab_mover%typat,xcart,ab_mover%znucl)

    ! write (message,'(a,i6)') ' Number of primitive internal coordinates ninternal = ',deloc%ninternal
    ! call wrtout(ab_out,message,'COLL')
    ! call wrtout(std_out,  message,'COLL')

    if (allocated(prim_int)) deallocate(prim_int)
    if (allocated(prim_force)) deallocate(prim_force)
    if (allocated(u_matrix)) deallocate(u_matrix)
    allocate (prim_int(deloc%ninternal),prim_force(deloc%ninternal),u_matrix(deloc%ninternal,ndeloc))

    call calc_prim_int(deloc,ab_mover%natom,rprimd,xcart,prim_int)

    ! write (message,'(a)') 'Primitive internal coordinate values:'
    ! call wrtout(ab_out,message,'COLL')
    ! call wrtout(std_out,  message,'COLL')
    ! write (message,'(a)') ' Bonds:'
    ! call wrtout(ab_out,message,'COLL')
    ! call wrtout(std_out,  message,'COLL')
    ! do ii = 1, deloc%nbond
    !    write (message,'(i6,E20.10)') ii, prim_int(ii)
    !    call wrtout(ab_out,message,'COLL')
    !    call wrtout(std_out,  message,'COLL')
    ! end do

    ! write (message,'(a)') ' Angles:'
    ! call wrtout(ab_out,message,'COLL')
    ! call wrtout(std_out,  message,'COLL')
    ! do ii = deloc%nbond+1, deloc%nbond+deloc%nang
    !    write (message,'(i6,2(E20.10,2x))') ii, prim_int(ii), prim_int(ii)/pi*180.0_dp
    !    call wrtout(ab_out,message,'COLL')
    !    call wrtout(std_out,  message,'COLL')
    ! end do

    ! write (message,'(a)') ' Dihedrals:'
    ! call wrtout(ab_out,message,'COLL')
    ! call wrtout(std_out,  message,'COLL')
    ! do ii = deloc%nbond+deloc%nang+1, deloc%nbond+deloc%nang+deloc%ndihed
    !    write (message,'(i6,2(E20.10,2x))') ii, prim_int(ii), prim_int(ii)/pi*180.0_dp
    !    call wrtout(ab_out,message,'COLL')
    !    call wrtout(std_out,  message,'COLL')
    ! end do

    ! write (message,'(a)') ' Cartesian auxiliary coordinates for constraints:'
    ! call wrtout(ab_out,message,'COLL')
    ! call wrtout(std_out,  message,'COLL')
    ! do ii = deloc%nbond+deloc%nang+deloc%ndihed+1, deloc%ninternal
    !    write (message,'(i6,E20.10)') ii, prim_int(ii)
    !    call wrtout(ab_out,message,'COLL')
    !    call wrtout(std_out,  message,'COLL')
    ! end do

    !equal weight on all internal coordinates as a starting point.
    u_matrix(:,:) = one / dble (ndeloc)

    ! Zero the arrays before first use
    deloc_force(:) = zero

end if

!write(*,*) 'delocint 05'
! ##########################################################
! ### 05. Compute delocalized coordinates and forces

! xcart ---> deloc_int

! Convert positions to delocalized coordinates for next step
 call xcart2deloc(deloc,ab_mover%natom,rprimd,xcart,&
& bt_inv_matrix,u_matrix,deloc_int,prim_int)

! fred ---> deloc_force

! Convert forces to delocalized coordinates for next step
 call fred2fdeloc(bt_inv_matrix,deloc_force,fred,ab_mover%natom,gprimd)

!write(*,*) 'delocint 06'
! ##########################################################
! ### 06. Fill the vectors vin and vout

!DEBUG deloc_int and deloc_force before pack
if(DEBUG)then
  write (ab_out,*) '---deloc BEFORE PACK--- ndeloc=',ndeloc
  write(ab_out,*) 'deloc_int'
  do ii=1,ndeloc,3
    if (ii+2<=ndeloc)then
      write(ab_out,*) ii,deloc_int(ii:ii+2)
    else
      write(ab_out,*) ii,deloc_int(ii:ndeloc)
    end if
  end do
  write(ab_out,*) 'deloc_force'
  do ii=1,ndeloc,3
    if (ii+2<=ndeloc)then
      write(ab_out,*) ii,deloc_force(ii:ii+2)
    else
      write(ab_out,*) ii,deloc_force(ii:ndeloc)
    end if
  end do
end if

!DELOCINT
! Instead of fred_corrected we use deloc_force
! Instead of xred e use deloc_int
!
! Initialize input vectors : first vin, then vout
! The values of vin from the previous iteration
! should be the same
!if (itime==1)then
option=1
call xfpack(acell, acell0, deloc_force, ab_mover%natom-1, ndim,&
  & ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
  & ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
  & vin, vout, deloc_int)
!end if

option=3
call xfpack(acell, acell0, deloc_force, ab_mover%natom-1, ndim,&
  & ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
  & ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
  & vin, vout, deloc_int)

if(DEBUG)then
  write(ab_out,*) 'VECTOR INPUT (vin)'
  do ii=1,ndim,3
    if (ii+2<=ndim)then
      write(ab_out,*) ii,vin(ii:ii+2)
    else
      write(ab_out,*) ii,vin(ii:ndim)
    end if
  end do
  write(ab_out,*) 'VECTOR OUTPUT (vout)'
  do ii=1,ndim,3
    if (ii+2<=ndim)then
      write(ab_out,*) ii,vout(ii:ii+2)
    else
      write(ab_out,*) ii,vout(ii:ndim)
    end if
  end do
end if

!write(*,*) 'delocint 07'
! ##########################################################
! ### 07. Initialize or update the hessian matrix

! Initialise the Hessian matrix using gmet
if (itime==1)then

   !Initialise the Hessian matrix with ab_mover%userrc.
   !this has become unusable because it imposes ndim >= 3 natom
   !ident = 3x3 identity matrix
   !call hessinit_new(ab_mover, hessin, gmet, ndim, ucvol)
   hessin = zero
   do ii=1, ndim
      hessin (ii,ii) = one
   end do

  ! ! Initialize inverse hessian with identity matrix
  ! ! in cartesian coordinates, which makes use of metric tensor gmet
  ! ! in reduced coordinates.
  ! hessin(:,:)=zero
  ! do ii=1,ab_mover%natom
  !   do kk=1,3
  !     do jj=1,3
  !       ! Warning : implemented in reduced coordinates
  !       if (ab_mover%iatfix(kk,ii)==0 .and.&
  !         & ab_mover%iatfix(jj,ii)==0 )then
  !         hessin(kk+3*(ii-1),jj+3*(ii-1))=gmet(kk,jj)
  !       end if
  !     end do
  !   end do
  ! end do
  ! if(ab_mover%optcell/=0)then
  !   ! These values might lead to too large changes in some cases
  !   diag=ab_mover%strprecon*30.0_dp/ucvol
  !   if(ab_mover%optcell==1) diag=diag/three
  !   do ii=3*ab_mover%natom+1,ndim
  !     hessin(ii,ii)=diag
  !   end do
  ! end if

   if (ab_mover%restartxf/=0) then

      call xfh_recover_deloc(ab_xfh,ab_mover,acell,acell0,cycl_main,&
& fred,hessin,ndim,rprim,rprimd0,strten,ucvol,ucvol0,vin,vin_prev,&
& vout,vout_prev,xred,deloc,deloc_int,deloc_force,bt_inv_matrix,gprimd,prim_int,&
& u_matrix)

   end if

end if

if(itime>1)then
  ! Update the hessian matrix, by taking into account the
  ! current pair (x,f) and the previous one.
  call hessupdt(hessin,ab_mover%iatfix,ab_mover%natom,ndim,vin,&
    &     vin_prev,vout,vout_prev)

end if

! if(DEBUG)then
!   write (ab_out,*) '---XRA POST Hessupdt---'
!   call chkrprimd(acell,rprim,rprimd,ab_out)
!   write(ab_out,*) 'RPRIM'
!   do kk=1,3
!     write(ab_out,*) rprim(:,kk)
!   end do
!   write(ab_out,*) 'RPRIMD'
!   do kk=1,3
!     write(ab_out,*) rprimd(:,kk)
!   end do
!   write(ab_out,*) 'ACELL'
!   write(ab_out,*) acell(:)
! end if

! DEBUG (VIN,VOUT,HESSIN BEFORE PREDICTION)
if(DEBUG)then
  write(ab_out,*) 'VIN,VOUT,HESSIN BEFORE PREDICTION'
  write(ab_out,*) 'VECTOR INPUT (vin)'
  do ii=1,ndim,3
    if (ii+2<=ndim)then
      write(ab_out,*) ii,vin(ii:ii+2)
    else
      write(ab_out,*) ii,vin(ii:ndim)
    end if
  end do
  write(ab_out,*) 'VECTOR OUTPUT (vout)'
  do ii=1,ndim,3
    if (ii+2<=ndim)then
      write(ab_out,*) ii,vout(ii:ii+2)
    else
      write(ab_out,*) ii,vout(ii:ndim)
    end if
  end do
  write(ab_out,*) 'Hessian matrix ',ndim,'x',ndim
  do kk=1,ndim
    do jj=1,ndim,3
      if (jj+2<=ndim)then
        write(ab_out,*) jj,hessin(jj:jj+2,kk)
      else
        write(ab_out,*) jj,hessin(jj:ndim,kk)
      end if
    end do
  end do
end if

!write(*,*) 'delocint 08'
! ##########################################################
! ### 08. Compute the next values

if(ionmov==10 .or. itime==1)then

  ! Previous cartesian coordinates
  vin_prev(:)=vin(:)

  ! New atomic cartesian coordinates are obtained from vin, hessin
  ! and vout
  do ii=1,ndim
    vin(:)=vin(:)-hessin(:,ii)*vout(ii)
  end do
  ! Previous atomic forces
  vout_prev(:)=vout(:)

  ! DEBUG (VIN,VOUT,HESSIN AFTER PREDICTION)
  if(DEBUG)then
    write(ab_out,*) 'VIN,VOUT,HESSIN AFTER PREDICTION'
    write(ab_out,*) 'VECTOR INPUT (vin)'
    do ii=1,ndim,3
      if (ii+2<=ndim)then
        write(ab_out,*) ii,vin(ii:ii+2)
      else
        write(ab_out,*) ii,vin(ii:ndim)
      end if
    end do
    write(ab_out,*) 'VECTOR OUTPUT (vout)'
    do ii=1,ndim,3
      if (ii+2<=ndim)then
        write(ab_out,*) ii,vout(ii:ii+2)
      else
        write(ab_out,*) ii,vout(ii:ndim)
      end if
    end do
  end if

else
  if(ionmov==11)then

    etotal_prev=hist%histE(hist%ihist-1)
    ! Here the BFGS algorithm, modified to take into account the
    ! energy
    call brdene(etotal,etotal_prev,hessin,&
      & ndim,vin,vin_prev,vout,vout_prev)

  end if

  ! Implement fixing of atoms : put back old values for fixed
  ! components
  do kk=1,ab_mover%natom
    do jj=1,3
      ! Warning : implemented in reduced coordinates
      if ( ab_mover%iatfix(jj,kk)==1) then
        vin(jj+(kk-1)*3)=vin_prev(jj+(kk-1)*3)
      end if
    end do
  end do
end if

!write(*,*) 'delocint 09'
! ##########################################################
! ### 09. Convert from delocalized to xcart and xred

! Transfer vin  to deloc_int, acell and rprim
option=2
call xfpack(acell, acell0, deloc_force, ab_mover%natom-1, ndim,&
  & ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
  & ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
  & vin, vout, deloc_int)

if(DEBUG)then
  write (ab_out,*) '---deloc_int AFTER XFPACK ---'
  write(ab_out,*) 'deloc_int'
  do ii=1,ndeloc,3
    if (ii+2<=ndeloc)then
      write(ab_out,*) ii,deloc_int(ii:ii+2)
    else
      write(ab_out,*) ii,deloc_int(ii:ndeloc)
    end if
  end do
  write(ab_out,*) 'BT Inverse Matrix'
  do ii=1,3*ab_mover%natom
     write(ab_out,*) bt_inv_matrix(:,ii)
  end do

end if

 if(DEBUG)then
    write (ab_out,*) 'xcart (before deloc2xcart)'
    do ii=1,ab_mover%natom
       write (ab_out,*) xcart(:,ii)
    end do
 end if

!  this routine contains an iterative scheme to find xcart
!  from the non-linear relations between deloc and xcart
!  SIGNIFICANTLY DIFFERENT FROM xcart2deloc
   call deloc2xcart(deloc,ab_mover%natom,rprimd,xcart,&
&   deloc_int,bt_inv_matrix,u_matrix)

!  Convert new xcart (cartesian) to xred (reduced coordinates)
   call xredxcart(ab_mover%natom,-1,rprimd,xcart,xred)


!write(*,*) 'delocint 10'
! ##########################################################
! ### 10. Update the history with the prediction

! Increase indexes
hist%ihist=hist%ihist+1

if(ab_mover%optcell/=0)then
  call mkrdim(acell,rprim,rprimd)
  call metric(gmet,gprimd,-1,rmet,rprimd,ucvol)
end if

! DEBUG (XRA AFTER PREDICTION)
if(DEBUG)then
  write (ab_out,*) '---XRA AFTER PREDICTION ---'
  call chkrprimd(acell,rprim,rprimd,ab_out)
  write (ab_out,*) 'XCART'
  do kk=1,ab_mover%natom
    write (ab_out,*) xcart(:,kk)
  end do
  write (ab_out,*) 'XRED'
  do kk=1,ab_mover%natom
    write (ab_out,*) xred(:,kk)
  end do
  write (ab_out,*) 'RPRIM'
  do kk=1,3
    write (ab_out,*) rprim(:,kk)
  end do
  write(ab_out,*) 'RPRIMD'
  do kk=1,3
    write(ab_out,*) rprimd(:,kk)
  end do
  write(ab_out,*) 'ACELL'
  write(ab_out,*) acell(:)
end if

! Fill the history with the variables
! xcart, xred, acell, rprimd
call var2hist(ab_mover,hist,acell,rprimd,xcart,xred)

hist%histV(:,:,hist%ihist)=hist%histV(:,:,hist%ihist-1)

end subroutine pred_delocint
!!***
