!{\src2tex{textfont=tt}}
!!****f* ABINIT/pred_langevin
!! NAME
!! pred_langevin
!!
!! FUNCTION
!! Ionmov predictors (9) Langevin dynamics algorithm
!!
!! IONMOV 9:
!! Uses a Langevin dynamics algorithm :
!! see J. Chelikowsky, J. Phys. D : Appl Phys. 33(2000)R33
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR, JCC, SE)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT (in)
!! ab_mover <type(ab_movetype)> : Datatype with all the information
!!                                needed by the preditor
!! itime  : Index of the present iteration
!! ntime  : Maximal number of iterations
!! ionmov : (2 or 3) Specific kind of BFGS
!!
!! OUTPUT (out)
!!
!! SIDE EFFECTS (inout)
!! hist <type(ab_movehistory)> : History of positions,forces
!!                               acell, rprimd, stresses
!!
!! NOTES
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!      brdene,chkexi,fconv,hessinit,hessupdt,initylmg,leave_new,
!!      metric,mkrdim, prtxvf,scfcv_tmp,status,wrtout,xfpack,
!!      xredxcart
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pred_langevin(ab_mover,hist,ionmov,itime,ntime)

! define dp,sixth,third,etc...
 use defs_basis
! type(ab_movetype), type(ab_movehistory)
 use defs_mover

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_42_geometry
 use interfaces_42_geomoptim
 use interfaces_67_common
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(ab_movetype),intent(in) :: ab_mover
 type(ab_movehistory),intent(inout) :: hist
 integer, intent(in) :: itime
 integer, intent(in) :: ntime
 integer, intent(in) :: ionmov

!Local variables-------------------------------
!scalars
 integer  :: ndim,option
 integer  :: ii,jj,kk
 real(dp) :: ucvol,ucvol0
 real(dp) :: etotal,etotal_prev
 real(dp) :: diag,favg
!arrays
 real(dp),allocatable,save :: hessin(:,:),vin(:),vin_prev(:)
 real(dp),allocatable,save :: vout(:),vout_prev(:)
 real(dp) :: acell(3),acell0(3)
 real(dp) :: rprimd(3,3),rprimd0(3,3),rprim(3,3)
 real(dp) :: gprimd(3,3)
 real(dp) :: gmet(3,3)
 real(dp) :: rmet(3,3)
 real(dp) :: fred(3,ab_mover%natom),fred_corrected(3,ab_mover%natom)
 real(dp) :: xred(3,ab_mover%natom),xcart(3,ab_mover%natom)
 real(dp) :: strten(6)

write(*,*) 'bfgs 01'
! ##########################################################
! ### 01. Compute the dimension of vectors (ndim)

 ndim=3*ab_mover%natom
 if(ab_mover%optcell==1 .or.&
      & ab_mover%optcell==4 .or.&
      & ab_mover%optcell==5 .or.&
      & ab_mover%optcell==6) ndim=ndim+1
 if(ab_mover%optcell==2 .or.&
      & ab_mover%optcell==3) ndim=ndim+6
 if(ab_mover%optcell==7 .or.&
      & ab_mover%optcell==8 .or.&
      & ab_mover%optcell==9) ndim=ndim+3

write(*,*) 'bfgs 02'
! ##########################################################
! ### 02. Allocate the vectors vin, vout and hessian matrix

 if (.not.allocated(vin)) allocate(vin(ndim))
 if (.not.allocated(vout)) allocate(vout(ndim))
 if (.not.allocated(vin_prev)) allocate(vin_prev(ndim))
 if (.not.allocated(vout_prev)) allocate(vout_prev(ndim))
 if (.not.allocated(hessin)) allocate(hessin(ndim,ndim))

write(*,*) 'bfgs 03'
! ##########################################################
! ### 03. Obtain the present values from the history

 xred(:,:)=hist%histXF(:,:,2,hist%ihist)
 fred(:,:)=hist%histXF(:,:,4,hist%ihist)
 etotal=hist%histE(hist%ihist)

 acell(:)=hist%histA(:,hist%ihist)
 rprimd(:,:)=hist%histR(:,:,hist%ihist)
 strten(:)=hist%histS(:,hist%ihist)

 !Compute rprim from rprimd and acell
 do kk=1,3
    do jj=1,3
       rprim(jj,kk)=rprimd(jj,kk)/acell(jj)
    end do
 end do

 write(*,*) 'RPRIMD'
 do ii=1,3
    write(*,*) rprimd(:,ii)
 end do
 call metric(gmet,gprimd,-1,rmet,rprimd,ucvol)
 write(*,*) 'RMET'
 do ii=1,3
    write(*,*) rmet(ii,:)
 end do

!Save initial values
 acell0(:)=acell(:)
 rprimd0(:,:)=rprimd(:,:)
 ucvol0=ucvol

!  Get rid of mean force on whole unit cell, but only if no
!  generalized constraints are in effect
   if(ab_mover%nconeq==0)then
     do ii=1,3
       favg=sum(fred(ii,:))/dble(ab_mover%natom)
       fred_corrected(ii,:)=fred(ii,:)-favg
       if(ab_mover%jellslab/=0.and.ii==3)&
            & fred_corrected(ii,:)=fred(ii,:)
     end do
   else
     fred_corrected(:,:)=fred(:,:)
   end if

write(*,*) 'bfgs 04'
! ##########################################################
! ### 04. Fill the vectors vin and vout

!Initialize input vectors : first vin, then vout
 option=1
 call xfpack(acell, acell0, fred, ab_mover%natom, ndim,&
& ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
& ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
& vin, vout, xred)
 option=3
 call xfpack(acell, acell0, fred_corrected, ab_mover%natom, ndim,&
& ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
& ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
& vin, vout, xred)

 write(*,*) 'Entering to BFGS'
 write(*,*) 'VECTOR INPUT (vin)'
 do ii=1,ndim,3
    write(*,*) ii,vin(ii:ii+2)
 end do

 write(*,*) 'VECTOR OUTPUT (vout)'
 do ii=1,ndim,3
    write(*,*) ii,vout(ii:ii+2)
 end do

write(*,*) 'bfgs 05'
! ##########################################################
! ### 05. Initialize or update the hessian matrix

!Initialise the Hessian matrix using gmet
 if (itime==1)then
!Initialize inverse hessian with identity matrix
!in cartesian coordinates, which makes use of metric tensor gmet
!in reduced coordinates.
    hessin(:,:)=zero
    do ii=1,ab_mover%natom
       do kk=1,3
          do jj=1,3
!            Warning : implemented in reduced coordinates
             if (ab_mover%iatfix(kk,ii)==0 .and.&
                  & ab_mover%iatfix(jj,ii)==0 )then
                hessin(kk+3*(ii-1),jj+3*(ii-1))=gmet(kk,jj)
             end if
          end do
       end do
    end do
    if(ab_mover%optcell/=0)then
!      These values might lead to too large changes in some cases ...
       diag=ab_mover%strprecon*30.0_dp/ucvol
       if(ab_mover%optcell==1) diag=diag/three
       do ii=3*ab_mover%natom+1,ndim
          hessin(ii,ii)=diag
       end do
    end if
 end if

 if(itime>1)then
!    Update the hessian matrix, by taking into account the
!    current pair (x,f) and the previous one.
    call hessupdt(hessin,ab_mover%iatfix,ab_mover%natom,ndim,vin,&
&     vin_prev,vout,vout_prev)
 end if

 write(*,*) 'Hessian matrix'
 do kk=1,ndim
    do jj=1,ndim,3
       write(*,*) hessin(jj:jj+2,kk)
    end do
 end do

!DEBUG
 write(*,*) 'Exiting from BFGS BEFORE'
 write(*,*) 'VECTOR INPUT (vin)'
 do ii=1,ndim,3
    write(*,*) ii,vin(ii:ii+2)
 end do
 write(*,*) 'VECTOR OUTPUT (vout)'
 do ii=1,ndim,3
    write(*,*) ii,vout(ii:ii+2)
 end do
!DEBUG


write(*,*) 'bfgs 06'
! ##########################################################
! ### 06. Compute the next values

 if(ionmov==2 .or. itime==1)then

!   Previous cartesian coordinates
    vin_prev(:)=vin(:)

!   New atomic cartesian coordinates are obtained from vin, hessin and vout
    do ii=1,ndim
       vin(:)=vin(:)-hessin(:,ii)*vout(ii)
    end do

!      Previous atomic forces
    vout_prev(:)=vout(:)

!DEBUG
 write(*,*) 'Exiting from BFGS AFTER'
 write(*,*) 'VECTOR INPUT (vin)'
 do ii=1,ndim,3
    write(*,*) ii,vin(ii:ii+2)
 end do
 write(*,*) 'VECTOR OUTPUT (vout)'
 do ii=1,ndim,3
    write(*,*) ii,vout(ii:ii+2)
 end do
!DEBUG

 else
    if(ionmov==3)then

       etotal_prev=hist%histE(hist%ihist-1)
!         Here the BFGS algorithm, modified to take into account the energy
       call brdene(etotal,etotal_prev,hessin,&
               & ndim,vin,vin_prev,vout,vout_prev)

    end if

!    Implement fixing of atoms : put back old values for fixed components
    do kk=1,ab_mover%natom
       do jj=1,3
!        Warning : implemented in reduced coordinates
          if ( ab_mover%iatfix(jj,kk)==1) then
             vin(jj+(kk-1)*3)=vin_prev(jj+(kk-1)*3)
          end if
       end do
    end do
 end if

write(*,*) 'bfgs 07'
! ##########################################################
! ### 07. Update the history with the prediction

! Increase indexes
hist%ihist=hist%ihist+1

!Transfer vin  to xred, acell and rprim
 option=2
 call xfpack(acell, acell0, fred, ab_mover%natom, ndim,&
& ab_mover%nsym, ab_mover%optcell, option, rprim, rprimd0,&
& ab_mover%strtarget, strten, ab_mover%symrel, ucvol, ucvol0,&
& vin, vout, xred)

      write(*,*) 'RPRIM original'
      do ii=1,3
         write(*,*) rprim(:,ii)
      end do


 !Compute rprimd from rprim and acell
 do kk=1,3
    do jj=1,3
       rprimd(jj,kk)=rprim(jj,kk)*acell(jj)
    end do
 end do

      write(*,*) 'RPRIMD computed'
      do ii=1,3
         write(*,*) rprimd(:,ii)
      end do


 !Compute xcart from xred, and rprimd
 call xredxcart(ab_mover%natom,1,rprimd,xcart,xred)

 hist%histXF(:,:,1,hist%ihist)=xcart(:,:)
 hist%histXF(:,:,2,hist%ihist)=xred(:,:)
 hist%histV(:,:,hist%ihist)=hist%histV(:,:,hist%ihist-1)

 hist%histA(:,hist%ihist)=acell(:)
 hist%histR(:,:,hist%ihist)=rprimd(:,:)

!DEBUG
 write(*,*) 'Exiting from BFGS'
 write(*,*) 'VECTOR INPUT (vin)'
 do ii=1,ndim,3
    write(*,*) ii,vin(ii:ii+2)
 end do
!DEBUG

write(*,*) 'bfgs 08'
! ##########################################################
! ### 08. Deallocate in the last iteration

 if(itime==ntime)then
    if (allocated(vin)) deallocate(vin)
    if (allocated(vout)) deallocate(vout)
    if (allocated(vin_prev)) deallocate(vin_prev)
    if (allocated(vout_prev)) deallocate(vout_prev)
    if (allocated(hessin)) deallocate(hessin)
 end if

end subroutine pred_langevin
!!***
