!{\src2tex{textfont=tt}}
!!****f* ABINIT/pred_simple
!! NAME
!! pred_simple
!!
!! FUNCTION
!! Ionmov predictors (4 & 6) Internal to SCFV
!!
!! IONMOV 4:
!! Conjugate gradient algorithm for simultaneous optimization
!! of potential and ionic degrees of freedom. It can be used with
!! iscf=2 and iscf=5 or 6
!!
!! IONMOV 5:
!! Simple relaxation of ionic positions according to (converged)
!! forces. Equivalent to ionmov=1 with zero masses, albeit the
!! relaxation coefficient is not vis, but iprcfc.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR, JCC, SE)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT (in)
!! ab_mover <type(ab_movetype)> : Datatype with all the information
!!                                needed by the preditor
!!
!! OUTPUT (out)
!!
!! SIDE EFFECTS (inout)
!! hist <type(ab_movehistory)> : History of positions,forces
!!                               acell, rprimd, stresses
!! NOTES
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pred_simple(ab_mover,hist)

! define dp,sixth,third,etc...
 use defs_basis
! type(ab_movetype), type(ab_movehistory)
 use defs_mover

 implicit none

!Arguments ------------------------------------
!scalars
 type(ab_movetype),intent(in) :: ab_mover
 type(ab_movehistory),intent(inout) :: hist
!Local variables-------------------------------
!scalars
 integer  :: kk,jj

 ! All the operations are internal to scfcv.F90

 ! XCART, XRED and VEL
 do kk=1,ab_mover%natom
    do jj=1,3
       hist%histXF(jj,kk,1,hist%ihist+1)=&
         & hist%histXF(jj,kk,1,hist%ihist)
       hist%histXF(jj,kk,2,hist%ihist+1)=&
         & hist%histXF(jj,kk,2,hist%ihist)
       hist%histV(jj,kk,hist%ihist+1)=&
         & hist%histV(jj,kk,hist%ihist)
    end do ! jj=1,3
 end do ! kk=1,ab_mover%natom

 ! ACELL
 ! For the 3 dimensions of space
 do jj=1,3
    hist%histA(jj,hist%ihist+1)=hist%histA(jj,hist%ihist)
 end do

 ! RPRIMD
 ! For the 3 dimensions of space
 do kk=1,3
    ! For the 3 dimensions of space
    do jj=1,3
       hist%histR(jj,kk,hist%ihist+1)=hist%histR(jj,kk,hist%ihist)
    end do
 end do

 hist%ihist=hist%ihist+1

end subroutine pred_simple
!!***
