!{\src2tex{textfont=tt}}
!!****f* ABINIT/scfcv_new
!! NAME
!! scfcv_new
!!
!! FUNCTION
!! WARNING : Temporary wrapper to scfcv
!! Self-consistent-field convergence.
!! Conducts set of passes or overall iterations of preconditioned
!! conjugate gradient algorithm to converge wavefunctions to
!! ground state and optionally to compute forces and energy.
!! This routine is called to compute forces for given atomic
!! positions or else to do non-SCF band structures.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (XG, GMR, AR, MKV, MT, FJ, MB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  paw_dmft  <type(paw_dmft_type)>= paw+dmft related data
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!!  electronpositron <type(electronpositron_type)>=quantities for the
!!      electron-positron annihilation
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  wffnew,wffnow=struct info for wf disk files.
!!  xred(3,natom)=reduced dimensionless atomic coordinates
!!  xred_old(3,natom)= at input, previous reduced dimensionless atomic
!!     coordinates at output, current xred is transferred to xred_old
!!
!! NOTES
!! It is worth to explain THE USE OF FFT GRIDS:
!! ============================================
!! In case of PAW:
!! ---------------
!!    Two FFT grids are used:
!!    - A "coarse" FFT grid (defined by ecut)
!!      for the application of the Hamiltonian on the plane waves basis.
!!      It is defined by nfft, ngfft, mgfft, ...
!!      Hamiltonian, wave-functions, density related to WFs (rhor here), ...
!!      are expressed on this grid.
!!    - A "fine" FFT grid (defined) by ecutdg)
!!      for the computation of the density inside PAW spheres.
!!      It is defined by nfftf, ngfftf, mgfftf, ...
!!      Total density, potentials, ...
!!      are expressed on this grid.
!! In case of norm-conserving:
!! ---------------------------
!!    - Only the usual FFT grid (defined by ecut) is used.
!!      It is defined by nfft, ngfft, mgfft, ...
!!      For compatibility reasons, (nfftf,ngfftf,mgfftf)
!!      are set equal to (nfft,ngfft,mgfft) in that case.
!!
!! PARENTS
!!      gstate,mover
!!
!! CHILDREN
!!      dtfil_init2,scfcv,wvl_mkrho,wvl_wfsinp_reformat
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

! ! THIS IS THE OBJECTIVE
! subroutine scfcv_new(ab_scfcv,dtset,electronpositron,paw_dmft,rprimd,wffnew,&
! &  wffnow,xred,xred_old)
! ! THIS IS THE OBJECTIVE

subroutine scfcv_new(ab_scfcv_in,cg,dtefield,dtfil,dtpawuj,&
&  dtset,eigen,electronpositron,hdr,initialized,&
&  irrzon,mpi_enreg,nfftf,occ,&
&  paw_dmft,pawfgr,pawrhoij,&
&  rec_set,resid,results_gs,&
&  rhog,rhor,rprimd,scf_history,symrec,taug,taur,wffnew,&
&  wffnow,wvl,xred,xred_old)

 use defs_basis
 use defs_datatypes
 use m_wffile
 use defs_abitypes
 use defs_scftypes
 use defs_wvltypes
 use defs_parameters
 use defs_rectypes
 use m_electronpositron, only : electronpositron_type,electronpositron_calctype
 use m_rec
 use m_io_tools, only : flush_unit
 use m_paw_dmft, only: paw_dmft_type
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_67_common
 use interfaces_79_seqpar_mpi
 use interfaces_95_drive, except_this_one => scfcv_new
!End of the abilint section

 implicit none


!Arguments ------------------------------------
!scalars
 type(ab_scfcv_args_in),intent(in) :: ab_scfcv_in
 type(dataset_type),intent(inout) :: dtset
 type(electronpositron_type),pointer :: electronpositron
 type(paw_dmft_type), intent(inout) :: paw_dmft
 type(wffile_type),intent(inout) :: wffnew,wffnow
!arrays
 real(dp), intent(inout) :: rprimd(3,3)
 real(dp), intent(inout) :: xred(3,dtset%natom),xred_old(3,dtset%natom)

! OLD ARGS
!Arguments ------------------------------------
!scalars
 integer,intent(inout) :: initialized,nfftf
 real(dp),pointer :: taug(:,:),taur(:,:)
 type(MPI_type),intent(inout) :: mpi_enreg
 type(datafiles_type),intent(inout) :: dtfil
 type(efield_type),intent(inout) :: dtefield
 type(hdr_type),intent(inout) :: hdr
 type(pawfgr_type),intent(inout) :: pawfgr
 type(recursion_type),intent(inout) :: rec_set
 type(results_gs_type),intent(inout) :: results_gs
 type(scf_history_type),intent(inout) :: scf_history
 type(wvl_data),intent(inout) :: wvl

!arrays
 integer, intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,(dtset%nspden/dtset%nsppol)-3*(dtset%nspden/4))
  !(nfft**(1-1/nsym) is 1 if nsym==1, and nfft otherwise)
 integer, intent(inout) :: symrec(3,3,dtset%nsym)
 real(dp), intent(inout) :: cg(2,dtset%mpw*ab_scfcv_in%nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
 real(dp), intent(inout) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
 real(dp), intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
 real(dp), pointer :: rhog(:,:),rhor(:,:)
 real(dp), intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
 type(macro_uj_type),intent(inout) :: dtpawuj(0:ab_scfcv_in%ndtpawuj)
 type(pawrhoij_type), intent(inout) :: pawrhoij(mpi_enreg%natom*ab_scfcv_in%psps%usepaw)
! OLD ARGS


!Local variables -------------------------
!scalars
 integer :: ii
 logical :: DEBUG=.FALSE.

! *********************************************************************

  if (DEBUG) then
   write(std_out,*) 'INTENT(IN) ARGUMENTS ON SCFCV'
   write(std_out,*) 'atindx=',ab_scfcv_in%atindx
   write(std_out,*) 'atindx1=',ab_scfcv_in%atindx1
   write(std_out,*) 'cpus=',ab_scfcv_in%cpus
   write(std_out,*) 'ecore=',ab_scfcv_in%ecore
   write(std_out,*) 'fatvshift=',ab_scfcv_in%fatvshift
   write(std_out,*) 'iapp=',ab_scfcv_in%iapp
   write(std_out,*) 'indsym=',ab_scfcv_in%indsym
   write(std_out,*) 'kg=',ab_scfcv_in%kg
   write(std_out,*) 'nattyp=',ab_scfcv_in%nattyp
   write(std_out,*) 'ndtpawuj=',ab_scfcv_in%ndtpawuj
   write(std_out,*) 'npwarr=',ab_scfcv_in%npwarr
   write(std_out,*) 'nspinor=',ab_scfcv_in%nspinor
!  write(std_out,*) 'pawang=',ab_scfcv_in%pawang
!  write(std_out,*) 'pawrad=',ab_scfcv_in%pawrad
!  write(std_out,*) 'pawtab=',ab_scfcv_in%pawtab
   write(std_out,*) 'phnons=',ab_scfcv_in%phnons
!  write(std_out,*) 'psps=',ab_scfcv_in%psps
   write(std_out,*) 'pwind=',ab_scfcv_in%pwind
   write(std_out,*) 'pwind_alloc=',ab_scfcv_in%pwind_alloc
   write(std_out,*) 'pwnsfac=',ab_scfcv_in%pwnsfac
   write(std_out,*) 'ylm=',ab_scfcv_in%ylm
   write(std_out,*) 'ylmgr=',ab_scfcv_in%ylmgr
  end if

!WVL - reformat the wavefunctions in the case of xred != xred_old
 if (dtset%usewvl == 1 .and. maxval(xred_old - xred) > zero) then
!  WVL - Before running scfcv, on non-first geometry step iterations,
!  we need to reformat the wavefunctions, taking into acount the new
!  coordinates.
!  We prepare to change rhog (to be removed) and rhor.
   deallocate(rhog)
   deallocate(rhor)

   call wvl_wfsinp_reformat(dtset, mpi_enreg,&
&   ab_scfcv_in%psps, rprimd, wvl, xred, xred_old)
   nfftf = dtset%nfft

   allocate(rhog(2, dtset%nfft))
   allocate(rhor(2, dtset%nfft))
   call wvl_mkrho(dtset,mpi_enreg,occ,&
&   rhor,wvl%wfs)
 end if

!Prepare the names of the auxiliary files whose name depend on the
!itimimage, iimage and itime loops.
 call dtfil_init2(dtfil,ab_scfcv_in%iapp,mpi_enreg)

 call scfcv(ab_scfcv_in%atindx,ab_scfcv_in%atindx1,cg,&
& ab_scfcv_in%cpus,dtefield,dtfil,dtpawuj,&
& dtset,ab_scfcv_in%ecore,eigen,electronpositron,&
& ab_scfcv_in%fatvshift,hdr,ab_scfcv_in%iapp,ab_scfcv_in%indsym,&
& initialized,irrzon,ab_scfcv_in%kg,mpi_enreg,&
& ab_scfcv_in%nattyp,ab_scfcv_in%ndtpawuj,nfftf,ab_scfcv_in%npwarr,&
& occ,paw_dmft,ab_scfcv_in%pawang,pawfgr,ab_scfcv_in%pawrad,&
& pawrhoij,ab_scfcv_in%pawtab,ab_scfcv_in%phnons,ab_scfcv_in%psps,&
& ab_scfcv_in%pwind,ab_scfcv_in%pwind_alloc,ab_scfcv_in%pwnsfac,rec_set,&
& resid,results_gs,rhog,rhor,rprimd,&
& scf_history,symrec,taug,taur,&
& wffnew,wffnow,wvl,xred,xred_old,ab_scfcv_in%ylm,ab_scfcv_in%ylmgr)

  if(DEBUG)then
   write(ab_out,*) 'rprimd='
   do ii=1,3
     write(ab_out,*) rprimd(:,ii)
   end do
   write(ab_out,*) 'xred='
   do ii=1,dtset%natom
     write(ab_out,*) xred(:,ii)
   end do
  end if

!write(std_err,*) 'scfcv_new: Total Energy=',results_gs%etotal

end subroutine scfcv_new
!!***
