!{\src2tex{textfont=tt}}
!!****f* ABINIT/scfcv_tmp
!! NAME
!! scfcv_tmp
!!
!! FUNCTION
!! WARNING : Temporary wrapper to scfcv
!! Self-consistent-field convergence.
!! Conducts set of passes or overall iterations of preconditioned
!! conjugate gradient algorithm to converge wavefunctions to
!! ground state and optionally to compute forces and energy.
!! This routine is called to compute forces for given atomic
!! positions or else to do non-SCF band structures.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (XG, GMR, AR, MKV, MT, FJ, MB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  atindx(natom)=index table for atoms (see scfcv.f)
!!  atindx1(natom)=index table for atoms, inverse of atindx (see scfcv.f)
!!  cpus= cpu time limit in seconds
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!   | mband=maximum number of bands
!!   | mgfft=maximum size of 1D FFTs for the "coarse" grid (see NOTES below)
!!   | mkmem =number of k points which can fit in memory; set to 0
!!   |        if use disk
!!   | mpw=maximum dimensioned size of npw.
!!   | natom=number of atoms in cell.
!!   | nfft=(effective) number of FFT grid points (for this processor)
!!   |      for the "coarse" grid (see NOTES below)
!!   | nkpt=number of k points
!!   | nspden=number of spin-density components
!!   | nsppol=1 for unpolarized, 2 for spin-polarized
!!   | nsym=number of symmetry elements in space group
!!  ecore=core psp energy (part of total energy) (hartree)
!!  iapp=indicates the eventual suffix to be appended to the generic
!!       output root
!!       if 0 : no suffix to be appended (called directly from gstate)
!!       if positive : append "_TIM//iapp" (called from move or brdmin)
!!       if -1 : append "_TIM0" (called from brdmin)
!!       if -2, -3, -4, -5: append "_TIMA", ... ,"_TIMD", (called from move)
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  mpi_enreg=informations about MPI parallelization
!!  nattyp(ntypat)= # atoms of each type.
!!  ndtpawuj=size of dtpawuj
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspinor=number of spinorial components of the wavefunctions
!!  paw_dmft  <type(paw_dmft_type)>= paw+dmft related data
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawfgr <type(pawfgr_type)>=fine grid parameters and related data
!!  pawrad(ntypat*usepaw) <type(pawrad_type)>=paw radial mesh and
!!        related data
!!  pawtab(ntypat*usepaw) <type(pawtab_type)>=paw tabulated starting data
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!   | mpsang= 1+maximum angular momentum for nonlocal pseudopotentials
!!  pwind(pwind_alloc,2,3) = array used to compute
!!           the overlap matrix smat between k-points (see initberry.f)
!!  pwind_alloc = first dimension of pwind
!!  pwnsfac(2,pwind_alloc) = phase factors for non-symmorphic translations
!!                           (see initberry.f)
!!  ylm(mpw*mkmem,mpsang*mpsang*useylm)= real spherical harmonics for
!!     each G and k point
!!  ylmgr(mpw*mkmem,3,mpsang*mpsang*useylm)= gradients of real
!!     spherical harmonics
!!
!! OUTPUT
!!  resid(mband*nkpt*nsppol)=residuals for each band over all k points
!!     and spins
!!
!! SIDE EFFECTS
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=updated wavefunctions;
!!     if mkmem>=nkpt, these are kept in a disk file.
!!  dtefield <type(efield_type)> = variables related to Berry phase
!!  dtpawuj(ndtpawuj)= data used for the automatic determination of U
!!     (relevant only for PAW+U) calculations (see initberry.f)
!!  eigen(mband*nkpt*nsppol)=array for holding eigenvalues (hartree)
!!  electronpositron <type(electronpositron_type)>=quantities for the
!!      electron-positron annihilation
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  indsym(4,nsym,natom)=indirect indexing array for atom labels
!!  initialized= if 0 the initialization of the gstate run is not yet
!!     finished
!!  irrzon(nfft**(1-1/nsym),2,(nspden/nsppol)-3*(nspden/4))=irreducible
!!     zone data
!!  nfftf=(effective) number of FFT grid points (for this processor)
!!     for the "fine" grid (see NOTES below)
!!  occ(mband*nkpt*nsppol)=occupation number for each band (often 2)
!!     at each k point
!!  pawrhoij(natom*usepaw) <type(pawrhoij_type)>= -PAW only- atomic
!!     occupancies
!!  phnons(2,nfft**(1-1/nsym),(nspden/nsppol)-3*(nspden/4))=nonsymmorphic
!!     translation phases
!!  results_gs <type(results_gs_type)>=results (energy and its components,
!!     forces and its components, the stress tensor) of a ground-state
!!     computation (should be made a pure output quantity)
!!  rhog(2,nfftf)=array for Fourier transform of electron density
!!  rhor(nfftf,nspden)=array for electron density in el./bohr**3
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  scf_history <type(scf_history_type)>=arrays obtained from previous
!!     SCF cycles
!!  symrec(3,3,nsym)=symmetry operations in reciprocal space
!!  taug(2,nfftf*dtset%usekden)=array for Fourier transform of kinetic
!!     energy density
!!  taur(nfftf,nspden*dtset%usekden)=array for kinetic energy density
!!  wffnew,wffnow=struct info for wf disk files.
!!  wvl <type(wvl_data)>=all wavelets data.
!!  xred(3,natom)=reduced dimensionless atomic coordinates
!!  xred_old(3,natom)= at input, previous reduced dimensionless atomic
!!     coordinates at output, current xred is transferred to xred_old
!!
!! NOTES
!! It is worth to explain THE USE OF FFT GRIDS:
!! ============================================
!! In case of PAW:
!! ---------------
!!    Two FFT grids are used:
!!    - A "coarse" FFT grid (defined by ecut)
!!      for the application of the Hamiltonian on the plane waves basis.
!!      It is defined by nfft, ngfft, mgfft, ...
!!      Hamiltonian, wave-functions, density related to WFs (rhor here), ...
!!      are expressed on this grid.
!!    - A "fine" FFT grid (defined) by ecutdg)
!!      for the computation of the density inside PAW spheres.
!!      It is defined by nfftf, ngfftf, mgfftf, ...
!!      Total density, potentials, ...
!!      are expressed on this grid.
!! In case of norm-conserving:
!! ---------------------------
!!    - Only the usual FFT grid (defined by ecut) is used.
!!      It is defined by nfft, ngfft, mgfft, ...
!!      For compatibility reasons, (nfftf,ngfftf,mgfftf)
!!      are set equal to (nfft,ngfft,mgfft) in that case.
!!
!! PARENTS
!!      brdmin,delocint,diisrelax,gstate,moldyn,move,pawuj_drive,
!!      scphon,mover
!!
!! CHILDREN
!!      wvl_wfsinp_reformat,wvl_mkrho,dtfil_init2,scfcv
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine scfcv_tmp(atindx,atindx1,cg,cpus,dtefield,dtfil,dtpawuj,&
&  dtset,ecore,eigen,electronpositron,hdr,iapp,indsym,initialized,&
&  irrzon,kg,mpi_enreg,nattyp,ndtpawuj,nfftf,npwarr,nspinor,occ,&
&  paw_dmft,pawang,pawfgr,pawrad,pawrhoij,pawtab,&
&  phnons,psps,pwind,pwind_alloc,pwnsfac,rec_set,resid,results_gs,&
&  rhog,rhor,rprimd,scf_history,fatvshift,symrec,taug,taur,wffnew,&
&  wffnow,wvl,xred,xred_old,ylm,ylmgr)

 use defs_basis
 use defs_datatypes
 use m_wffile
 use defs_abitypes
 use defs_scftypes
 use defs_wvltypes
 use defs_parameters
 use defs_rectypes
 use m_electronpositron, only : electronpositron_type,electronpositron_calctype
 use m_rec
 use m_io_tools, only : flush_unit
 use m_paw_dmft, only: paw_dmft_type
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_67_common
 use interfaces_79_seqpar_mpi
 use interfaces_95_drive, except_this_one => scfcv_tmp
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iapp,ndtpawuj,pwind_alloc
 integer,intent(inout) :: initialized,nfftf
 integer,intent(in) :: nspinor
 real(dp),intent(in) :: cpus,ecore
 real(dp),intent(in) :: fatvshift
 type(MPI_type),intent(inout) :: mpi_enreg
 type(datafiles_type),intent(inout) :: dtfil
 type(dataset_type),intent(inout) :: dtset
 type(efield_type),intent(inout) :: dtefield
 type(electronpositron_type),pointer :: electronpositron
 type(hdr_type),intent(inout) :: hdr
 type(pawang_type),intent(in) :: pawang
 type(pawfgr_type),intent(inout) :: pawfgr
 type(pseudopotential_type),intent(in) :: psps
 type(recursion_type),intent(inout) :: rec_set
 type(results_gs_type),intent(inout) :: results_gs
 type(scf_history_type),intent(inout) :: scf_history
 type(wffile_type),intent(inout) :: wffnew,wffnow
 type(wvl_data),intent(inout) :: wvl
!arrays
 integer,intent(in) :: atindx(dtset%natom),atindx1(dtset%natom)
 integer,intent(in) :: indsym(4,dtset%nsym,dtset%natom)
!no_abirules
 integer, intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,(dtset%nspden/dtset%nsppol)-3*(dtset%nspden/4))
  !(nfft**(1-1/nsym) is 1 if nsym==1, and nfft otherwise)
 integer, intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
 integer, intent(in) :: nattyp(psps%ntypat),npwarr(dtset%nkpt),pwind(pwind_alloc,2,3)
 integer, intent(inout) :: symrec(3,3,dtset%nsym)
 real(dp), intent(inout) :: cg(2,dtset%mpw*nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
 real(dp), intent(inout) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
 real(dp), intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
 real(dp), intent(in) :: phnons(2,dtset%nfft**(1-1/dtset%nsym),(dtset%nspden/dtset%nsppol)-3*(dtset%nspden/4))
  !(nfft**(1-1/nsym) is 1 if nsym==1, and nfft otherwise)
 real(dp), intent(in) :: pwnsfac(2,pwind_alloc)
 real(dp), intent(inout) :: rprimd(3,3)
 real(dp), pointer :: rhog(:,:),rhor(:,:)
 real(dp), pointer :: taug(:,:),taur(:,:)
 real(dp), intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
 real(dp), intent(inout) :: xred(3,dtset%natom),xred_old(3,dtset%natom)
 real(dp), intent(in) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
 real(dp), intent(in) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
 type(macro_uj_type),intent(inout) :: dtpawuj(0:ndtpawuj)
 type(pawrhoij_type), intent(inout) :: pawrhoij(mpi_enreg%natom*psps%usepaw)
 type(pawrad_type), intent(in) :: pawrad(psps%ntypat*psps%usepaw)
 type(pawtab_type), intent(in) :: pawtab(psps%ntypat*psps%usepaw)
 type(paw_dmft_type), intent(inout) :: paw_dmft
!Local variables -------------------------
!scalars
 integer :: ii
 logical :: DEBUG=.FALSE.

! *********************************************************************

  if (DEBUG) then
    write(ab_out,*) 'PRIMITIVE ARGUMENTS ON SCFCV'
    write(ab_out,*) 'iapp=',iapp
    write(ab_out,*) 'ndtpawuj=',ndtpawuj
    write(ab_out,*) 'pwind_alloc=',pwind_alloc
    write(ab_out,*) 'initialized=',initialized
    write(ab_out,*) 'nfftf=',nfftf
    write(ab_out,*) 'nspinor=',nspinor
    write(ab_out,*) 'cpus=',cpus
    write(ab_out,*) 'ecore=',ecore
    write(ab_out,*) 'fatvshift=',fatvshift
    write(ab_out,*) 'atindx=',atindx
    write(ab_out,*) 'indsym=',indsym
    write(ab_out,*) 'irrzon=',irrzon
!  write(ab_out,*) 'kg=',kg
    write(ab_out,*) 'nattyp=',nattyp
    write(ab_out,*) 'npwarr=',npwarr
    write(ab_out,*) 'pwind=',pwind
    write(ab_out,*) 'symrec=',symrec
!  write(ab_out,*) 'cg=',cg
    write(ab_out,*) 'eigen=',eigen
    write(ab_out,*) 'occ=', occ
    write(ab_out,*) 'phnons=',phnons
    write(ab_out,*) 'pwnsfac=',pwnsfac
    write(ab_out,*) 'rprimd='
    do ii=1,3
      write(ab_out,*) rprimd(:,ii)
    end do
    write(ab_out,*) 'resid=',resid
    write(ab_out,*) 'xred='
    do ii=1,dtset%natom
      write(ab_out,*) xred(:,ii)
    end do
    write(ab_out,*) 'ylm=',ylm
    write(ab_out,*) 'ylmgr=',ylmgr

    if(associated(electronpositron)) write(ab_out,*) 'electronpositron is ASSOCIATED'
    if(.not.associated(electronpositron)) write(ab_out,*) 'electronpositron is NOT ASSOCIATED'

    if(associated(rhor)) write(ab_out,*) 'rhor is ASSOCIATED'
    if(.not.associated(rhor)) write(ab_out,*) 'rhor is NOT ASSOCIATED'

    if(associated(rhog)) write(ab_out,*) 'rhog is ASSOCIATED'
    if(.not.associated(rhog)) write(ab_out,*) 'rhog is NOT ASSOCIATED'

    if(associated(taug)) write(ab_out,*) 'taug is ASSOCIATED'
    if(.not.associated(taug)) write(ab_out,*) 'taug is NOT ASSOCIATED'

    if(associated(taur)) write(ab_out,*) 'taur is ASSOCIATED'
    if(.not.associated(taur)) write(ab_out,*) 'taur is NOT ASSOCIATED'

  end if


!WVL - reformat the wavefunctions in the case of xred != xred_old
 if (dtset%usewvl == 1 .and. maxval(xred_old - xred) > zero) then
!  WVL - Before running scfcv, on non-first geometry step iterations,
!  we need to reformat the wavefunctions, taking into acount the new
!  coordinates.
!  We prepare to change rhog (to be removed) and rhor.
   deallocate(rhog)
   deallocate(rhor)

   call wvl_wfsinp_reformat(dtset, mpi_enreg, psps, &
&   rprimd, wvl, xred, xred_old)
   nfftf = dtset%nfft

   allocate(rhog(2, dtset%nfft))
   allocate(rhor(2, dtset%nfft))
   call wvl_mkrho(dtset, mpi_enreg, occ, rhor, wvl%wfs)
 end if

!Prepare the names of the auxiliary files whose name depend on the
!itimimage, iimage and itime loops.
 call dtfil_init2(dtfil,iapp,mpi_enreg)

 call scfcv(atindx,atindx1,cg,cpus,dtefield,dtfil,dtpawuj,&
& dtset,ecore,eigen,electronpositron,fatvshift,hdr,iapp,&
& indsym,initialized, irrzon,kg,mpi_enreg,nattyp,ndtpawuj,nfftf,&
& npwarr,occ,paw_dmft,pawang,pawfgr,pawrad,pawrhoij,pawtab,&
& phnons,psps,pwind,pwind_alloc,pwnsfac,rec_set,resid,results_gs,&
& rhog,rhor,rprimd,scf_history,symrec,taug,taur,wffnew,wffnow,&
& wvl,xred,xred_old,ylm,ylmgr)

  if(DEBUG)then
   write(ab_out,*) 'rprimd='
   do ii=1,3
     write(ab_out,*) rprimd(:,ii)
   end do
   write(ab_out,*) 'xred='
   do ii=1,dtset%natom
     write(ab_out,*) xred(:,ii)
   end do
  end if

end subroutine scfcv_tmp
!!***
