!{\src2tex{textfont=tt}}
!!****p* ABINIT/abinit
!! NAME
!! abinit
!!
!! FUNCTION
!! Main routine for conducting Density-Functional Theory calculations or Many-Body Perturbation Theory calculations.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR, MKV, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! NOTES
!! The new user is strongly adviced to read the
!! latest version of the file ~abinit/doc/users/new_user_guide.html
!! before trying to modify or even use the code.
!! Even experienced users of the code should also be careful in coding,
!! please read the latest version of the file ~abinit/doc/developers/rules_coding
!!
!! The present main routine drives the following operations :
!!
!! 1) Eventually initialize MPI
!! 2) Initialize overall timing of run
!! 3) Print greeting for interactive user and
!!    Read names of files (input, output, rootinput, rootoutput, roottemporaries),
!!    create the name of the status file, initialize the status subroutine.
!! 4) Open output file and print herald at top of output and log files
!! 5) Read the input file, and store the information in a long string of characters
!! 6) Take ndtset from the input string, then allocate
!!    the arrays whose dimensions depends only on ndtset 
!! 7) Continue to analyze the input string, and allocate the remaining arrays.
!!    Also modulate the timing according to timopt.
!! 8) Finish to read the "file" file completely,
!!    and also initialize pspheads (the pseudopotential header information)
!! 9) Provide defaults for the variables that have not yet been initialized.
!! 10) Perform some global initialization, depending on the value of
!! pseudopotentials, parallelism variables, or macro input variables
!! 11) Call the main input routine.
!! 12) Echo input data to output file and log file
!! 13) Perform additional checks on input data
!!  At this stage, all the information from the "files" file and "input" file
!!  have been read and checked.
!! ___________________________________________
!! 14) Perform main calculation  (call driver)
!! -------------------------------------------
!!
!! 15) Give final echo of coordinates, etc.
!! 16) Timing analysis
!! 17) Bibliographical recommendations
!! 18) Delete the status file, and, for build-in tests,
!!       analyse the correctness of results
!! 19) Write the final timing, close the output file, and write a final line
!!       to the log file
!! 20) Eventual cleaning of MPI run
!!
!! TODO
!!  Reduce the number of tasks in this main routine ! Create subroutine to make the full init of input variables,
!!  including the echo ...
!!
!! INPUTS
!!  (main routine)
!!
!! OUTPUT
!!  (main routine)
!!
!! PARENTS
!!
!! CHILDREN
!!      ab6_invars_get_abinit_vars,ab6_invars_load,ab6_invars_set_flags
!!      ab6_invars_set_mpi,chkinp,chkvars,date_and_time,destroy_mpi_enreg
!!      driver,dtsetfree,dump_config,dump_cpp_options,dump_optim,herald,iofn1
!!      leave_new,leave_test,mpi_allreduce,mpi_comm_rank,mpi_comm_size
!!      nullify_mpi_enreg,out_acknowl,outvars,outxml_finalise,outxml_open
!!      papi_init,parsefile,print_kinds,status,testfi,timab,timana,timein
!!      wrtout,xmpi_end,xmpi_init
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

program abinit

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_parameters
 use m_ab6_invars
 use m_build_info
 use m_cppopts_dumper
 use m_optim_dumper
 use m_xmpi
#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_53_abiutil
 use interfaces_57_iovars
 use interfaces_95_drive
!End of the abilint section

 implicit none
#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments -----------------------------------

!Local variables-------------------------------
!fix for Fortran interfaces
!scalars
!character(len=30) :: token
!no_abirules
!
!===============================================================================
!  abinit_version designate overall code version
!  mpw=maximum number of planewaves in basis sphere
!  unkg,unkgq,unkg1,unkg,unwff1,unwff2,unwffgs,unwfkq,
!  unwft1,unwft2,unylm,unylm1,unpaw,unpaw1 and unpawq...
!!  define input and output unit numbers.
!   These unit numbers are transferred
!   down to the adequate routines.
!   Other unit numbers (ab_in,ab_out,std_out,tmp_unit)
!   have been defined in defs_basis.f .
!  The array filnam is used for the name of input and output files,
!  and roots for generic input, output or temporary files.
!  Pseudopotential file names are set in iofn2, and are contained in pspheads.
!  The name filstat will be needed beyond gstate to check
!  the appearance of the "exit" flag, to make a hasty exit, as well as
!  in order to output the status of the computation.
!==============================================================================
! Declarations
! Define input and output unit numbers (do not forget, unit 5 and 6
! are standard input and output)
! Also, unit number 21, 22 and 23 are used in nstdy3, for the 3 dot
! wavefunctions. Others unit numbers will be used in the case
! of the variational and 2n+1 expressions.
! In defs_basis, one defines :
!  std_in=5, ab_in=5, std_out=6, ab_out=7, tmp_unit=9, tmp_unit2=10
 integer,parameter :: unchi0=42,unddb=16,unddk=15,unkg1=19,unkg=17,unkgq=18
 integer,parameter :: unpaw=26,unpaw1=27,unpawq=28,unpos=30
 integer,parameter :: unwff1=1,unwff2=2,unwffgs=3,unwfkq=4,unwft1=11
 integer,parameter :: unwft2=12,unwftgs=13,unwftkq=14,unylm=24,unylm1=25
 integer,parameter :: unkss=40,unscr=41,unqps=43
! Define "level of the routine", for debugging purposes
 integer,parameter :: level=1
 integer :: choice,dmatpuflag,idtset,ierr,iexit,ii,iimage,iounit,istatr,istatshft,dtsetsId
 integer :: lenstr
 integer :: mu,mxgw_nqlwl,mxlpawu,mxmband,mxmband_upper,mxnatom,mxnatsph,mxnatpawu
 integer :: mxnatvshift,mxnconeq,mxnimage,mxnkptgw
 integer :: mxnkpt,mxnnos,mxnqptdm
 integer :: mxnspinor,mxnsppol,mxnsym,mxntypat,natom,ndtset
 integer :: ndtset_alloc,nfft,nimage,nkpt,npsp
 integer :: nsppol,prtvol,timopt,papiopt
 integer,allocatable :: nband(:),npwtot(:)
 real(dp) :: cpui,etotal,walli
 real(dp) :: strten(6),tsec(2)
 real(dp),allocatable :: fred(:,:),xred(:,:)
 character(len=24) :: codename
 character(len=500) :: message
 character(len=strlen) :: string
 character(len=fnlen) :: filstat
 character(len=fnlen) :: filnam(5)
!character(len=30) :: token
 type(dataset_type),pointer  :: dtsets(:)
 type(MPI_type) :: mpi_enreg
 type(pspheader_type),pointer :: pspheads(:)
 type(results_out_type),allocatable :: results_out(:)
 logical :: xml_output=.false.
 integer :: values(8)
 character(len=5) :: strzone
 character(len=8) :: strdat
 character(len=10) :: strtime
#if defined HAVE_MPI
 real(dp) :: tsec_s(2)
#endif
#if defined HAVE_MPI_IO
 integer :: data,fh
 integer :: mpi_status(MPI_STATUS_SIZE)
 integer (kind=MPI_OFFSET_KIND) :: offset
#endif

!******************************************************************
!
!1) Eventually initialize MPI : one should write a separate routine -init_mpi_enreg- for doing that !!
 call xmpi_init()

!Default for sequential use
 call nullify_mpi_enreg(mpi_enreg)

 mpi_enreg%world_comm=0
 mpi_enreg%world_group=0
 mpi_enreg%me=0
 mpi_enreg%nproc=1
 mpi_enreg%num_group_fft = 0 ! in some cases not initialized but referenced in xdef_comm.F90
 mpi_enreg%paral_compil=0
 mpi_enreg%paral_compil_fft=0
 mpi_enreg%paral_compil_mpio=0
 mpi_enreg%mode_para="n"
 mpi_enreg%flag_ind_kg_mpi_to_seq = 0

!MG080916 If we want to avoid MPI preprocessing options, %proc_distr should be always allocated and
!set to mpi_enreg%me. In such a way we can safely test its value inside loops parallelized over k-points
!For the time being, do not remove this line since it is needed in outkss.F90.
!nullify(mpi_enreg%proc_distrb)
!nullify(mpi_enreg%bandfft_kpt,mpi_enreg%tab_kpt_distrib)

!Initialize MPI
#if defined HAVE_MPI
 mpi_enreg%world_comm=MPI_COMM_WORLD
 mpi_enreg%world_group=MPI_GROUP_NULL
 call MPI_COMM_RANK(MPI_COMM_WORLD,mpi_enreg%me,ierr)
 call MPI_COMM_SIZE(MPI_COMM_WORLD,mpi_enreg%nproc,ierr)
 mpi_enreg%paral_compil=1
#endif

!Signal MPI I/O compilation has been activated
#if defined HAVE_MPI_IO
 mpi_enreg%paral_compil_mpio=1
 if(mpi_enreg%paral_compil==0)then
   write(message,'(6a)') ch10,&
&   ' abinit : ERROR -',ch10,&
&   '  In order to use MPI_IO, you must compile with the MPI flag ',ch10,&
&   '  Action : recompile your code with different CPP flags.'
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if
!Test the opening, writing, closing and deleting of a test file
!call MPI_FILE_OPEN(MPI_COMM_WORLD,"Testfile",MPI_MODE_WRONLY+MPI_MODE_CREATE,MPI_INFO_NULL,fh,ierr) 
!call print_ierr(ierr,"abinit","MPI_FILE_OPEN")
!Write 1 integer per proc
!data=mpi_enreg%me;offset=4*mpi_enreg%me
!call MPI_FILE_WRITE_AT(fh,offset,data,1,MPI_INTEGER,mpi_status,ierr)
!call print_ierr(ierr,"abinit","MPI_FILE_WRITE_AT")
!Close file
!call MPI_FILE_CLOSE(fh,ierr)
!call print_ierr(ierr,"abinit","MPI_FILE_CLOSE")
!Delete file
!call MPI_FILE_DELETE(fh,MPI_INFO_NULL,ierr)
!call print_ierr(ierr,"abinit","MPI_FILE_DELETE")
#endif

!Initialize spaceComm, used in leave_test
 mpi_enreg%spaceComm=mpi_enreg%world_comm
!Initialize paral_compil_kpt, actually always equal to paral_compil
!(paral_compil_kpt should be suppressed after big cleaning)
 mpi_enreg%paral_compil_kpt=0
 if(mpi_enreg%paral_compil==1) mpi_enreg%paral_compil_kpt=1

!Other values of mpi_enreg are dataset dependent, and should NOT be initialized
!inside abinit.F90 .
!XG 071118 : At present several other values are
!initialized temporarily inside invars1.F90, FROM THE DTSET
!VALUES. In order to releave the present constraint of having mpi_enreg
!equal for all datasets, they should be reinitialized from the dtset values
!inside invars2m.F90 (where there is a loop over datasets, and finally,
!reinitialized from the dataset values inside each big routine called by driver,
!according to the kind of parallelisation that is needed there.
!One should have one init_mpi_dtset routine (or another name) per big routine (well, there is also
!the problem of TDDFT ...). Also, one should have a clean_mpi_dtset called at the end
!of each big routine, as well as invars1.F90 or invars2m.F90 .

!2) Initialize overall timing of run:
#ifdef HAVE_TIMER_PAPI
 call papi_init()
#endif

 call timein(cpui,walli)

 call timab(1,0,tsec)

!Start to accumulate time for the entire run.
!The end of accumulation is in timana.f
 call timab(1,1,tsec)

!3) Print greeting for interactive user,
!read names of files (input, output, rootinput, rootoutput, roottemporaries),
!create the name of the status file, initialize the status subroutine.

 call timab(41,1,tsec)

 call iofn1(filnam,filstat,mpi_enreg)

 iexit=99
 call status(0,filstat,iexit,level,'first status  ')

!4) Open output file and print herald at top of output and log files

 if(mpi_enreg%me==0)then

   open (unit=ab_out,file=filnam(2),form='formatted',status='new')
   rewind (unit=ab_out)
   codename='ABINIT'//repeat(' ',18)
   call herald(codename,abinit_version,ab_out)
   call herald(codename,abinit_version,std_out)
   call dump_config()
   call dump_optim()
   call dump_cpp_options()
!  Write names of files
   write(message, '(a,a,a,a,a,a,a,a,a,a,a,a)' )&
&   '- input  file    -> ',trim(filnam(1)),ch10,&
&   '- output file    -> ',trim(filnam(2)),ch10,&
&   '- root for input  files -> ',trim(filnam(3)),ch10,&
&   '- root for output files -> ',trim(filnam(4)),ch10
   call wrtout(ab_out,message,'COLL')
   call wrtout(std_out,message,'COLL')
 end if

!5) Read the file, stringify it and return the number of datasets.
 call status(0,filstat,iexit,level,'call parsefile')
 call parsefile(filnam(1), lenstr, ndtset, string)

!6~11) Call the parser from the parser module.
 call ab6_invars_set_flags(.true., .true., status_file = filstat, &
& timab_tsec = tsec)

 call ab6_invars_set_mpi(mpi_enreg)

 call ab6_invars_load(dtsetsId, string, lenstr, ndtset, .true., .true.)

 call ab6_invars_get_abinit_vars(dtsetsId, dtsets, pspheads,&
& mxgw_nqlwl, mxlpawu, mxmband, mxmband_upper, mxnatom, mxnatpawu, &
& mxnatsph,  mxnatvshift, mxnconeq, mxnimage, mxnkpt, mxnkptgw, &
& mxnnos, mxnqptdm, mxnsppol, mxnspinor, mxnsym, mxntypat, &
& istatr, istatshft, papiopt, timopt, dmatpuflag)
 ndtset_alloc = size(dtsets) - 1
 npsp = size(pspheads)

!12) Echo input data to output file and log file

 call status(0,filstat,iexit,level,'call outvars(1')

 call timab(44,1,tsec)

!For evolving variables, and results
 allocate(results_out(0:ndtset_alloc))

 do idtset=0,ndtset_alloc
   nimage=dtsets(idtset)%nimage
   if(idtset==0)nimage=mxnimage
   allocate(results_out(idtset)%acell(3,mxnimage))
   allocate(results_out(idtset)%etotal(mxnimage))
   allocate(results_out(idtset)%fcart(3,mxnatom,mxnimage))
   allocate(results_out(idtset)%fred(3,mxnatom,mxnimage))
   allocate(results_out(idtset)%npwtot(mxnkpt,mxnimage))
   allocate(results_out(idtset)%occ(mxmband_upper*mxnkpt*mxnsppol,mxnimage))
   allocate(results_out(idtset)%rprim(3,3,mxnimage))
   allocate(results_out(idtset)%rprimd(3,3,mxnimage))
   allocate(results_out(idtset)%strten(6,mxnimage))
   allocate(results_out(idtset)%vel(3,mxnatom,mxnimage))
   allocate(results_out(idtset)%xred(3,mxnatom,mxnimage))

   results_out(idtset)%natom      =dtsets(idtset)%natom
   natom                          =dtsets(idtset)%natom
   if(idtset==0)natom=mxnatom
   results_out(idtset)%acell(:,1:nimage) =dtsets(idtset)%acell_orig(:,1:nimage)
   do iimage=1,nimage
     results_out(idtset)%occ(:,iimage)     =dtsets(idtset)%occ_orig(:)
   end do
   results_out(idtset)%rprim(:,:,1:nimage)=dtsets(idtset)%rprim_orig(:,:,1:nimage)
   results_out(idtset)%rprimd(:,:,1:nimage)=dtsets(idtset)%rprimd_orig(:,:,1:nimage)
   results_out(idtset)%vel(:,1:natom,1:nimage)   =dtsets(idtset)%vel_orig(:,1:natom,1:nimage)
   results_out(idtset)%xred(:,1:natom,1:nimage)  =dtsets(idtset)%xred_orig(:,1:natom,1:nimage)
   results_out(idtset)%etotal(:)     =zero
   results_out(idtset)%fred(:,:,:)  =zero
   results_out(idtset)%fcart(:,:,:) =zero
   results_out(idtset)%npwtot(:,:)  =0
   results_out(idtset)%strten(:,:)  =zero
 end do

 if(mpi_enreg%me==0) then

!  Echo input to output file on unit ab_out, and to log file on unit 06 :
   choice=1
   do ii=1,2
     if(ii==1)iounit=ab_out
     if(ii==2)iounit=std_out

     call outvars (choice,dmatpuflag,dtsets,iounit,istatr,istatshft,mpi_enreg,&
&     mxgw_nqlwl,mxlpawu,mxmband,mxnatom,mxnatpawu,mxnatsph,mxnatvshift,mxnconeq,mxnimage,mxnkptgw,mxnkpt,&
&     mxnnos,mxnqptdm,mxnspinor,mxnsppol,mxnsym,mxntypat,&
&     ndtset,ndtset_alloc,npsp,results_out,timopt)
   end do

   if (dtsets(1)%prtxml == 1) then
     call outxml_open(trim(filnam(4)))
     call date_and_time(strdat,strtime,strzone,values)
     xml_output = .true.
   else
     xml_output = .false.
   end if

 end if ! End of me==0 section

!This synchronization is not strictly needed, but without it,
!there are problems with Tv1#93 in parallel, PGI compiler, on Intel/PC
 call leave_test(mpi_enreg)

 call timab(44,2,tsec)

!13) Perform additional checks on input data

 call status(0,filstat,iexit,level,'call chkinp   ')

 call timab(45,1,tsec)

 call chkinp(dtsets,ab_out,mpi_enreg,ndtset,ndtset_alloc,npsp,pspheads)

!Check whether the string only contains valid keywords
 call chkvars(string)

!At this stage, all the information from the "files" file and "input" file
!have been read and checked.

 call timab(45,2,tsec)

!14) Perform main calculation
!The timing is done in gstate

 call status(0,filstat,iexit,level,'call driver   ')

 prtvol=dtsets(1)%prtvol
 if(prtvol==-level)then
   write(message,'(a1,a,a1,a,i1,a)') ch10,' abinit : before driver ',&
&   ch10,'  prtvol=-',level,', debugging mode => stop '
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

!Printout of kinds and precisions.
 if (mpi_enreg%me==0) call print_kinds(std_out)

 call driver(abinit_version,cpui,dtsets,filnam,filstat,&
& mpi_enreg,ndtset,ndtset_alloc,npsp,pspheads,results_out)

 call status(0,filstat,iexit,level,'after driver  ')

!15) Give final echo of coordinates, etc.
 call timab(46,1,tsec)

 write(message,'(a,a,a,62a,80a)') ch10,&
& '== END DATASET(S) ',('=',mu=1,62),ch10,('=',mu=1,80)
 call wrtout(ab_out,message,'COLL')
 call wrtout(std_out,message,'COLL')

 if(mpi_enreg%me==0) then

!  Echo input to output file on unit ab_out, and to log file on unit 06
   choice=2
   do ii=1,2
     if(ii==1)iounit=ab_out
     if(ii==2)iounit=std_out
     write(iounit,*)' '
     call outvars (choice,dmatpuflag,dtsets,iounit,istatr,istatshft,mpi_enreg,&
&     mxgw_nqlwl,mxlpawu,mxmband,mxnatom,mxnatpawu,mxnatsph,mxnatvshift,mxnconeq,mxnimage,mxnkptgw,mxnkpt,&
&     mxnnos,mxnqptdm,mxnspinor,mxnsppol,mxnsym,mxntypat,&
&     ndtset,ndtset_alloc,npsp,results_out,timopt)
     if(ii==2)write(std_out,*)' '
   end do

 end if ! mpi_enreg%me==0

!In prevision of the next two calls, some variables need to be transfered.
!They concern the case ndtset<2, and nimage=1 so take first value.
 natom=dtsets(1)%natom ; nkpt=dtsets(1)%nkpt ; nsppol=dtsets(1)%nsppol
 nfft=dtsets(1)%nfft   ; etotal=results_out(1)%etotal(1)
 allocate(nband(nkpt*nsppol),npwtot(nkpt),fred(3,natom),xred(3,natom))
 fred(:,:)  =results_out(1)%fred(:,1:natom,1)
 nband(:)   =dtsets(1)%nband(1:nkpt*nsppol)
 npwtot(:)  =results_out(1)%npwtot(1:nkpt,1)
 strten(:)  =results_out(1)%strten(:,1)
 xred(:,:)  =results_out(1)%xred(:,1:natom,1)

 call timab(46,2,tsec)

!16) Timing analysis

 if(timopt/=0)then
   call status(0,filstat,iexit,level,'call timana   ')
   call timana (mpi_enreg, natom, nband, ndtset, nfft, nkpt, npwtot, nsppol, timopt, papiopt)
 else
#if defined HAVE_MPI
   if(mpi_enreg%me==0)then ! This is for the automatic tests
     write(ab_out,'(5a)')ch10,ch10,'- Timing analysis has been suppressed with timopt=0',ch10,ch10
   end if
#endif
 end if

!17) Bibliographical recommendations
 if(mpi_enreg%me==0) then
   do ii=1,2
     if(ii==1)iounit=ab_out
     if(ii==2)iounit=std_out
     call out_acknowl(dtsets,iounit,ndtset_alloc,npsp,pspheads)
   end do
 end if ! mpi_enreg%me==0


!18) Delete the status file, and, for build-in tests,
!analyse the correctness of results.

 if(ndtset==0)then
   call testfi(etotal,filnam,filstat,fred,natom,strten,xred)
 else
   open (tmp_unit,file=filstat,form='formatted',status='unknown')
   close (tmp_unit,status='delete')
!  $call delete_file(filstat)
 end if

!One should have here the explicit deallocation of all arrays
 do idtset=0,ndtset_alloc
   deallocate(results_out(idtset)%acell)
   deallocate(results_out(idtset)%etotal)
   deallocate(results_out(idtset)%fcart)
   deallocate(results_out(idtset)%fred)
   deallocate(results_out(idtset)%npwtot)
   deallocate(results_out(idtset)%occ)
   deallocate(results_out(idtset)%rprim)
   deallocate(results_out(idtset)%rprimd)
   deallocate(results_out(idtset)%strten)
   deallocate(results_out(idtset)%vel)
   deallocate(results_out(idtset)%xred)
 end do

 do idtset=0,ndtset_alloc
   call dtsetfree(dtsets(idtset))
 end do

 deallocate(dtsets,fred,nband,npwtot)
 deallocate(pspheads,results_out,xred)

!XG 100116 : I think one should have such a destroy mpi_enreg here, but it fails on buda ?!
!call destroy_mpi_enreg(mpi_enreg)

!19) Write the final timing, close the output file, and write a final line
!to the log file

 call timein(tsec(1),tsec(2))
 tsec(1)=tsec(1)-cpui
 tsec(2)=tsec(2)-walli

#if defined HAVE_MPI
 write(std_out, '(a,i4,a,f13.1,a,f13.1)' )&
& ' Proc.',mpi_enreg%me,' individual time (sec): cpu=',tsec(1),'  wall=',tsec(2)
 if(mpi_enreg%me==0)then
   write(ab_out, '(a,a,a,i4,a,f13.1,a,f13.1)' ) &
&   '-',ch10,'- Proc.',mpi_enreg%me,' individual time (sec): cpu=',tsec(1),'  wall=',tsec(2)
 end if
 call MPI_ALLREDUCE(tsec,tsec_s,2,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,ierr)
 tsec=tsec_s
#endif

 write(message, '(a,80a,a,a,a)' ) ch10,('=',mu=1,80),ch10,ch10,' Calculation completed.'
 call wrtout(ab_out,message,'COLL')

 if(mpi_enreg%me==0)then
   write(ab_out, '(a,f13.1,a,f13.1)' ) &
&   '+Overall time at end (sec) : cpu=',tsec(1),'  wall=',tsec(2)
   close (unit=ab_out)

   if (xml_output) then
     call outxml_finalise(tsec, values)
   end if

   write(message, '(a,a)' ) ch10,' Calculation completed.'
   call wrtout(std_out,message,'COLL')
 end if

!20) Eventual cleaning of MPI run
 call destroy_mpi_enreg(MPI_enreg)
 call xmpi_end()

 end program abinit
!!***
