/* cuda_header.h */

/*
 * Copyright (C) 2008-2010 ABINIT Group (MMancini)
 *
 * This file is part of the ABINIT software package. For license information,
 * please see the COPYING file in the top-level directory of the ABINIT source
 * distribution.
 *
 */

#ifndef CUDA_HEADER_H
#define CUDA_HEADER_H



//#include <cutil.h>
#include <stdlib.h>
#include <unistd.h>
#include <cufft.h>
#include "config.h"
#include "cuda_common.h"


#ifdef HAVE_GPU_CUDA_DP
  typedef double cureal;
  typedef cufftDoubleComplex cucmplx;
#else
  typedef float cureal;
  typedef cufftComplex cucmplx;
  #define  rsqrt(a) rsqrtf(a)
#endif

typedef unsigned int uint;

void check_err(int);

#endif
