#!/usr/bin/python

import sys
import os
import os.path
import glob

def usage():
    print "\n Usage: docchk \n "



# construct list of input keywords that appear in chkvars.F90
chkvarsf90 = "../../../src/57_iovars/chkvars.F90"
if (os.path.isfile(chkvarsf90)):
    varfile = open(chkvarsf90)
else:
    print " \n File ", chkvarsf90," not found! "
    sys.exit(2)

in_block = False
words = []
for line in varfile:
    if line.find("admitted variable names") > 0:
        in_block = True
    if line.find("Extra token") > 0:
        in_block = False
    if in_block == True and line.find("list_var") > 0:
        line_words=(line.split("'")[1]).split()
        for i in range(len(line_words)):
            words.append(line_words[i])

print " ============================================================= "
print " ABINIT Input variables: Check in documentation                "
print " ============================================================= "
varhtml = glob.glob('../../../doc/input_variables/var*html')
varkeyhr = glob.glob('../../../doc/input_variables/keyhr.html')
for iwords in range(len(words)):
    deffiles = []
    for ivarhtml in range(len(varhtml)):
        varhtmldata = open(varhtml[ivarhtml]).read()
        if words[iwords] in varhtmldata:
            deffiles.append(varhtml[ivarhtml])
    if len(deffiles) > 0:
        print "SUCCESS: ",words[iwords]," appears in ",len(deffiles)," var*html files "
    else:
        print "FAIL: ",words[iwords]," does not appear in any var*html files "
    deffiles = []
    for ivarkeyhr in range(len(varkeyhr)):
        varkeyhrdata = open(varkeyhr[ivarkeyhr]).read()
        if words[iwords] in varkeyhrdata:
            deffiles.append(varkeyhr[ivarkeyhr])
    if len(deffiles) > 0:
        print "SUCCESS: ",words[iwords]," appears in ",len(deffiles)," keyhr.html file as well"
    else:
        print "FAIL: ",words[iwords]," does not appear in the central keyhr.html file "

print " ============================================================= "
print " ABINIT Input variables: Check in test suite                   "
print " ============================================================= "
for iwords in range(len(words)):
    autotest = False
    for root, dirs, files in os.walk('../..'):
        if root.find("Input")>0:
            for ifiles in range(len(files)):
                testfilename = os.path.join(root,files[ifiles])
                testfileinput = open(testfilename).read()
                if words[iwords] in testfileinput:
                    autotest = True
                    break
        if autotest == True:
            break
    if autotest == True:
        print "SUCCESS: ",words[iwords]," appears in automatic test suite "
    else: 
        print "FAIL: ",words[iwords]," does not appear in automatic test suite "
                
# construct list of key words appearing in anaddb input
invars9f90 = "../../../src/77_ddb/invars9.F90"
if (os.path.isfile(invars9f90)):
    varfile = open(invars9f90)
else:
    print " \n File ", invars9f90," not found! "
    sys.exit(2)

words = []
for line in varfile:
    if line.find("token = '") > 0:
        words.append(line.split("'")[1])

print " ============================================================= "
print " ANADDB Input variables: Check in documentation                "
print " ============================================================= "
varhtml = '../../../doc/users/anaddb_help.html'
for iwords in range(len(words)):
    varhtmldata = open(varhtml).read()
    if words[iwords] in varhtmldata:
        print "SUCCESS: ",words[iwords]," appears in ",varhtml
    else:
        print "FAIL: ",words[iwords]," does not appear ",varhtml

print " ============================================================= "
print " ANADDB Input variables: Check in test suite                   "
print " ============================================================= "
for iwords in range(len(words)):
    autotest = False
    for root, dirs, files in os.walk('../..'):
        if root.find("Input")>0:
            for ifiles in range(len(files)):
                testfilename = os.path.join(root,files[ifiles])
                testfileinput = open(testfilename).read()
                if words[iwords] in testfileinput:
                    autotest = True
                    break
        if autotest == True:
            break
    if autotest == True:
        print "SUCCESS: ",words[iwords]," appears in automatic test suite "
    else: 
        print "FAIL: ",words[iwords]," does not appear in automatic test suite "
