# Copyright (C) 1998-2010 ABINIT group (XG)
# 
# The purpose of this script is to change the copyright year
# in nearly all files in the ABINIT package. Should be called from the top directory, with
# util/maintainers/change_year.sh */*.in */*/*.F90 */*/*.cf */*/*.html */*/*.tex */*/*.pl README */README */*/README */*/*.cnf */*/*.bat */*/*.com */*/*.src */*/*_ */*/*.mk */*/*.txt */*/*/*.pl */*/*.m4 */*/make* tests/*/*.sh */*/*.csh */*/*.py */*/*.in *.ac */*/*.am */*/*.help */*/*.c */*/*.m */*/*/*.out */*/*.h */*/*.cu */*/*.sav */*/*/*.log */*/*.conf */*/*env_bin INSTALL
# then 
# util/maintainers/change_year.sh config/scripts/add-header-typed config/scripts/add-targets-binaries config/scripts/add-targets-libraries config/scripts/build-autotools-framework config/scripts/clean-build-examples config/scripts/clean-source-tree doc/manpages/abinit.1 extras/bzr_helpers/abinit-forge-branch util/developers/mkroutine.sh util/maintainers/change2.sh util/maintainers/change.sh util/misc/change_perl.sh util/misc/fixed_to_free tests/cpu/Refs/changeref 
# 
# In the previous list, files without an extension are not treated (except the README files), 
# and */*/*.sh are not treated (except tests/*/*.sh), because of conflict with the present script file extension !!
# Also config/scripts/abilint cannot be treated automatically
# So, one should complement the present script with a search 
# grep 'past_year ABINIT' * */* */*/* */*/*/* */*/*/*/*
# and treat by hand the remaining files ...
#XG 100118 Remarked still many other problems with copyrights, by using the following command :
# grep -i opyright * */* */*/* */*/*/* */*/*/*/* | grep -v 'present_year' | grep -v '!! COPYRIGHT' | grep -v 'Oldenburg' | grep -v 'Stefan Goedecker' | grep -v 'doc/rel' | grep -v 'Remove' | grep -v'tests/' | grep -v 'EXC group' | grep -v 'PWSCF group' 

for file in "$@"
do
 echo "working on $file"
 rm -f tmp.yr*  
 sed -e 's&Copyright (c)&Copyright (C)&' $file > tmp.yrup
 sed -e 's&(C) 1987-2007 ABINIT&(C) 1987-2010 ABINIT&' tmp.yrup > tmp.yr87
 sed -e 's&(C) 1991-2007 ABINIT&(C) 1991-2010 ABINIT&' tmp.yr87 > tmp.yr91
 sed -e 's&(C) 1992-2007 ABINIT&(C) 1992-2010 ABINIT&' tmp.yr91 > tmp.yr92
 sed -e 's&(C) 1993-2007 ABINIT&(C) 1993-2010 ABINIT&' tmp.yr92 > tmp.yr93
 sed -e 's&(C) 1996-2007 ABINIT&(C) 1996-2010 ABINIT&' tmp.yr93 > tmp.yr96
 sed -e 's&(C) 1997-2007 ABINIT&(C) 1997-2010 ABINIT&' tmp.yr96 > tmp.yr97
 sed -e 's&(C) 1998-2007 ABINIT&(C) 1998-2010 ABINIT&' tmp.yr97 > tmp.yr98
 sed -e 's&(C) 1999-2007 ABINIT&(C) 1999-2010 ABINIT&' tmp.yr98 > tmp.yr99
 sed -e 's&(C) 2000-2007 ABINIT&(C) 2000-2010 ABINIT&' tmp.yr99 > tmp.yr00
 sed -e 's&(C) 2001-2007 ABINIT&(C) 2001-2010 ABINIT&' tmp.yr00 > tmp.yr01
 sed -e 's&(C) 2002-2007 ABINIT&(C) 2002-2010 ABINIT&' tmp.yr01 > tmp.yr02
 sed -e 's&(C) 2003-2007 ABINIT&(C) 2003-2010 ABINIT&' tmp.yr02 > tmp.yr03
 sed -e 's&(C) 2004-2007 ABINIT&(C) 2004-2010 ABINIT&' tmp.yr03 > tmp.yr04
 sed -e 's&(C) 2005-2007 ABINIT&(C) 2005-2010 ABINIT&' tmp.yr04 > tmp.yr05
 sed -e 's&(C) 2006-2007 ABINIT&(C) 2006-2010 ABINIT&' tmp.yr05 > tmp.yr06
 sed -e 's&(C) 2007-2007 ABINIT&(C) 2007-2010 ABINIT&' tmp.yr06 > tmp.yr07
 sed -e 's&(C) 2008-2007 ABINIT&(C) 2008-2010 ABINIT&' tmp.yr07 > tmp.yr08
 sed -e 's&(C) 2009-2007 ABINIT&(C) 2009-2010 ABINIT&' tmp.yr08 > tmp.yr09
 sed -e 's&(C) 2009 ABINIT&(C) 2009-2010 ABINIT&' tmp.yr09 > tmp.yr
 echo "changes done "
 # put the modified file at the correct place
 mv tmp.yr $file
 echo "file $file written "
done
rm -f tmp.yr*  
chmod 755 */*/*.sh */*/*.py */*/*.pl */*/*.com config/*/make* extras/*/make* */*/*env_bin
chmod 755 config/scripts/* extras/bzr_helpers/* util/*/* tests/cpu/Refs/changeref
