#!/usr/bin/env python
#
# Copyright (C) 2010 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# FIXME: detect duplicate definitions

from ConfigParser import ConfigParser
from time import gmtime,strftime

import commands
import os
import re
import sys

class MyConfigParser(ConfigParser):

  def optionxform(self,option):
    return str(option)

# ---------------------------------------------------------------------------- #

#
# Functions
#

env_ignore = list()
opt_ignore = ["fcflags_opt_*","status"]

def is_ignored(keyword):
  for opt in env_ignore + opt_ignore:
    if ( "*" in opt ):
      if ( re.match(opt,keyword) ):
        return True
    elif ( opt == keyword ):
        return True
  return False

# ---------------------------------------------------------------------------- #

#
# Main program
#

# Check if we are in the top of the ABINIT source tree
if ( not os.path.exists("configure.ac") or
     not os.path.exists("src/98_main/abinit.F90") ):
  print "%s: You must be in the top of an ABINIT source tree." % my_name
  print "%s: Aborting now." % my_name
  sys.exit(1)

# Init
re_env = re.compile("^[A-Z][0-9A-Z_]*")
re_opt = re.compile("^[a-z][0-9a-z_]*")

# Extract environment variables from config file
cnf_env = MyConfigParser()
cnf_env.read("config/specs/environment.conf")
env_config = list()
for env in cnf_env.sections():
  if ( cnf_env.get(env,"reset") == "no" ):
    if ( not is_ignored(env) ):
      env_config.append(env)
env_config.sort()

# Extract options from config file
cnf_opt = MyConfigParser()
cnf_opt.read("config/specs/options.conf")
opt_config = list()
opt_removed = list()
for opt in cnf_opt.sections():
  tmp_sta = cnf_opt.get(opt,"status")
  if ( tmp_sta == "removed" ):
    opt_removed.append(opt)
  elif  ( "renamed" in tmp_sta ):
    opt_removed.append(tmp_sta.split()[1])
    if ( not is_ignored(opt) ):
      opt_config.append(opt)
  else:
    if ( not is_ignored(opt) ):
      opt_config.append(opt)
opt_config.sort()
opt_removed.sort()

# Extract information from build example config file
cnf_bex = MyConfigParser()
cnf_bex.read("config/specs/build-examples.conf")
env_examples = list()
opt_examples = list()
env_dict = dict()
opt_dict = dict()
for bot in cnf_bex.sections():
  for var in cnf_bex.options(bot):
    if ( not is_ignored(var) ):
      if ( re_env.match(var) ):
        if ( not var in env_examples ):
          env_examples.append(var)
        if ( not var in env_dict ):
          env_dict[var] = list()
        env_dict[var].append(bot)
      elif ( re_opt.match(var) ):
        if ( not var in opt_examples ):
          opt_examples.append(var)
        if ( not var in opt_dict ):
          opt_dict[var] = list()
        opt_dict[var].append(bot)
env_examples.sort()
opt_examples.sort()

# Compare environment and options
denv_examples = [env for env in env_examples if not env in env_config]
dopt_examples = [opt for opt in opt_examples if not opt in opt_config + opt_removed]
dopt_removed = [opt for opt in opt_examples if opt in opt_removed]

nerr = len(denv_examples) + len(dopt_examples) + len(dopt_removed)

# Report any mismatch
if ( nerr > 0 ):
  sys.stderr.write("%s: reporting use of wrong options\n\n" % \
    (os.path.basename(sys.argv[0])))
  sys.stderr.write("X: R=Removed / U=Undefined\n\n")
  sys.stderr.write("%s  %-24s  %-48s\n" % \
    ("X","Forbidden option","Bot"))
  sys.stderr.write("%s  %s  %s\n" % ("-","-" * 24,"-" * 48))

  for env in denv_examples:
    for bot in env_dict[env]:
      sys.stderr.write("%s  %-24s  %-48s\n" % ("U",env,bot))
  for opt in dopt_examples:
    for bot in opt_dict[opt]:
      sys.stderr.write("%s  %-24s  %-48s\n" % ("U",opt,bot))
  for opt in dopt_removed:
    for bot in opt_dict[opt]:
      sys.stderr.write("%s  %-24s  %-48s\n" % ("R",opt,bot))

  sys.stderr.write("\n")
  sys.exit(1)
else:
  sys.exit(0)
