#!/usr/bin/env python

import os
import re
import sys

blas_routines = [
  "caxpy",
  "ccopy",
  "cdotc",
  "cdotu",
  "cgbmv",
  "cgemm",
  "cgemv",
  "cgerc",
  "cgeru",
  "chbmv",
  "chemm",
  "chemv",
  "cher",
  "cher2",
  "cher2k",
  "cherk",
  "chpmv",
  "chpr",
  "chpr2",
  "crotg",
  "cscal",
  "csrot",
  "csscal",
  "cswap",
  "csymm",
  "csyr2k",
  "csyrk",
  "ctbmv",
  "ctbsv",
  "ctpmv",
  "ctpsv",
  "ctrmm",
  "ctrmv",
  "ctrsm",
  "ctrsv",
  "dasum",
  "daxpy",
  "dcabs1",
  "dcopy",
  "ddot",
  "dgbmv",
  "dgemm",
  "dgemv",
  "dger",
  "dnrm2",
  "drot",
  "drotg",
  "drotm",
  "drotmg",
  "dsbmv",
  "dscal",
  "dsdot",
  "dspmv",
  "dspr",
  "dspr2",
  "dswap",
  "dsymm",
  "dsymv",
  "dsyr",
  "dsyr2",
  "dsyr2k",
  "dsyrk",
  "dtbmv",
  "dtbsv",
  "dtpmv",
  "dtpsv",
  "dtrmm",
  "dtrmv",
  "dtrsm",
  "dtrsv",
  "dzasum",
  "dznrm2",
  "icamax",
  "idamax",
  "isamax",
  "izamax",
  "lsame",
  "sasum",
  "saxpy",
  "scabs1",
  "scasum",
  "scnrm2",
  "scopy",
  "sdot",
  "sdsdot",
  "sgbmv",
  "sgemm",
  "sgemv",
  "sger",
  "snrm2",
  "srot",
  "srotg",
  "srotm",
  "srotmg",
  "ssbmv",
  "sscal",
  "sspmv",
  "sspr",
  "sspr2",
  "sswap",
  "ssymm",
  "ssymv",
  "ssyr",
  "ssyr2",
  "ssyr2k",
  "ssyrk",
  "stbmv",
  "stbsv",
  "stpmv",
  "stpsv",
  "strmm",
  "strmv",
  "strsm",
  "strsv",
  "xerbla",
  "xerbla_array",
  "zaxpy",
  "zcopy",
  "zdotc",
  "zdotu",
  "zdrot",
  "zdscal",
  "zgbmv",
  "zgemm",
  "zgemv",
  "zgerc",
  "zgeru",
  "zhbmv",
  "zhemm",
  "zhemv",
  "zher",
  "zher2",
  "zher2k",
  "zherk",
  "zhpmv",
  "zhpr",
  "zhpr2",
  "zrotg",
  "zscal",
  "zswap",
  "zsymm",
  "zsyr2k",
  "zsyrk",
  "ztbmv",
  "ztbsv",
  "ztpmv",
  "ztpsv",
  "ztrmm",
  "ztrmv",
  "ztrsm",
  "ztrsv"]

lapack_routines = [
  "cbdsqr",
  "cgbbrd",
  "cgbcon",
  "cgbequ",
  "cgbequb",
  "cgbrfs",
  "cgbrfsx",
  "cgbsv",
  "cgbsvx",
  "cgbsvxx",
  "cgbtf2",
  "cgbtrf",
  "cgbtrs",
  "cgebak",
  "cgebal",
  "cgebd2",
  "cgebrd",
  "cgecon",
  "cgeequ",
  "cgeequb",
  "cgees",
  "cgeesx",
  "cgeev",
  "cgeevx",
  "cgegs",
  "cgegv",
  "cgehd2",
  "cgehrd",
  "cgelq2",
  "cgelqf",
  "cgels",
  "cgelsd",
  "cgelss",
  "cgelsx",
  "cgelsy",
  "cgeql2",
  "cgeqlf",
  "cgeqp3",
  "cgeqpf",
  "cgeqr2",
  "cgeqrf",
  "cgerfs",
  "cgerfsx",
  "cgerq2",
  "cgerqf",
  "cgesc2",
  "cgesdd",
  "cgesv",
  "cgesvd",
  "cgesvx",
  "cgesvxx",
  "cgetc2",
  "cgetf2",
  "cgetrf",
  "cgetri",
  "cgetrs",
  "cggbak",
  "cggbal",
  "cgges",
  "cggesx",
  "cggev",
  "cggevx",
  "cggglm",
  "cgghrd",
  "cgglse",
  "cggqrf",
  "cggrqf",
  "cggsvd",
  "cggsvp",
  "cgtcon",
  "cgtrfs",
  "cgtsv",
  "cgtsvx",
  "cgttrf",
  "cgttrs",
  "cgtts2",
  "chbev",
  "chbevd",
  "chbevx",
  "chbgst",
  "chbgv",
  "chbgvd",
  "chbgvx",
  "chbtrd",
  "checon",
  "cheequb",
  "cheev",
  "cheevd",
  "cheevr",
  "cheevx",
  "chegs2",
  "chegst",
  "chegv",
  "chegvd",
  "chegvx",
  "cherfs",
  "cherfsx",
  "chesv",
  "chesvx",
  "chesvxx",
  "chetd2",
  "chetf2",
  "chetrd",
  "chetrf",
  "chetri",
  "chetrs",
  "chfrk",
  "chgeqz",
  "chla_transtype",
  "chpcon",
  "chpev",
  "chpevd",
  "chpevx",
  "chpgst",
  "chpgv",
  "chpgvd",
  "chpgvx",
  "chprfs",
  "chpsv",
  "chpsvx",
  "chptrd",
  "chptrf",
  "chptri",
  "chptrs",
  "chsein",
  "chseqr",
  "cla_gbamv",
  "cla_gbrcond_c",
  "cla_gbrcond_x",
  "cla_gbrfsx_extended",
  "cla_gbrpvgrw",
  "cla_geamv",
  "cla_gercond_c",
  "cla_gercond_x",
  "cla_gerfsx_extended",
  "cla_heamv",
  "cla_hercond_c",
  "cla_hercond_x",
  "cla_herfsx_extended",
  "cla_herpvgrw",
  "cla_lin_berr",
  "cla_porcond_c",
  "cla_porcond_x",
  "cla_porfsx_extended",
  "cla_porpvgrw",
  "cla_rpvgrw",
  "cla_syamv",
  "cla_syrcond_c",
  "cla_syrcond_x",
  "cla_syrfsx_extended",
  "cla_syrpvgrw",
  "cla_wwaddw",
  "clabrd",
  "clacgv",
  "clacn2",
  "clacon",
  "clacp2",
  "clacpy",
  "clacrm",
  "clacrt",
  "cladiv",
  "claed0",
  "claed7",
  "claed8",
  "claein",
  "claesy",
  "claev2",
  "clag2z",
  "clags2",
  "clagtm",
  "clahef",
  "clahqr",
  "clahr2",
  "clahrd",
  "claic1",
  "clals0",
  "clalsa",
  "clalsd",
  "clangb",
  "clange",
  "clangt",
  "clanhb",
  "clanhe",
  "clanhf",
  "clanhp",
  "clanhs",
  "clanht",
  "clansb",
  "clansp",
  "clansy",
  "clantb",
  "clantp",
  "clantr",
  "clapll",
  "clapmt",
  "claqgb",
  "claqge",
  "claqhb",
  "claqhe",
  "claqhp",
  "claqp2",
  "claqps",
  "claqr0",
  "claqr1",
  "claqr2",
  "claqr3",
  "claqr4",
  "claqr5",
  "claqsb",
  "claqsp",
  "claqsy",
  "clar1v",
  "clar2v",
  "clarcm",
  "clarf",
  "clarfb",
  "clarfg",
  "clarfp",
  "clarft",
  "clarfx",
  "clargv",
  "clarnv",
  "clarrv",
  "clarscl2",
  "clartg",
  "clartv",
  "clarz",
  "clarzb",
  "clarzt",
  "clascl",
  "clascl2",
  "claset",
  "clasr",
  "classq",
  "claswp",
  "clasyf",
  "clatbs",
  "clatdf",
  "clatps",
  "clatrd",
  "clatrs",
  "clatrz",
  "clatzm",
  "clauu2",
  "clauum",
  "clazro",
  "cpbcon",
  "cpbequ",
  "cpbrfs",
  "cpbstf",
  "cpbsv",
  "cpbsvx",
  "cpbtf2",
  "cpbtrf",
  "cpbtrs",
  "cpftrf",
  "cpftri",
  "cpftrs",
  "cpocon",
  "cpoequ",
  "cpoequb",
  "cporfs",
  "cporfsx",
  "cposv",
  "cposvx",
  "cposvxx",
  "cpotf2",
  "cpotrf",
  "cpotri",
  "cpotrs",
  "cppcon",
  "cppequ",
  "cpprfs",
  "cppsv",
  "cppsvx",
  "cpptrf",
  "cpptri",
  "cpptrs",
  "cpstf2",
  "cpstrf",
  "cptcon",
  "cpteqr",
  "cptrfs",
  "cptsv",
  "cptsvx",
  "cpttrf",
  "cpttrs",
  "cptts2",
  "crot",
  "cspcon",
  "cspmv",
  "cspr",
  "csprfs",
  "cspsv",
  "cspsvx",
  "csptrf",
  "csptri",
  "csptrs",
  "csrscl",
  "cstedc",
  "cstegr",
  "cstein",
  "cstemr",
  "csteqr",
  "csycon",
  "csyequb",
  "csymv",
  "csyr",
  "csyrfs",
  "csyrfsx",
  "csysv",
  "csysvx",
  "csysvxx",
  "csytf2",
  "csytrf",
  "csytri",
  "csytrs",
  "ctbcon",
  "ctbrfs",
  "ctbtrs",
  "ctfsm",
  "ctftri",
  "ctfttp",
  "ctfttr",
  "ctgevc",
  "ctgex2",
  "ctgexc",
  "ctgsen",
  "ctgsja",
  "ctgsna",
  "ctgsy2",
  "ctgsyl",
  "ctpcon",
  "ctprfs",
  "ctptri",
  "ctptrs",
  "ctpttf",
  "ctpttr",
  "ctrcon",
  "ctrevc",
  "ctrexc",
  "ctrrfs",
  "ctrsen",
  "ctrsna",
  "ctrsyl",
  "ctrti2",
  "ctrtri",
  "ctrtrs",
  "ctrttf",
  "ctrttp",
  "ctzrqf",
  "ctzrzf",
  "cung2l",
  "cung2r",
  "cungbr",
  "cunghr",
  "cungl2",
  "cunglq",
  "cungql",
  "cungqr",
  "cungr2",
  "cungrq",
  "cungtr",
  "cunm2l",
  "cunm2r",
  "cunmbr",
  "cunmhr",
  "cunml2",
  "cunmlq",
  "cunmql",
  "cunmqr",
  "cunmr2",
  "cunmr3",
  "cunmrq",
  "cunmrz",
  "cunmtr",
  "cupgtr",
  "cupmtr",
  "dbdsdc",
  "dbdsqr",
  "ddisna",
  "dgbbrd",
  "dgbcon",
  "dgbequ",
  "dgbequb",
  "dgbrfs",
  "dgbrfsx",
  "dgbsv",
  "dgbsvx",
  "dgbsvxx",
  "dgbtf2",
  "dgbtrf",
  "dgbtrs",
  "dgebak",
  "dgebal",
  "dgebd2",
  "dgebrd",
  "dgecon",
  "dgeequ",
  "dgeequb",
  "dgees",
  "dgeesx",
  "dgeev",
  "dgeevx",
  "dgegs",
  "dgegv",
  "dgehd2",
  "dgehrd",
  "dgejsv",
  "dgelq2",
  "dgelqf",
  "dgels",
  "dgelsd",
  "dgelss",
  "dgelsx",
  "dgelsy",
  "dgeql2",
  "dgeqlf",
  "dgeqp3",
  "dgeqpf",
  "dgeqr2",
  "dgeqrf",
  "dgerfs",
  "dgerfsx",
  "dgerq2",
  "dgerqf",
  "dgesc2",
  "dgesdd",
  "dgesv",
  "dgesvd",
  "dgesvj",
  "dgesvx",
  "dgesvxx",
  "dgetc2",
  "dgetf2",
  "dgetrf",
  "dgetri",
  "dgetrs",
  "dggbak",
  "dggbal",
  "dgges",
  "dggesx",
  "dggev",
  "dggevx",
  "dggglm",
  "dgghrd",
  "dgglse",
  "dggqrf",
  "dggrqf",
  "dggsvd",
  "dggsvp",
  "dgsvj0",
  "dgsvj1",
  "dgtcon",
  "dgtrfs",
  "dgtsv",
  "dgtsvx",
  "dgttrf",
  "dgttrs",
  "dgtts2",
  "dhgeqz",
  "dhsein",
  "dhseqr",
  "disnan",
  "dla_gbamv",
  "dla_gbrcond",
  "dla_gbrfsx_extended",
  "dla_gbrpvgrw",
  "dla_geamv",
  "dla_gercond",
  "dla_gerfsx_extended",
  "dla_lin_berr",
  "dla_porcond",
  "dla_porfsx_extended",
  "dla_porpvgrw",
  "dla_rpvgrw",
  "dla_syamv",
  "dla_syrcond",
  "dla_syrfsx_extended",
  "dla_syrpvgrw",
  "dla_wwaddw",
  "dlabad",
  "dlabrd",
  "dlacn2",
  "dlacon",
  "dlacpy",
  "dladiv",
  "dlae2",
  "dlaebz",
  "dlaed0",
  "dlaed1",
  "dlaed2",
  "dlaed3",
  "dlaed4",
  "dlaed5",
  "dlaed6",
  "dlaed7",
  "dlaed8",
  "dlaed9",
  "dlaeda",
  "dlaein",
  "dlaev2",
  "dlaexc",
  "dlag2",
  "dlag2s",
  "dlags2",
  "dlagtf",
  "dlagtm",
  "dlagts",
  "dlagv2",
  "dlahqr",
  "dlahr2",
  "dlahrd",
  "dlaic1",
  "dlaisnan",
  "dlaln2",
  "dlals0",
  "dlalsa",
  "dlalsd",
  "dlamch",
  "dlamrg",
  "dlaneg",
  "dlangb",
  "dlange",
  "dlangt",
  "dlanhs",
  "dlansb",
  "dlansf",
  "dlansp",
  "dlanst",
  "dlansy",
  "dlantb",
  "dlantp",
  "dlantr",
  "dlanv2",
  "dlapll",
  "dlapmt",
  "dlapy2",
  "dlapy3",
  "dlaqgb",
  "dlaqge",
  "dlaqp2",
  "dlaqps",
  "dlaqr0",
  "dlaqr1",
  "dlaqr2",
  "dlaqr3",
  "dlaqr4",
  "dlaqr5",
  "dlaqsb",
  "dlaqsp",
  "dlaqsy",
  "dlaqtr",
  "dlar1v",
  "dlar2v",
  "dlarf",
  "dlarfb",
  "dlarfg",
  "dlarfp",
  "dlarft",
  "dlarfx",
  "dlargv",
  "dlarnv",
  "dlarra",
  "dlarrb",
  "dlarrc",
  "dlarrd",
  "dlarre",
  "dlarrf",
  "dlarrj",
  "dlarrk",
  "dlarrr",
  "dlarrv",
  "dlarscl2",
  "dlartg",
  "dlartv",
  "dlaruv",
  "dlarz",
  "dlarzb",
  "dlarzt",
  "dlas2",
  "dlascl",
  "dlascl2",
  "dlasd0",
  "dlasd1",
  "dlasd2",
  "dlasd3",
  "dlasd4",
  "dlasd5",
  "dlasd6",
  "dlasd7",
  "dlasd8",
  "dlasda",
  "dlasdq",
  "dlasdt",
  "dlaset",
  "dlasq1",
  "dlasq2",
  "dlasq3",
  "dlasq4",
  "dlasq5",
  "dlasq6",
  "dlasr",
  "dlasrt",
  "dlassq",
  "dlasv2",
  "dlaswp",
  "dlasy2",
  "dlasyf",
  "dlat2s",
  "dlatbs",
  "dlatdf",
  "dlatps",
  "dlatrd",
  "dlatrs",
  "dlatrz",
  "dlatzm",
  "dlauu2",
  "dlauum",
  "dopgtr",
  "dopmtr",
  "dorg2l",
  "dorg2r",
  "dorgbr",
  "dorghr",
  "dorgl2",
  "dorglq",
  "dorgql",
  "dorgqr",
  "dorgr2",
  "dorgrq",
  "dorgtr",
  "dorm2l",
  "dorm2r",
  "dormbr",
  "dormhr",
  "dorml2",
  "dormlq",
  "dormql",
  "dormqr",
  "dormr2",
  "dormr3",
  "dormrq",
  "dormrz",
  "dormtr",
  "dpbcon",
  "dpbequ",
  "dpbrfs",
  "dpbstf",
  "dpbsv",
  "dpbsvx",
  "dpbtf2",
  "dpbtrf",
  "dpbtrs",
  "dpftrf",
  "dpftri",
  "dpftrs",
  "dpocon",
  "dpoequ",
  "dpoequb",
  "dporfs",
  "dporfsx",
  "dposv",
  "dposvx",
  "dposvxx",
  "dpotf2",
  "dpotrf",
  "dpotri",
  "dpotrs",
  "dppcon",
  "dppequ",
  "dpprfs",
  "dppsv",
  "dppsvx",
  "dpptrf",
  "dpptri",
  "dpptrs",
  "dpstf2",
  "dpstrf",
  "dptcon",
  "dpteqr",
  "dptrfs",
  "dptsv",
  "dptsvx",
  "dpttrf",
  "dpttrs",
  "dptts2",
  "drscl",
  "dsbev",
  "dsbevd",
  "dsbevx",
  "dsbgst",
  "dsbgv",
  "dsbgvd",
  "dsbgvx",
  "dsbtrd",
  "dsfrk",
  "dsgesv",
  "dspcon",
  "dspev",
  "dspevd",
  "dspevx",
  "dspgst",
  "dspgv",
  "dspgvd",
  "dspgvx",
  "dsposv",
  "dsprfs",
  "dspsv",
  "dspsvx",
  "dsptrd",
  "dsptrf",
  "dsptri",
  "dsptrs",
  "dstebz",
  "dstedc",
  "dstegr",
  "dstein",
  "dstemr",
  "dsteqr",
  "dsterf",
  "dstev",
  "dstevd",
  "dstevr",
  "dstevx",
  "dsycon",
  "dsyequb",
  "dsyev",
  "dsyevd",
  "dsyevr",
  "dsyevx",
  "dsygs2",
  "dsygst",
  "dsygv",
  "dsygvd",
  "dsygvx",
  "dsyrfs",
  "dsyrfsx",
  "dsysv",
  "dsysvx",
  "dsysvxx",
  "dsytd2",
  "dsytf2",
  "dsytrd",
  "dsytrf",
  "dsytri",
  "dsytrs",
  "dtbcon",
  "dtbrfs",
  "dtbtrs",
  "dtfsm",
  "dtftri",
  "dtfttp",
  "dtfttr",
  "dtgevc",
  "dtgex2",
  "dtgexc",
  "dtgsen",
  "dtgsja",
  "dtgsna",
  "dtgsy2",
  "dtgsyl",
  "dtpcon",
  "dtprfs",
  "dtptri",
  "dtptrs",
  "dtpttf",
  "dtpttr",
  "dtrcon",
  "dtrevc",
  "dtrexc",
  "dtrrfs",
  "dtrsen",
  "dtrsna",
  "dtrsyl",
  "dtrti2",
  "dtrtri",
  "dtrtrs",
  "dtrttf",
  "dtrttp",
  "dtzrqf",
  "dtzrzf",
  "dzsum1",
  "icmax1",
  "ieeeck",
  "ilaclc",
  "ilaclr",
  "iladiag",
  "iladlc",
  "iladlr",
  "ilaenv",
  "ilaprec",
  "ilaslc",
  "ilaslr",
  "ilatrans",
  "ilauplo",
  "ilaver",
  "ilazlc",
  "ilazlr",
  "iparmq",
  "izmax1",
  "lsame",
  "lsamen",
  "sbdsdc",
  "sbdsqr",
  "scsum1",
  "sdisna",
  "sgbbrd",
  "sgbcon",
  "sgbequ",
  "sgbequb",
  "sgbrfs",
  "sgbrfsx",
  "sgbsv",
  "sgbsvx",
  "sgbsvxx",
  "sgbtf2",
  "sgbtrf",
  "sgbtrs",
  "sgebak",
  "sgebal",
  "sgebd2",
  "sgebrd",
  "sgecon",
  "sgeequ",
  "sgeequb",
  "sgees",
  "sgeesx",
  "sgeev",
  "sgeevx",
  "sgegs",
  "sgegv",
  "sgehd2",
  "sgehrd",
  "sgejsv",
  "sgelq2",
  "sgelqf",
  "sgels",
  "sgelsd",
  "sgelss",
  "sgelsx",
  "sgelsy",
  "sgeql2",
  "sgeqlf",
  "sgeqp3",
  "sgeqpf",
  "sgeqr2",
  "sgeqrf",
  "sgerfs",
  "sgerfsx",
  "sgerq2",
  "sgerqf",
  "sgesc2",
  "sgesdd",
  "sgesv",
  "sgesvd",
  "sgesvj",
  "sgesvx",
  "sgesvxx",
  "sgetc2",
  "sgetf2",
  "sgetrf",
  "sgetri",
  "sgetrs",
  "sggbak",
  "sggbal",
  "sgges",
  "sggesx",
  "sggev",
  "sggevx",
  "sggglm",
  "sgghrd",
  "sgglse",
  "sggqrf",
  "sggrqf",
  "sggsvd",
  "sggsvp",
  "sgsvj0",
  "sgsvj1",
  "sgtcon",
  "sgtrfs",
  "sgtsv",
  "sgtsvx",
  "sgttrf",
  "sgttrs",
  "sgtts2",
  "shgeqz",
  "shsein",
  "shseqr",
  "sisnan",
  "sla_gbamv",
  "sla_gbrcond",
  "sla_gbrfsx_extended",
  "sla_gbrpvgrw",
  "sla_geamv",
  "sla_gercond",
  "sla_gerfsx_extended",
  "sla_lin_berr",
  "sla_porcond",
  "sla_porfsx_extended",
  "sla_porpvgrw",
  "sla_rpvgrw",
  "sla_syamv",
  "sla_syrcond",
  "sla_syrfsx_extended",
  "sla_syrpvgrw",
  "sla_wwaddw",
  "slabad",
  "slabrd",
  "slacn2",
  "slacon",
  "slacpy",
  "sladiv",
  "slae2",
  "slaebz",
  "slaed0",
  "slaed1",
  "slaed2",
  "slaed3",
  "slaed4",
  "slaed5",
  "slaed6",
  "slaed7",
  "slaed8",
  "slaed9",
  "slaeda",
  "slaein",
  "slaev2",
  "slaexc",
  "slag2",
  "slag2d",
  "slags2",
  "slagtf",
  "slagtm",
  "slagts",
  "slagv2",
  "slahqr",
  "slahr2",
  "slahrd",
  "slaic1",
  "slaisnan",
  "slaln2",
  "slals0",
  "slalsa",
  "slalsd",
  "slamch",
  "slamrg",
  "slaneg",
  "slangb",
  "slange",
  "slangt",
  "slanhs",
  "slansb",
  "slansf",
  "slansp",
  "slanst",
  "slansy",
  "slantb",
  "slantp",
  "slantr",
  "slanv2",
  "slapll",
  "slapmt",
  "slapy2",
  "slapy3",
  "slaqgb",
  "slaqge",
  "slaqp2",
  "slaqps",
  "slaqr0",
  "slaqr1",
  "slaqr2",
  "slaqr3",
  "slaqr4",
  "slaqr5",
  "slaqsb",
  "slaqsp",
  "slaqsy",
  "slaqtr",
  "slar1v",
  "slar2v",
  "slarf",
  "slarfb",
  "slarfg",
  "slarfp",
  "slarft",
  "slarfx",
  "slargv",
  "slarnv",
  "slarra",
  "slarrb",
  "slarrc",
  "slarrd",
  "slarre",
  "slarrf",
  "slarrj",
  "slarrk",
  "slarrr",
  "slarrv",
  "slarscl2",
  "slartg",
  "slartv",
  "slaruv",
  "slarz",
  "slarzb",
  "slarzt",
  "slas2",
  "slascl",
  "slascl2",
  "slasd0",
  "slasd1",
  "slasd2",
  "slasd3",
  "slasd4",
  "slasd5",
  "slasd6",
  "slasd7",
  "slasd8",
  "slasda",
  "slasdq",
  "slasdt",
  "slaset",
  "slasq1",
  "slasq2",
  "slasq3",
  "slasq4",
  "slasq5",
  "slasq6",
  "slasr",
  "slasrt",
  "slassq",
  "slasv2",
  "slaswp",
  "slasy2",
  "slasyf",
  "slatbs",
  "slatdf",
  "slatps",
  "slatrd",
  "slatrs",
  "slatrz",
  "slatzm",
  "slauu2",
  "slauum",
  "sopgtr",
  "sopmtr",
  "sorg2l",
  "sorg2r",
  "sorgbr",
  "sorghr",
  "sorgl2",
  "sorglq",
  "sorgql",
  "sorgqr",
  "sorgr2",
  "sorgrq",
  "sorgtr",
  "sorm2l",
  "sorm2r",
  "sormbr",
  "sormhr",
  "sorml2",
  "sormlq",
  "sormql",
  "sormqr",
  "sormr2",
  "sormr3",
  "sormrq",
  "sormrz",
  "sormtr",
  "spbcon",
  "spbequ",
  "spbrfs",
  "spbstf",
  "spbsv",
  "spbsvx",
  "spbtf2",
  "spbtrf",
  "spbtrs",
  "spftrf",
  "spftri",
  "spftrs",
  "spocon",
  "spoequ",
  "spoequb",
  "sporfs",
  "sporfsx",
  "sposv",
  "sposvx",
  "sposvxx",
  "spotf2",
  "spotrf",
  "spotri",
  "spotrs",
  "sppcon",
  "sppequ",
  "spprfs",
  "sppsv",
  "sppsvx",
  "spptrf",
  "spptri",
  "spptrs",
  "spstf2",
  "spstrf",
  "sptcon",
  "spteqr",
  "sptrfs",
  "sptsv",
  "sptsvx",
  "spttrf",
  "spttrs",
  "sptts2",
  "srscl",
  "ssbev",
  "ssbevd",
  "ssbevx",
  "ssbgst",
  "ssbgv",
  "ssbgvd",
  "ssbgvx",
  "ssbtrd",
  "ssfrk",
  "sspcon",
  "sspev",
  "sspevd",
  "sspevx",
  "sspgst",
  "sspgv",
  "sspgvd",
  "sspgvx",
  "ssprfs",
  "sspsv",
  "sspsvx",
  "ssptrd",
  "ssptrf",
  "ssptri",
  "ssptrs",
  "sstebz",
  "sstedc",
  "sstegr",
  "sstein",
  "sstemr",
  "ssteqr",
  "ssterf",
  "sstev",
  "sstevd",
  "sstevr",
  "sstevx",
  "ssycon",
  "ssyequb",
  "ssyev",
  "ssyevd",
  "ssyevr",
  "ssyevx",
  "ssygs2",
  "ssygst",
  "ssygv",
  "ssygvd",
  "ssygvx",
  "ssyrfs",
  "ssyrfsx",
  "ssysv",
  "ssysvx",
  "ssysvxx",
  "ssytd2",
  "ssytf2",
  "ssytrd",
  "ssytrf",
  "ssytri",
  "ssytrs",
  "stbcon",
  "stbrfs",
  "stbtrs",
  "stfsm",
  "stftri",
  "stfttp",
  "stfttr",
  "stgevc",
  "stgex2",
  "stgexc",
  "stgsen",
  "stgsja",
  "stgsna",
  "stgsy2",
  "stgsyl",
  "stpcon",
  "stprfs",
  "stptri",
  "stptrs",
  "stpttf",
  "stpttr",
  "strcon",
  "strevc",
  "strexc",
  "strrfs",
  "strsen",
  "strsna",
  "strsyl",
  "strti2",
  "strtri",
  "strtrs",
  "strttf",
  "strttp",
  "stzrqf",
  "stzrzf",
  "xerbla",
  "xerbla_array",
  "zbdsqr",
  "zcgesv",
  "zcposv",
  "zdrot",
  "zdrscl",
  "zgbbrd",
  "zgbcon",
  "zgbequ",
  "zgbequb",
  "zgbrfs",
  "zgbrfsx",
  "zgbsv",
  "zgbsvx",
  "zgbsvxx",
  "zgbtf2",
  "zgbtrf",
  "zgbtrs",
  "zgebak",
  "zgebal",
  "zgebd2",
  "zgebrd",
  "zgecon",
  "zgeequ",
  "zgeequb",
  "zgees",
  "zgeesx",
  "zgeev",
  "zgeevx",
  "zgegs",
  "zgegv",
  "zgehd2",
  "zgehrd",
  "zgelq2",
  "zgelqf",
  "zgels",
  "zgelsd",
  "zgelss",
  "zgelsx",
  "zgelsy",
  "zgeql2",
  "zgeqlf",
  "zgeqp3",
  "zgeqpf",
  "zgeqr2",
  "zgeqrf",
  "zgerfs",
  "zgerfsx",
  "zgerq2",
  "zgerqf",
  "zgesc2",
  "zgesdd",
  "zgesv",
  "zgesvd",
  "zgesvx",
  "zgesvxx",
  "zgetc2",
  "zgetf2",
  "zgetrf",
  "zgetri",
  "zgetrs",
  "zggbak",
  "zggbal",
  "zgges",
  "zggesx",
  "zggev",
  "zggevx",
  "zggglm",
  "zgghrd",
  "zgglse",
  "zggqrf",
  "zggrqf",
  "zggsvd",
  "zggsvp",
  "zgtcon",
  "zgtrfs",
  "zgtsv",
  "zgtsvx",
  "zgttrf",
  "zgttrs",
  "zgtts2",
  "zhbev",
  "zhbevd",
  "zhbevx",
  "zhbgst",
  "zhbgv",
  "zhbgvd",
  "zhbgvx",
  "zhbtrd",
  "zhecon",
  "zheequb",
  "zheev",
  "zheevd",
  "zheevr",
  "zheevx",
  "zhegs2",
  "zhegst",
  "zhegv",
  "zhegvd",
  "zhegvx",
  "zherfs",
  "zherfsx",
  "zhesv",
  "zhesvx",
  "zhesvxx",
  "zhetd2",
  "zhetf2",
  "zhetrd",
  "zhetrf",
  "zhetri",
  "zhetrs",
  "zhfrk",
  "zhgeqz",
  "zhpcon",
  "zhpev",
  "zhpevd",
  "zhpevx",
  "zhpgst",
  "zhpgv",
  "zhpgvd",
  "zhpgvx",
  "zhprfs",
  "zhpsv",
  "zhpsvx",
  "zhptrd",
  "zhptrf",
  "zhptri",
  "zhptrs",
  "zhsein",
  "zhseqr",
  "zla_gbamv",
  "zla_gbrcond_c",
  "zla_gbrcond_x",
  "zla_gbrfsx_extended",
  "zla_gbrpvgrw",
  "zla_geamv",
  "zla_gercond_c",
  "zla_gercond_x",
  "zla_gerfsx_extended",
  "zla_heamv",
  "zla_hercond_c",
  "zla_hercond_x",
  "zla_herfsx_extended",
  "zla_herpvgrw",
  "zla_lin_berr",
  "zla_porcond_c",
  "zla_porcond_x",
  "zla_porfsx_extended",
  "zla_porpvgrw",
  "zla_rpvgrw",
  "zla_syamv",
  "zla_syrcond_c",
  "zla_syrcond_x",
  "zla_syrfsx_extended",
  "zla_syrpvgrw",
  "zla_wwaddw",
  "zlabrd",
  "zlacgv",
  "zlacn2",
  "zlacon",
  "zlacp2",
  "zlacpy",
  "zlacrm",
  "zlacrt",
  "zladiv",
  "zlaed0",
  "zlaed7",
  "zlaed8",
  "zlaein",
  "zlaesy",
  "zlaev2",
  "zlag2c",
  "zlags2",
  "zlagtm",
  "zlahef",
  "zlahqr",
  "zlahr2",
  "zlahrd",
  "zlaic1",
  "zlals0",
  "zlalsa",
  "zlalsd",
  "zlangb",
  "zlange",
  "zlangt",
  "zlanhb",
  "zlanhe",
  "zlanhf",
  "zlanhp",
  "zlanhs",
  "zlanht",
  "zlansb",
  "zlansp",
  "zlansy",
  "zlantb",
  "zlantp",
  "zlantr",
  "zlapll",
  "zlapmt",
  "zlaqgb",
  "zlaqge",
  "zlaqhb",
  "zlaqhe",
  "zlaqhp",
  "zlaqp2",
  "zlaqps",
  "zlaqr0",
  "zlaqr1",
  "zlaqr2",
  "zlaqr3",
  "zlaqr4",
  "zlaqr5",
  "zlaqsb",
  "zlaqsp",
  "zlaqsy",
  "zlar1v",
  "zlar2v",
  "zlarcm",
  "zlarf",
  "zlarfb",
  "zlarfg",
  "zlarfp",
  "zlarft",
  "zlarfx",
  "zlargv",
  "zlarnv",
  "zlarrv",
  "zlarscl2",
  "zlartg",
  "zlartv",
  "zlarz",
  "zlarzb",
  "zlarzt",
  "zlascl",
  "zlascl2",
  "zlaset",
  "zlasr",
  "zlassq",
  "zlaswp",
  "zlasyf",
  "zlat2c",
  "zlatbs",
  "zlatdf",
  "zlatps",
  "zlatrd",
  "zlatrs",
  "zlatrz",
  "zlatzm",
  "zlauu2",
  "zlauum",
  "zlazro",
  "zpbcon",
  "zpbequ",
  "zpbrfs",
  "zpbstf",
  "zpbsv",
  "zpbsvx",
  "zpbtf2",
  "zpbtrf",
  "zpbtrs",
  "zpftrf",
  "zpftri",
  "zpftrs",
  "zpocon",
  "zpoequ",
  "zpoequb",
  "zporfs",
  "zporfsx",
  "zposv",
  "zposvx",
  "zposvxx",
  "zpotf2",
  "zpotrf",
  "zpotri",
  "zpotrs",
  "zppcon",
  "zppequ",
  "zpprfs",
  "zppsv",
  "zppsvx",
  "zpptrf",
  "zpptri",
  "zpptrs",
  "zpstf2",
  "zpstrf",
  "zptcon",
  "zpteqr",
  "zptrfs",
  "zptsv",
  "zptsvx",
  "zpttrf",
  "zpttrs",
  "zptts2",
  "zrot",
  "zspcon",
  "zspmv",
  "zspr",
  "zsprfs",
  "zspsv",
  "zspsvx",
  "zsptrf",
  "zsptri",
  "zsptrs",
  "zstedc",
  "zstegr",
  "zstein",
  "zstemr",
  "zsteqr",
  "zsycon",
  "zsyequb",
  "zsymv",
  "zsyr",
  "zsyrfs",
  "zsyrfsx",
  "zsysv",
  "zsysvx",
  "zsysvxx",
  "zsytf2",
  "zsytrf",
  "zsytri",
  "zsytrs",
  "ztbcon",
  "ztbrfs",
  "ztbtrs",
  "ztfsm",
  "ztftri",
  "ztfttp",
  "ztfttr",
  "ztgevc",
  "ztgex2",
  "ztgexc",
  "ztgsen",
  "ztgsja",
  "ztgsna",
  "ztgsy2",
  "ztgsyl",
  "ztpcon",
  "ztprfs",
  "ztptri",
  "ztptrs",
  "ztpttf",
  "ztpttr",
  "ztrcon",
  "ztrevc",
  "ztrexc",
  "ztrrfs",
  "ztrsen",
  "ztrsna",
  "ztrsyl",
  "ztrti2",
  "ztrtri",
  "ztrtrs",
  "ztrttf",
  "ztrttp",
  "ztzrqf",
  "ztzrzf",
  "zung2l",
  "zung2r",
  "zungbr",
  "zunghr",
  "zungl2",
  "zunglq",
  "zungql",
  "zungqr",
  "zungr2",
  "zungrq",
  "zungtr",
  "zunm2l",
  "zunm2r",
  "zunmbr",
  "zunmhr",
  "zunml2",
  "zunmlq",
  "zunmql",
  "zunmqr",
  "zunmr2",
  "zunmr3",
  "zunmrq",
  "zunmrz",
  "zunmtr",
  "zupgtr",
  "zupmtr"]

blacs_routines = [
  "blacs2sys_handle",
  "blacs_abort",
  "blacs_barrier",
  "blacs_exit",
  "blacs_freebuff",
  "blacs_get",
  "blacs_gridexit",
  "blacs_gridinfo",
  "blacs_gridinit",
  "blacs_gridmap",
  "blacs_pcoord",
  "blacs_pinfo",
  "blacs_pnum",
  "blacs_set",
  "blacs_setup",
  "cgamn2d",
  "cgamx2d",
  "cgebr2d",
  "cgebs2d",
  "cgerv2d",
  "cgesd2d",
  "cgsum2d",
  "ctrbr2d",
  "ctrbs2d",
  "ctrrv2d",
  "ctrsd2d",
  "dcputime00",
  "dgamn2d",
  "dgamx2d",
  "dgebr2d",
  "dgebs2d",
  "dgerv2d",
  "dgesd2d",
  "dgsum2d",
  "dtrbr2d",
  "dtrbs2d",
  "dtrrv2d",
  "dtrsd2d",
  "dwalltime00",
  "free_blacs_system_handle",
  "igamn2d",
  "igamx2d",
  "igebr2d",
  "igebs2d",
  "igerv2d",
  "igesd2d",
  "igsum2d",
  "bi_arecv",
  "bi_argcheck",
  "bi_asend",
  "bi_becomb",
  "bi_blacsabort",
  "bi_blacserr",
  "bi_blacswarn",
  "bi_buffisfree",
  "bi_cmpi_amn",
  "bi_cmpi_amn2",
  "bi_cmpi_amx",
  "bi_cmpi_amx2",
  "bi_cmpi_sum",
  "bi_contxtnum",
  "bi_cvvamn",
  "bi_cvvamn2",
  "bi_cvvamx",
  "bi_cvvamx2",
  "bi_cvvsum",
  "bi_dmpi_amn",
  "bi_dmpi_amn2",
  "bi_dmpi_amx",
  "bi_dmpi_amx2",
  "bi_dmvcopy",
  "bi_dvmcopy",
  "bi_dvvamn",
  "bi_dvvamn2",
  "bi_dvvamx",
  "bi_dvvamx2",
  "bi_dvvsum",
  "bi_emergencybuff",
  "bi_f77_get_constants",
  "bi_f77_init",
  "bi_f77_mpi_attr_get",
  "bi_f77_mpi_initialized",
  "bi_f77_mpi_op_create",
  "bi_f77_mpi_test",
  "bi_f77_mpi_testall",
  "bi_getbuff",
  "bi_getmpigetype",
  "bi_getmpitrtype",
  "bi_globalvars",
  "bi_hypbr",
  "bi_hypbs",
  "bi_idringbr",
  "bi_idringbs",
  "bi_impi_amn",
  "bi_impi_amn2",
  "bi_impi_amx",
  "bi_impi_amx2",
  "bi_imvcopy",
  "bi_ivmcopy",
  "bi_ivvamn",
  "bi_ivvamn2",
  "bi_ivvamx",
  "bi_ivvamx2",
  "bi_ivvsum",
  "bi_mpathbr",
  "bi_mpathbs",
  "bi_mpi_c_to_f77_trans_comm",
  "bi_mpi_f77_to_c_trans_comm",
  "bi_mringcomb",
  "bi_pack",
  "bi_rsend",
  "bi_smpi_amn",
  "bi_smpi_amn2",
  "bi_smpi_amx",
  "bi_smpi_amx2",
  "bi_smvcopy",
  "bi_srecv",
  "bi_sringbr",
  "bi_sringbs",
  "bi_ssend",
  "bi_svmcopy",
  "bi_svvamn",
  "bi_svvamn2",
  "bi_svvamx",
  "bi_svvamx2",
  "bi_svvsum",
  "bi_transdist",
  "bi_transusercomm",
  "bi_treebr",
  "bi_treebs",
  "bi_treecomb",
  "bi_unpack",
  "bi_updatebuffs",
  "bi_zmpi_amn",
  "bi_zmpi_amn2",
  "bi_zmpi_amx",
  "bi_zmpi_amx2",
  "bi_zmpi_sum",
  "bi_zvvamn",
  "bi_zvvamn2",
  "bi_zvvamx",
  "bi_zvvamx2",
  "bi_zvvsum",
  "itrbr2d",
  "itrbs2d",
  "itrrv2d",
  "itrsd2d",
  "kbrid",
  "kbsid",
  "krecvid",
  "ksendid",
  "makefile",
  "sgamn2d",
  "sgamx2d",
  "sgebr2d",
  "sgebs2d",
  "sgerv2d",
  "sgesd2d",
  "sgsum2d",
  "strbr2d",
  "strbs2d",
  "strrv2d",
  "strsd2d",
  "sys2blacs_handle",
  "zgamn2d",
  "zgamx2d",
  "zgebr2d",
  "zgebs2d",
  "zgerv2d",
  "zgesd2d",
  "zgsum2d",
  "ztrbr2d",
  "ztrbs2d",
  "ztrrv2d",
  "ztrsd2d"]

scalapack_routines = [
  "pslaed3",
  "pzlaevswp",
  "psgehd2",
  "pclattrs",
  "clahqr2",
  "pcstein",
  "pdlauum",
  "pdposv",
  "pztrti2",
  "pspttrs",
  "pclacon",
  "pcgesvx",
  "pzmax1",
  "zdttrsv",
  "pzhegs2",
  "pslaevswp",
  "pslapv2",
  "pzpocon",
  "pzgerq2",
  "pdlatrd",
  "pzgbtrs",
  "pdlacpy",
  "pdgetri",
  "pslaiect.c",
  "psgelqf",
  "pzgehrd",
  "cdbtf2",
  "pcunmbr",
  "pdorgql",
  "pclauu2",
  "psormbr",
  "pcgeqpf",
  "pdstedc",
  "pslabrd",
  "pclanhs",
  "pcgerfs",
  "slasrt2",
  "pdlawil",
  "pzstein",
  "pcunmrz",
  "pdpbtrf",
  "pstrrfs",
  "pzgesvx",
  "pzlacon",
  "psggqrf",
  "pclange",
  "pdorg2l",
  "psormrz",
  "pdpoequ",
  "pdlaqsy",
  "pcunmql",
  "pcpotri",
  "pclahqr",
  "zdbtf2",
  "psormql",
  "pzunmbr",
  "pzlauu2",
  "pdtzrzf",
  "pcpbtrsv",
  "psdbtrf",
  "psggrqf",
  "psgeequ",
  "pddttrsv",
  "pzgbsv",
  "pzrot.c",
  "pzgeqpf",
  "dlasorte",
  "pslapiv",
  "pdpotrf",
  "pzlanhs",
  "pzgerfs",
  "pcunm2l",
  "pspbtrsv",
  "pzunmrz",
  "pblas.h",
  "pslassq",
  "pdsytrd",
  "pssyttrd",
  "psorm2l",
  "pslarfg",
  "pzlange",
  "pclantr",
  "pdsygvx",
  "pclaconsb",
  "pslatra",
  "dpttrsv",
  "pzunmql",
  "pzpotri",
  "psgetrf",
  "pdlaswp",
  "pzlasmsub",
  "pzlahqr",
  "clanv2",
  "pcgbtrf",
  "pcgesv",
  "pdlabad",
  "pchegst",
  "pzdotc.c",
  "pzposv",
  "pdtrtrs",
  "pdgeqr2",
  "psgesv",
  "clamsh",
  "pzunm2l",
  "pslasmsub",
  "pcunglq",
  "pclanhe",
  "pcungl2",
  "pcheevd",
  "pssyevx",
  "pdormqr",
  "pssyntrd",
  "psorglq",
  "psorgl2",
  "pdtrti2",
  "pchetd2",
  "pcgetf2",
  "pzlantr",
  "pspbtrs",
  "pcpbsv",
  "pclarzb",
  "psgeqlf",
  "pspttrf",
  "pdpocon",
  "pdgerq2",
  "pdgbtrs",
  "pctrcon",
  "zlanv2",
  "pspbsv",
  "pdgehrd",
  "pzgbtrf",
  "pclatrz",
  "pdlaedz",
  "pzhegst",
  "pdormrq",
  "pdormr2",
  "pdorm2r",
  "pslasrt",
  "pcgelq2",
  "psgecon",
  "zlamsh",
  "pjlaenv",
  "pzunglq",
  "pzlanhe",
  "pzungl2",
  "pzhengst",
  "pzheevd",
  "pdstein",
  "pbchkvect.c",
  "pcgebrd",
  "pspotrs",
  "pzdbtrsv",
  "pzhetd2",
  "pdgesvx",
  "pdlacon",
  "pzgetf2",
  "pcdttrs",
  "pzlarzb",
  "psgebd2",
  "pcgeqrf",
  "pssyev",
  "cdttrsv",
  "pclarzc",
  "pztrcon",
  "ddbtf2",
  "pzlatrz",
  "sdttrsv",
  "psgesvd",
  "pdlauu2",
  "pzpttrsv",
  "pdlaiect.c",
  "pzgelq2",
  "pdormr3",
  "pdgeqpf",
  "pslamch",
  "pcgerqf",
  "sstein2",
  "pxsyevx.h",
  "pslatrs",
  "pclase2",
  "pdlanhs",
  "pdgerfs",
  "pzgebrd",
  "pdlared1d",
  "pslascl",
  "pcposvx",
  "pclarfb",
  "pzdttrs",
  "pdlange",
  "dlasrt2",
  "pclahrd",
  "pcgels",
  "pzgeqrf",
  "pdpotri",
  "pcdbsv",
  "pzdotu.c",
  "pclacp2",
  "pzlarzc",
  "pslauum",
  "cdttrf",
  "pctrtri",
  "pzlamr1d",
  "pdlahqr",
  "psgels",
  "pzheev",
  "psdbsv",
  "pclarf",
  "pslarf",
  "pslatrd",
  "pcungql",
  "pslacpy",
  "pdstebz",
  "pdormhr",
  "pcporfs",
  "psgetri",
  "pzgerqf",
  "pclarzt",
  "pzlase2",
  "psorgql",
  "pdgesv",
  "pzposvx",
  "claref",
  "slasorte",
  "pzlarfb",
  "pdpbtrsv",
  "pdlantr",
  "pzlahrd",
  "psstedc",
  "pclarfc",
  "pcung2l",
  "pslawil",
  "pzlacp2",
  "pdsyttrd",
  "zdttrf",
  "pztrtri",
  "pspbtrf",
  "pclacp3",
  "psorg2l",
  "pdgbtrf",
  "pspoequ",
  "pslaqsy",
  "pcgeql2",
  "pdpbsv",
  "pzungql",
  "pdlared2d",
  "pzporfs",
  "pzlarzt",
  "dlamsh",
  "ctrmvt",
  "pstzrzf",
  "zlaref",
  "pdsygs2",
  "pdgetf2",
  "pspotrf",
  "pdlarzb",
  "pcdbtrs",
  "pzlarfc",
  "pzung2l",
  "tools.h",
  "pdlaconsb",
  "pcdttrf",
  "pctrevc",
  "pdsyntrd",
  "pssytrd",
  "pdtrcon",
  "pdsyev",
  "zsteqr2",
  "pzlacp3",
  "pdorgqr",
  "pdlatrz",
  "pssygvx",
  "pzgeql2",
  "pslaswp",
  "pclarft",
  "pdgelq2",
  "pcrot.c",
  "pcheevx",
  "pslabad",
  "ztrmvt",
  "pcgetrs",
  "pdgebrd",
  "pchengst",
  "pclaqge",
  "pcpotf2",
  "pdorgrq",
  "pdorgr2",
  "pcptsv",
  "pdorg2r",
  "pstrtrs",
  "psgeqr2",
  "pddttrs",
  "pcunmqr",
  "pdormtr",
  "pcdbtrsv",
  "pzdbtrs",
  "pdgeqrf",
  "pclaset",
  "pzdttrf",
  "pztrevc",
  "psptsv",
  "psormqr",
  "cdbtrf",
  "pstrti2",
  "psdbtrsv",
  "pclansy",
  "pcgehd2",
  "pzgesv",
  "pdgels",
  "pspocon",
  "pddbsv",
  "pzlarft",
  "psgerq2",
  "psgbtrs",
  "pcpttrsv",
  "pcunmrq",
  "pcunm2r",
  "pcunmr2",
  "pdgerqf",
  "pzheevx",
  "ddttrsv",
  "pdlase2",
  "psgehrd",
  "pzgetrs",
  "pcpttrs",
  "pslaedz",
  "psormrq",
  "pdposvx",
  "pzlaqge",
  "psormr2",
  "psorm2r",
  "pclaevswp",
  "pzpotf2",
  "pspttrsv",
  "psrscl",
  "pclapv2",
  "dstein2",
  "pdlarf",
  "pdlaed0",
  "pdlarfb",
  "pzunmqr",
  "pdlahrd",
  "pslared1d",
  "pcgelqf",
  "pzlaset",
  "pzpbsv",
  "psstein",
  "pdlacp2",
  "dlapst",
  "ddttrf",
  "pdtrtri",
  "zdbtrf",
  "pslacon",
  "psgesvx",
  "pzlansy",
  "pzgehd2",
  "pclamr1d",
  "pclabrd",
  "pzunmrq",
  "pdporfs",
  "pzunm2r",
  "pzunmr2",
  "pdlarzt",
  "pslamr1d",
  "pctrrfs",
  "sdbtf2",
  "pzpttrs",
  "pcunmr3",
  "pcggqrf",
  "pslauu2",
  "dlaref",
  "pzlapv2",
  "pcdtsv",
  "psormr3",
  "psgeqpf",
  "pzgelqf",
  "pslanhs",
  "psgerfs",
  "pdlaed1",
  "psdtsv",
  "pcdbtrf",
  "pdlacp3",
  "pslange",
  "pcggrqf",
  "pcgeequ",
  "pclarz",
  "pdsygst",
  "pclapiv",
  "pdgeql2",
  "pzlabrd",
  "pspotri",
  "pclassq",
  "pslahqr",
  "pztrrfs",
  "pslarz",
  "pcunmhr",
  "pdsyevd",
  "pclarfg",
  "pzunmr3",
  "pzggqrf",
  "pslared2d",
  "dtrmvt",
  "pclatra",
  "pdsytd2",
  "psstebz",
  "psormhr",
  "pcgetrf",
  "pzlaconsb",
  "pzdttrsv",
  "pddbtrs",
  "pzgels",
  "pddttrf",
  "pzdbsv",
  "pzdbtrf",
  "pdlaed2",
  "pdormlq",
  "pdorml2",
  "pzggrqf",
  "pzgeequ",
  "pdptsv",
  "pslantr",
  "csteqr2",
  "pslaconsb",
  "pzlapiv",
  "pclasmsub",
  "Makefile",
  "pssyngst",
  "pdlarft",
  "zpttrsv",
  "pzlassq",
  "pzlarf",
  "pzunmhr",
  "ssteqr2",
  "pzlarfg",
  "psgbtrf",
  "pdgetrs",
  "pcpbtrs",
  "pdlaqge",
  "pzlatra",
  "pdpotf2",
  "pzgetrf",
  "pcgeqlf",
  "pcpttrf",
  "pdrscl",
  "slamsh",
  "pcmax1",
  "pchetrd",
  "pdlaset",
  "pchegvx",
  "pzhettrd",
  "ddbtrf",
  "pssygs2",
  "psgetf2",
  "pdlansy",
  "pdlaed3",
  "pslarzb",
  "pdgehd2",
  "pcgecon",
  "pcungqr",
  "pstrcon",
  "pddbtrsv",
  "pcpotrs",
  "psorgqr",
  "pslatrz",
  "pdpttrs",
  "pzpbtrs",
  "pcgebd2",
  "pzgeqlf",
  "pdlapv2",
  "pzpttrf",
  "psgelq2",
  "pcungrq",
  "pcung2r",
  "pcungr2",
  "pzhetrd",
  "pdgelqf",
  "psgebrd",
  "pdpttrsv",
  "pcunmtr",
  "pzhegvx",
  "pcgesvd",
  "psorgrq",
  "pzhentrd",
  "psorgr2",
  "psorg2r",
  "psdttrs",
  "pddtsv",
  "pzgecon",
  "pdormbr",
  "psormtr",
  "pzungqr",
  "psgeqrf",
  "pclatrs",
  "pdlabrd",
  "pcsrscl",
  "pclacgv",
  "pclascl",
  "pzpotrs",
  "pzlattrs",
  "zlahqr2",
  "pdtrrfs",
  "pcgbsv",
  "pdggqrf",
  "pdlarz",
  "pzgebd2",
  "pdormrz",
  "psgbsv",
  "pdlamr1d",
  "pdlaevswp",
  "pclauum",
  "pzptsv",
  "pzungrq",
  "psgerqf",
  "pzung2r",
  "pzungr2",
  "pslase2",
  "pdormql",
  "pzunmtr",
  "pzgesvd",
  "psposvx",
  "pddbtrf",
  "pslaed0",
  "pslarfb",
  "pclatrd",
  "pdgeequ",
  "pdggrqf",
  "pclacpy",
  "pslahrd",
  "pcgetri",
  "pdlapiv",
  "pzlatrs",
  "pslacp2",
  "pzlacgv",
  "sdttrf",
  "slapst",
  "pstrtri",
  "pdlassq",
  "pzlascl",
  "pcposv",
  "pdorm2l",
  "pdlarfg",
  "pdlatra",
  "pzaxpy.c",
  "psposv",
  "pclawil",
  "pdgetrf",
  "psporfs",
  "pzlauum",
  "pslarzt",
  "pcpbtrf",
  "pcdttrsv",
  "pcpoequ",
  "pclaqsy",
  "slaref",
  "pzlatrd",
  "pzlacpy",
  "pzgetri",
  "pslaed1",
  "psdttrsv",
  "pzpbtrsv",
  "pscsum1",
  "pdsyevx",
  "pctzrzf",
  "pslacp3",
  "cpttrsv",
  "pdorglq",
  "pdorgl2",
  "pdsyngst",
  "pssygst",
  "psgeql2",
  "pcpotrf",
  "pdpbtrs",
  "pdgeqlf",
  "pzlawil",
  "pdpttrf",
  "dsteqr2",
  "spttrsv",
  "pzpbtrf",
  "pzdtsv",
  "getpbbuf.c",
  "pssyevd",
  "strmvt",
  "pdzsum1",
  "pzlaqsy",
  "pzpoequ",
  "pssytd2",
  "pclaswp",
  "pdlasrt",
  "pchettrd",
  "pcunmlq",
  "pdgecon",
  "pcunml2",
  "psdbtrs",
  "pzlarz",
  "psdttrf",
  "pztzrzf",
  "pslaed2",
  "pdlasmsub",
  "pdpotrs",
  "psormlq",
  "psorml2",
  "pctrtrs",
  "pcgeqr2",
  "pzpotrf",
  "pdgebd2",
  "pslarft",
  "pdgbsv",
  "psgetrs",
  "pctrti2",
  "pchegs2",
  "pslaqge",
  "pdgesvd",
  "pspotf2",
  "pzlaswp",
  "pcpocon",
  "pcgerq2",
  "pcgbtrs",
  "pzunmlq",
  "pchentrd",
  "pzunml2",
  "pdlamch",
  "pdlatrs",
  "pcheev",
  "pslaset",
  "pcgehrd",
  "pzdrscl",
  "pdlascl",
  "sdbtrf",
  "pztrtrs",
  "pslansy",
  "pzgeqr2"]

re_f90 = re.compile("\.[Ff]90")
sub_calls = list()

# Extract subroutine calls
for (root, dirs, files) in os.walk("src"):
  for src in files:
    if ( re_f90.search(src) ):
      src_data = file(os.path.join(root,src)).readlines()
      for line in src_data:
        line = line.split()
        try:
          if ( line[0].lower() == "call" ):
            sub_calls.append(re.sub("\\(.*","",line[1]).lower())
        except:
          prout = 0

# Identify BLAS and LAPACK calls
blas_count = dict()
lapack_count = dict()
blacs_count = dict()
scalapack_count = dict()
for csub in sub_calls:
  for bsub in blas_routines:
    if ( bsub == csub ):
      if ( csub in blas_count ):
        blas_count[csub] += 1
      else:
        blas_count[csub] = 1
  for lsub in lapack_routines:
    if ( lsub == csub ):
      if ( csub in lapack_count ):
        lapack_count[csub] += 1
      else:
        lapack_count[csub] = 1
  for psub in blacs_routines:
    if ( psub == csub ):
      if ( csub in blacs_count ):
        blacs_count[csub] += 1
      else:
        blacs_count[csub] = 1
  for ssub in scalapack_routines:
    if ( ssub == csub ):
      if ( csub in scalapack_count ):
        scalapack_count[csub] += 1
      else:
        scalapack_count[csub] = 1

# Display results
print "Linear algebra statistics for Abinit"
print ""
print "BLAS use: %.1f%%" % (100.0*len(blas_count)/len(blas_routines))
print ""
print "BLAS routine            Count"
print "--------------------    -----"
for csub in blas_count:
  print "%-20s    %5i" % (csub,blas_count[csub])
print ""

print "LAPACK use: %.1f%%" % (100.0*len(lapack_count)/len(lapack_routines))
print ""
print "LAPACK routine          Count"
print "--------------------    -----"
for csub in lapack_count:
  print "%-20s    %5i" % (csub,lapack_count[csub])
print ""

print "BLACS use: %.1f%%" % (100.0*len(blacs_count)/len(blacs_routines))
print ""
print "BLACS routine           Count"
print "--------------------    -----"
for csub in blacs_count:
  print "%-20s    %5i" % (csub,blacs_count[csub])
print ""

print "ScaLAPACK use: %.1f%%" % (100.0*len(scalapack_count)/len(scalapack_routines))
print ""
print "ScaLAPACK routine       Count"
print "--------------------    -----"
for csub in scalapack_count:
  print "%-20s    %5i" % (csub,scalapack_count[csub])
print ""

